/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.dependency;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.EnvironmentContributingAction;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.List;

public class GerritDependencyAction
extends InvisibleAction
implements EnvironmentContributingAction {
    @NonNull
    private final List<String> deps;

    public GerritDependencyAction(List<Run> runs) {
        this.deps = new ArrayList<String>(runs.size());
        for (Run run : runs) {
            this.deps.add(run.getParent().getFullName() + "#" + run.getNumber() + "#" + run.getResult());
        }
    }

    public void buildEnvironment(@NonNull Run<?, ?> run, @NonNull EnvVars env) {
        this.fillEnv(env);
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        this.fillEnv(env);
    }

    private void fillEnv(EnvVars env) {
        StringBuilder depKeys = new StringBuilder();
        for (String dependency : this.deps) {
            String[] tokens = dependency.split("#");
            String originalName = tokens[0];
            String number = tokens[1];
            String result = tokens[2];
            String keyName = originalName.replaceAll("[^a-zA-Z0-9]+", "_");
            String prefix = "TRIGGER_" + keyName;
            env.put(prefix + "_BUILD_NAME", originalName);
            env.put(prefix + "_BUILD_NUMBER", number);
            env.put(prefix + "_BUILD_RESULT", result);
            depKeys.append(keyName);
            depKeys.append(" ");
        }
        env.put("TRIGGER_DEPENDENCY_KEYS", depKeys.toString().trim());
    }
}

