/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.dependency;

import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.dependency.BecauseDependentBuildIsBuilding;
import com.sonyericsson.hudson.plugins.gerrit.trigger.dependency.BecauseWaitingForOtherProjectsToTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.dependency.BecauseWaitingToEnsureOtherJobsAreInQueue;
import com.sonyericsson.hudson.plugins.gerrit.trigger.dependency.GerritDependencyAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.lifecycle.GerritEventLifecycle;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.lifecycle.GerritEventLifecycleListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import com.sonymobile.tools.gerrit.gerritevents.GerritHandler;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public final class DependencyQueueTaskDispatcher
extends QueueTaskDispatcher
implements GerritEventLifecycleListener,
GerritEventListener {
    private static final Logger logger = LoggerFactory.getLogger(DependencyQueueTaskDispatcher.class);
    private Set<GerritTriggeredEvent> currentlyTriggeringEvents = Collections.newSetFromMap(new ConcurrentHashMap());

    public DependencyQueueTaskDispatcher() {
        this(PluginImpl.getHandler_());
    }

    DependencyQueueTaskDispatcher(GerritHandler gerritHandler) {
        if (gerritHandler == null) {
            logger.error("Gerrit Handler was not available to construct DependencyQueueTaskDispatcher");
        } else {
            gerritHandler.addListener((GerritEventListener)this);
        }
        logger.debug("Registered to gerrit events");
    }

    public static DependencyQueueTaskDispatcher getInstance() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            logger.error("INITIALIZATION ERROR? Could not find the Jenkins instance.");
            return null;
        }
        ExtensionList dispatchers = jenkins.getExtensionList(DependencyQueueTaskDispatcher.class);
        if (dispatchers == null || dispatchers.isEmpty()) {
            logger.error("INITIALIZATION ERROR? Could not find the registered instance.");
            return null;
        }
        return (DependencyQueueTaskDispatcher)dispatchers.get(0);
    }

    public CauseOfBlockage canRun(Queue.Item item) {
        if (!(item.task instanceof Job)) {
            logger.debug("Not an Job instance: {}", (Object)item.task);
            return null;
        }
        GerritCause cause = this.getGerritCause(item);
        if (cause == null) {
            logger.debug("Not Gerrit cause for {}", (Object)item);
            return null;
        }
        GerritTriggeredEvent event = cause.getEvent();
        if (event == null) {
            logger.debug("{} does not contain an event", (Object)item);
            return null;
        }
        if (item.isBuildable()) {
            logger.debug("{} is already buildable for {}", (Object)item, (Object)event);
            return null;
        }
        Job p = (Job)item.task;
        GerritTrigger trigger = GerritTrigger.getTrigger(p);
        if (trigger == null) {
            logger.debug("Project {} does not contain a trigger", (Object)p);
            return null;
        }
        List<Job> dependencies = DependencyQueueTaskDispatcher.getProjectsFromString(trigger.getDependencyJobsNames(), (Item)p);
        if (dependencies == null || dependencies.isEmpty()) {
            logger.debug("No dependencies on project: {} for event {}", (Object)p, (Object)event);
            return null;
        }
        long inQueueSince = item.getInQueueSince();
        if (System.currentTimeMillis() - inQueueSince < TimeUnit.SECONDS.toMillis(3L)) {
            logger.debug("We need to wait to ensure dependent jobs {} are in queue for {}", (Object)event, (Object)p);
            return new BecauseWaitingToEnsureOtherJobsAreInQueue();
        }
        if (this.currentlyTriggeringEvents.contains(event)) {
            logger.debug("We need to wait while {} is being triggered for {}", (Object)event, (Object)p);
            return new BecauseWaitingForOtherProjectsToTrigger();
        }
        CauseOfBlockage causeOfBlockage = this.getCauseOfBlockage(dependencies, event);
        if (causeOfBlockage != null) {
            return causeOfBlockage;
        }
        ToGerritRunListener toGerritRunListener = ToGerritRunListener.getInstance();
        if (toGerritRunListener != null) {
            List<Run> parentRuns = toGerritRunListener.getRuns(event);
            if (parentRuns == null) {
                logger.info("All dependencies for event: {} on project: {}, are triggered in silent mode. Can not get list of actual dependencies", (Object)event, (Object)p);
                return null;
            }
            if (parentRuns.isEmpty()) {
                logger.info("Project {} has dependencies, but does not have known runs for {}", (Object)p, (Object)event);
                return null;
            }
            ArrayList<Run> actualDependencies = new ArrayList<Run>(dependencies.size());
            for (Run run : parentRuns) {
                if (!dependencies.contains(run.getParent())) continue;
                actualDependencies.add(run);
            }
            if (actualDependencies.isEmpty()) {
                logger.info("Project {} has dependencies, but all of them are not interested in event {}", (Object)p, (Object)event);
                return null;
            }
            item.replaceAction((Action)new GerritDependencyAction(actualDependencies));
        }
        logger.info("No active dependencies on project: {} for event: {}, it will now build", (Object)p, (Object)event);
        return null;
    }

    private CauseOfBlockage getCauseOfBlockage(List<Job> dependencies, GerritTriggeredEvent event) {
        ToGerritRunListener toGerritRunListener = ToGerritRunListener.getInstance();
        if (toGerritRunListener != null) {
            for (Job dependency : dependencies) {
                if (toGerritRunListener.isTriggered(dependency, event)) {
                    if (!toGerritRunListener.isBuilding(dependency, event)) continue;
                    return new BecauseDependentBuildIsBuilding(dependency);
                }
                GerritTrigger gerritTrigger = GerritTrigger.getTrigger(dependency);
                if (gerritTrigger == null || !gerritTrigger.isInteresting(event)) continue;
                return new BecauseWaitingForOtherProjectsToTrigger();
            }
        }
        return null;
    }

    private GerritCause getGerritCause(Queue.Item item) {
        for (Cause cause : item.getCauses()) {
            if (!(cause instanceof GerritCause)) continue;
            return (GerritCause)cause;
        }
        return null;
    }

    public static List<Job> getProjectsFromString(String projects, Item context) {
        ArrayList<Job> dependencyJobs = new ArrayList<Job>();
        if (StringUtils.isEmpty((String)projects)) {
            return null;
        }
        Jenkins jenkins = Jenkins.get();
        StringTokenizer tokens = new StringTokenizer(projects, ",");
        while (tokens.hasMoreTokens()) {
            Item item;
            String projectName = tokens.nextToken().trim();
            if (projectName.isEmpty() || (item = jenkins.getItem(projectName, context, Item.class)) == null || !(item instanceof Job)) continue;
            dependencyJobs.add((Job)item);
            logger.debug("project dependency job added : {}", (Object)item);
        }
        return dependencyJobs;
    }

    public void onTriggeringAll(GerritTriggeredEvent event) {
        this.currentlyTriggeringEvents.add(event);
        logger.debug("Triggering all projects for {}", (Object)event);
    }

    public void onDoneTriggeringAll(GerritTriggeredEvent event) {
        this.currentlyTriggeringEvents.remove(event);
        logger.debug("Done triggering all projects for {}", (Object)event);
    }

    public void gerritEvent(GerritEvent event) {
        if (event instanceof GerritEventLifecycle) {
            logger.debug("registering to lifecycle");
            ((GerritEventLifecycle)event).addListener(this);
            if (event instanceof GerritTriggeredEvent) {
                this.onTriggeringAll((GerritTriggeredEvent)event);
            }
        }
    }

    @Override
    public void triggerScanStarting(GerritEvent event) {
    }

    @Override
    public void triggerScanDone(GerritEvent event) {
        logger.debug("trigger scan done");
        if (event instanceof GerritTriggeredEvent) {
            this.onDoneTriggeringAll((GerritTriggeredEvent)event);
        }
        ((GerritEventLifecycle)event).removeListener(this);
    }

    @Override
    public void projectTriggered(GerritEvent event, Job project) {
    }

    @Override
    public void buildStarted(GerritEvent event, Run build) {
    }

    @Override
    public void buildCompleted(GerritEvent event, Run build) {
    }

    @Override
    public void allBuildsCompleted(GerritEvent event) {
    }
}

