/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritDynamicUrlProcessor;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerTimer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritProject;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DynamicConfigurationCacheProxy {
    private static final DynamicConfigurationCacheProxy CACHE_PROXY = new DynamicConfigurationCacheProxy();
    private final Map<String, List<GerritProject>> cache = new HashMap<String, List<GerritProject>>();
    private static final Logger logger = LoggerFactory.getLogger(DynamicConfigurationCacheProxy.class);
    private final Map<String, Long> ttl = new HashMap<String, Long>();

    private DynamicConfigurationCacheProxy() {
    }

    synchronized List<GerritProject> fetchThroughCache(String url) throws IOException, ParseException {
        if (this.cache.containsKey(url) && !this.isExpired(url)) {
            logger.debug("Get dynamic projects from cache for URL: " + url);
            for (String keyUrl : this.ttl.keySet()) {
                if (!this.isExpired(keyUrl)) continue;
                this.ttl.remove(keyUrl);
                this.cache.remove(keyUrl);
                logger.trace("Removing {} from cache", (Object)keyUrl);
            }
            return this.cache.get(url);
        }
        logger.info("Get dynamic projects directly for URL: {}", (Object)url);
        List<GerritProject> gerritProjects = GerritDynamicUrlProcessor.fetch(url);
        this.ttl.put(url, System.currentTimeMillis());
        this.cache.put(url, gerritProjects);
        return gerritProjects;
    }

    static DynamicConfigurationCacheProxy getInstance() {
        return CACHE_PROXY;
    }

    private boolean isExpired(String url) {
        Long lastTimeUpdated = this.ttl.get(url);
        if (lastTimeUpdated == null) {
            lastTimeUpdated = System.currentTimeMillis();
        }
        long updateInterval = GerritTriggerTimer.getInstance().calculateAverageDynamicConfigRefreshInterval();
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - lastTimeUpdated) > updateInterval;
    }

    void clear() {
        this.ttl.clear();
        this.cache.clear();
    }
}

