/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.job.rest;

import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ParameterExpander;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Notify;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ReviewInput;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ReviewLabel;
import com.sonymobile.tools.gerrit.gerritevents.rest.RestConnectionConfig;
import com.sonymobile.tools.gerrit.gerritevents.workers.rest.AbstractRestCommandJob;
import hudson.model.Run;
import hudson.model.TaskListener;

public class BuildStartedRestCommandJob
extends AbstractRestCommandJob {
    private final Run build;
    private final BuildsStartedStats stats;
    private final TaskListener listener;
    private final ParameterExpander parameterExpander;

    public BuildStartedRestCommandJob(IGerritHudsonTriggerConfig config, Run build, TaskListener listener, ChangeBasedEvent event, BuildsStartedStats stats) {
        super((RestConnectionConfig)config, listener != null ? listener.getLogger() : null, event);
        this.build = build;
        this.stats = stats;
        this.listener = listener;
        this.parameterExpander = new ParameterExpander(config);
    }

    protected ReviewInput createReview() {
        String message = this.parameterExpander.getBuildStartedMessage(this.build, this.listener, this.event, this.stats);
        Notify notificationLevel = Notify.ALL;
        GerritTrigger trigger = GerritTrigger.getTrigger(this.build.getParent());
        if (trigger != null) {
            notificationLevel = this.parameterExpander.getNotificationLevel(trigger);
        }
        return new ReviewInput(message, new ReviewLabel[0]).setNotify(notificationLevel).setTag("autogenerated:jenkins-gerrit-trigger");
    }
}

