/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier;

import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.extensions.GerritTriggeredBuildListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ParameterExpander;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildsStartedStats;
import com.sonymobile.tools.gerrit.gerritevents.GerritCmdRunner;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritNotifier {
    private static final Logger logger = LoggerFactory.getLogger(GerritNotifier.class);
    private GerritCmdRunner cmdRunner;
    private ParameterExpander parameterExpander;

    public GerritNotifier(IGerritHudsonTriggerConfig config, GerritCmdRunner cmdRunner) {
        this.cmdRunner = cmdRunner;
        this.parameterExpander = new ParameterExpander(config);
    }

    public GerritNotifier(IGerritHudsonTriggerConfig config, GerritCmdRunner cmdRunner, Hudson hudson) {
        this.cmdRunner = cmdRunner;
        this.parameterExpander = new ParameterExpander(config, (Jenkins)hudson);
    }

    public void buildStarted(Run build, TaskListener taskListener, GerritTriggeredEvent event, BuildsStartedStats stats) {
        try {
            if (event instanceof ChangeBasedEvent) {
                String command = this.parameterExpander.getBuildStartedCommand(build, taskListener, (ChangeBasedEvent)event, stats);
                if (command != null) {
                    if (!command.isEmpty()) {
                        logger.debug("Notifying BuildStarted to gerrit: {}", (Object)command);
                        this.cmdRunner.sendCommand(command);
                        GerritTriggeredBuildListener.fireOnStarted(event, command);
                    } else {
                        logger.debug("BuildStarted command is empty. Gerrit will not be notified of BuildStarted");
                    }
                } else {
                    logger.error("Something wrong during parameter extraction. Gerrit will not be notified of BuildStarted");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Could not complete BuildStarted notification!", (Throwable)ex);
        }
    }

    public void buildCompleted(BuildMemory.MemoryImprint memoryImprint, TaskListener listener) {
        try {
            if (memoryImprint.getEvent() instanceof ChangeBasedEvent) {
                String command = this.parameterExpander.getBuildCompletedCommand(memoryImprint, listener);
                if (command != null) {
                    if (!command.isEmpty()) {
                        logger.debug("Notifying BuildCompleted to gerrit: {}", (Object)command);
                        this.cmdRunner.sendCommand(command);
                        GerritTriggeredBuildListener.fireOnCompleted(memoryImprint, command);
                    } else {
                        logger.debug("BuildCompleted command is empty. Gerrit will not be notified of BuildCompleted");
                    }
                } else {
                    logger.error("Something wrong during parameter extraction. Gerrit will not be notified of BuildCompleted");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Could not complete BuildCompleted notification!", (Throwable)ex);
        }
    }
}

