/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.version;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.GerritVersionNumber;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.HighestVersionNumber;
import hudson.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritVersionChecker {
    private static final Logger logger = LoggerFactory.getLogger(GerritVersionChecker.class);

    private GerritVersionChecker() {
    }

    public static boolean isCorrectVersion(Feature feature, String serverName) {
        if (PluginImpl.getInstance() != null) {
            if (serverName == null || serverName.isEmpty() || "__ANY__".equals(serverName)) {
                for (GerritServer server : PluginImpl.getServers_()) {
                    GerritVersionNumber gerritVersion = GerritVersionChecker.createVersionNumber(server.getGerritVersion());
                    if (!GerritVersionChecker.isCorrectVersion(gerritVersion, feature)) continue;
                    return true;
                }
                return false;
            }
            GerritVersionNumber gerritVersion = GerritVersionChecker.createVersionNumber(GerritVersionChecker.getGerritVersion(serverName));
            return GerritVersionChecker.isCorrectVersion(gerritVersion, feature);
        }
        return false;
    }

    public static boolean isCorrectVersion(Feature feature, String serverName, boolean excludeSnapshotVersions) {
        if (PluginImpl.getInstance() != null) {
            if (serverName == null || serverName.isEmpty() || "__ANY__".equals(serverName)) {
                for (GerritServer server : PluginImpl.getServers_()) {
                    GerritVersionNumber gerritVersion = GerritVersionChecker.createVersionNumber(server.getGerritVersion());
                    if (!GerritVersionChecker.isCorrectVersion(gerritVersion, feature, excludeSnapshotVersions)) continue;
                    return true;
                }
                return false;
            }
            GerritVersionNumber gerritVersion = GerritVersionChecker.createVersionNumber(GerritVersionChecker.getGerritVersion(serverName));
            return GerritVersionChecker.isCorrectVersion(gerritVersion, feature, excludeSnapshotVersions);
        }
        return false;
    }

    private static String getGerritVersion(String serverName) {
        GerritServer server = PluginImpl.getServer_(serverName);
        if (server != null) {
            String version = server.getGerritVersion();
            if (version != null) {
                return version;
            }
            logger.error("Could not find the Gerrit version for {}", (Object)serverName);
        } else {
            logger.error("Could not find the server {}", (Object)serverName);
        }
        return null;
    }

    public static boolean isCorrectVersion(GerritVersionNumber gerritVersion, Feature feature, boolean excludeSnapshotVersions) {
        if (excludeSnapshotVersions) {
            return !feature.versionNumber.isNewerThan((VersionNumber)gerritVersion);
        }
        return gerritVersion.isSnapshot() || !feature.versionNumber.isNewerThan((VersionNumber)gerritVersion);
    }

    public static boolean isCorrectVersion(GerritVersionNumber gerritVersion, Feature feature) {
        return GerritVersionChecker.isCorrectVersion(gerritVersion, feature, false);
    }

    public static GerritVersionNumber createVersionNumber(String version) {
        if (version == null || version.isEmpty()) {
            logger.error("Gerrit version number is null or the empty string.");
            return new HighestVersionNumber();
        }
        return GerritVersionNumber.getGerritVersionNumber(version);
    }

    public static enum Feature {
        fileTrigger("Trigger on files", "2.3"),
        triggerOnDraftPublished("Trigger on draft published", "2.5"),
        replicationEvents("Replication events", "2.9"),
        projectCreatedEvents("Project created events", "2.12"),
        commentAlwaysApproval("CommentAdded always contains approval", "2.13");

        private final String displayName;
        private final String version;
        private final VersionNumber versionNumber;

        private Feature(String displayName, String version) {
            this.displayName = displayName;
            this.version = version;
            this.versionNumber = new VersionNumber(version);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

