/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.playback;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.NamedGerritEventListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.playback.EventTimeSlice;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.GerritPluginChecker;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.HttpUtils;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import com.sonymobile.tools.gerrit.gerritevents.ConnectionListener;
import com.sonymobile.tools.gerrit.gerritevents.GerritJsonEventFactory;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritJsonEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.Util;
import hudson.XmlFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritMissedEventsPlaybackManager
implements ConnectionListener,
NamedGerritEventListener {
    private static final String GERRIT_SERVER_EVENT_DATA_FOLDER = "/gerrit-server-event-data/";
    private static final Logger logger = LoggerFactory.getLogger(GerritMissedEventsPlaybackManager.class);
    static final String EVENTS_LOG_PLUGIN_NAME = "events-log";
    private static final String EVENTS_LOG_PLUGIN_URL = "a/plugins/events-log/events/";
    private static final String GERRIT_TRIGGER_SERVER_TIMESTAMPS_XML = "gerrit-trigger-server-timestamps.xml";
    private String serverName;
    protected EventTimeSlice serverTimestamp = null;
    private static long previousTimeSlice = 0L;
    protected List<GerritTriggeredEvent> receivedEventCache = Collections.synchronizedList(new ArrayList());
    private boolean isSupported = false;
    private boolean playBackComplete = false;
    private boolean previousIsSupported;
    private GerritMissedEventsPlaybackPersistRunnable persistenceCheck;

    public GerritMissedEventsPlaybackManager(String name) {
        this.serverName = name;
        this.checkIfEventsLogPluginSupported();
        this.previousIsSupported = this.isSupported;
        this.persistenceCheck = new GerritMissedEventsPlaybackPersistRunnable();
    }

    private void startPersistenceCheck() {
        previousTimeSlice = 0L;
        this.persistenceCheck.start();
    }

    private void stopPersistenceCheck() {
        this.persistenceCheck.stop();
    }

    public void performCheck() throws IOException {
        if (this.playBackComplete) {
            this.checkIfEventsLogPluginSupported();
            if (this.previousIsSupported && !this.isSupported) {
                logger.warn("Missed Events Playback used to be supported. now it is not!");
                try {
                    XmlFile config = GerritMissedEventsPlaybackManager.getConfigXml(this.serverName);
                    if (config != null) {
                        config.delete();
                        logger.warn("Deleting " + config.getFile().getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                this.stopPersistenceCheck();
            }
            if (!this.previousIsSupported && this.isSupported) {
                logger.warn("Missed Events Playback used to be NOT supported. now it IS!");
            }
            if (this.previousIsSupported != this.isSupported) {
                this.previousIsSupported = this.isSupported;
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void checkIfEventsLogPluginSupported() {
        GerritServer server = PluginImpl.getServer_(this.serverName);
        if (server != null && server.getConfig() != null) {
            Boolean newValue = GerritPluginChecker.isPluginEnabled(server.getConfig(), EVENTS_LOG_PLUGIN_NAME, true);
            if (newValue == null) {
                logger.warn("Could not determine plugin support for events-log; leaving status as " + String.valueOf(this.isSupported));
            } else {
                this.isSupported = newValue;
            }
        }
    }

    protected void load() throws IOException {
        XmlFile xml = GerritMissedEventsPlaybackManager.getConfigXml(this.serverName);
        this.serverTimestamp = xml != null && xml.exists() ? (EventTimeSlice)xml.unmarshal((Object)this.serverTimestamp) : null;
    }

    protected synchronized Date getDateFromTimestamp() {
        if (this.serverTimestamp != null) {
            Date myDate = new Date(this.serverTimestamp.getTimeSlice());
            logger.debug("Previous alive timestamp was: {}", (Object)myDate);
            return myDate;
        }
        return new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionEstablished() {
        this.playBackComplete = false;
        this.checkIfEventsLogPluginSupported();
        if (!this.isSupported) {
            logger.warn("Playback of missed events not supported for server {}!", (Object)this.serverName);
            this.playBackComplete = true;
            return;
        }
        logger.debug("Connection Established!");
        try {
            this.load();
        }
        catch (IOException e) {
            logger.error("Failed to load in timestamps for server {}", (Object)this.serverName);
            logger.error("Exception: {}", (Object)e.getMessage(), (Object)e);
            this.playBackComplete = true;
            return;
        }
        Date timeStampDate = this.getDateFromTimestamp();
        long diff = System.currentTimeMillis() - timeStampDate.getTime();
        if (diff > 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Non-zero date range from last-alive timestamp exists for server {} : {}", (Object)this.serverName, (Object)Util.getPastTimeString((long)diff));
            }
        } else {
            logger.debug("Zero date range from last-alive timestamp for server {}", (Object)this.serverName);
            this.playBackComplete = true;
            return;
        }
        try {
            List<GerritTriggeredEvent> events = this.getEventsFromDateRange(timeStampDate);
            logger.info("({}) missed events to process for server: {} ...", (Object)events.size(), (Object)this.serverName);
            for (GerritTriggeredEvent evt : events) {
                logger.debug("({}) Processing missed event {}", (Object)this.serverName, (Object)evt);
                boolean receivedEvtFound = false;
                List<GerritTriggeredEvent> list = this.receivedEventCache;
                synchronized (list) {
                    for (GerritTriggeredEvent rEvt : this.receivedEventCache) {
                        if (!rEvt.equals(evt)) continue;
                        receivedEvtFound = true;
                        break;
                    }
                }
                if (receivedEvtFound) {
                    logger.debug("({}) Event already triggered...skipping trigger.", (Object)this.serverName);
                    continue;
                }
                long currentEventCreatedTime = evt.getEventCreatedOn().getTime();
                if (this.serverTimestamp.getTimeSlice() == currentEventCreatedTime && this.serverTimestamp.getEvents().contains(evt)) {
                    logger.debug("({}) Event already triggered from time slice...skipping trigger.", (Object)this.serverName);
                    continue;
                }
                logger.info("({}) Triggering: {}", (Object)this.serverName, (Object)evt);
                GerritServer server = PluginImpl.getServer_(this.serverName);
                if (server == null) {
                    logger.error("Server for {} could not be found. Skipping this event", (Object)this.serverName);
                    continue;
                }
                server.triggerEvent((GerritEvent)evt);
                this.receivedEventCache.add(evt);
                logger.debug("Added event {} to received cache for server: {}", (Object)evt, (Object)this.serverName);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Error building URL for playback query: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error accessing URL for playback query: " + e.getMessage(), (Throwable)e);
        }
        this.playBackComplete = true;
        logger.info("Processing completed for server: {}", (Object)this.serverName);
    }

    public void connectionDown() {
        logger.info("connectionDown for server: {}", (Object)this.serverName);
        this.stopPersistenceCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gerritEvent(GerritEvent event) {
        if (!this.isSupported()) {
            return;
        }
        if (!this.persistenceCheck.isRunning()) {
            this.startPersistenceCheck();
        }
        if (event instanceof GerritTriggeredEvent) {
            logger.debug("Recording timestamp due to an event {} for server: {}", (Object)event, (Object)this.serverName);
            GerritTriggeredEvent triggeredEvent = (GerritTriggeredEvent)event;
            this.saveTimestamp(triggeredEvent);
            if (!this.playBackComplete) {
                boolean receivedEvtFound = false;
                GerritMissedEventsPlaybackManager gerritMissedEventsPlaybackManager = this;
                synchronized (gerritMissedEventsPlaybackManager) {
                    for (GerritTriggeredEvent rEvt : this.receivedEventCache) {
                        if (!rEvt.equals(triggeredEvent)) continue;
                        receivedEvtFound = true;
                        break;
                    }
                }
                if (!receivedEvtFound) {
                    this.receivedEventCache.add(triggeredEvent);
                    logger.debug("Added event {} to received cache for server: {}", (Object)event, (Object)this.serverName);
                } else {
                    logger.debug("Event {} ALREADY in received cache for server: {}", (Object)event, (Object)this.serverName);
                }
            } else {
                this.receivedEventCache = Collections.synchronizedList(new ArrayList());
                logger.debug("Playback complete...will NOT add event {} to received cache for server: {}", (Object)event, (Object)this.serverName);
            }
        }
    }

    protected List<GerritTriggeredEvent> getEventsFromDateRange(Date lowerDate) throws IOException {
        GerritServer server = PluginImpl.getServer_(this.serverName);
        if (server == null) {
            logger.error("Server for {} could not be found.", (Object)this.serverName);
            return Collections.synchronizedList(new ArrayList());
        }
        IGerritHudsonTriggerConfig config = server.getConfig();
        String events = this.getEventsFromEventsLogPlugin(config, this.buildEventsLogURL(config, lowerDate));
        return this.createEventsFromString(events);
    }

    private List<GerritTriggeredEvent> createEventsFromString(String eventsString) {
        List<GerritTriggeredEvent> events = Collections.synchronizedList(new ArrayList());
        Scanner scanner = new Scanner(eventsString);
        while (scanner.hasNextLine()) {
            JSONObject jsonObject;
            block4: {
                String line = scanner.nextLine();
                logger.debug("found line: {}", (Object)line);
                jsonObject = null;
                try {
                    jsonObject = GerritJsonEventFactory.getJsonObjectIfInterestingAndUsable((String)line);
                    if (jsonObject == null) {
                    }
                    break block4;
                }
                catch (Exception ex) {
                    logger.warn("Unanticipated error when creating DTO representation of JSON string.", (Throwable)ex);
                }
                continue;
            }
            GerritJsonEvent evt = GerritJsonEventFactory.getEvent((JSONObject)jsonObject);
            if (!(evt instanceof GerritTriggeredEvent)) continue;
            Provider provider = new Provider();
            provider.setName(this.serverName);
            ((GerritTriggeredEvent)evt).setProvider(provider);
            events.add((GerritTriggeredEvent)evt);
        }
        scanner.close();
        return events;
    }

    protected String getEventsFromEventsLogPlugin(IGerritHudsonTriggerConfig config, String url) {
        logger.debug("({}) Going to GET: {}", (Object)this.serverName, (Object)url);
        CloseableHttpResponse execute = null;
        try {
            execute = HttpUtils.performHTTPGet(config, url);
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return "";
        }
        int statusCode = execute.getStatusLine().getStatusCode();
        logger.debug("Received status code: {} for server: {}", (Object)statusCode, (Object)this.serverName);
        if (statusCode == 200) {
            try {
                HttpEntity entity = execute.getEntity();
                if (entity != null) {
                    Charset charset;
                    ContentType contentType = ContentType.get((HttpEntity)entity);
                    if (contentType == null) {
                        contentType = ContentType.DEFAULT_TEXT;
                    }
                    if ((charset = contentType.getCharset()) == null) {
                        charset = Charset.defaultCharset();
                    }
                    InputStream bodyStream = entity.getContent();
                    String body = IOUtils.toString((InputStream)bodyStream, (String)charset.name());
                    logger.debug(body);
                    return body;
                }
            }
            catch (IOException ioe) {
                logger.warn(ioe.getMessage(), (Throwable)ioe);
            }
        }
        logger.warn("Not successful at requesting missed events from {} plugin. (errorcode: {})", (Object)EVENTS_LOG_PLUGIN_NAME, (Object)statusCode);
        return "";
    }

    protected String buildEventsLogURL(IGerritHudsonTriggerConfig config, Date date1) throws UnsupportedEncodingException {
        String gerritFrontEndUrl;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String url = "a/plugins/events-log/events/?t1=" + URLEncoder.encode(df.format(date1), "UTF-8");
        String restUrl = gerritFrontEndUrl = config.getGerritFrontEndUrl();
        if (gerritFrontEndUrl != null && !gerritFrontEndUrl.endsWith("/")) {
            restUrl = gerritFrontEndUrl + "/";
        }
        return restUrl + url;
    }

    synchronized boolean saveTimestamp(GerritTriggeredEvent evt) {
        if (evt == null || evt.getEventCreatedOn() == null) {
            logger.debug("'eventCreatedOn' is null; skipping event.");
            return false;
        }
        long ts = evt.getEventCreatedOn().getTime();
        if (ts == 0L) {
            logger.debug("'eventCreatedOn' is 0; skipping event.");
            return false;
        }
        if (this.serverTimestamp != null && ts < this.serverTimestamp.getTimeSlice()) {
            logger.debug("Event has same time slice {} or is earlier...NOT Updating time slice.", (Object)ts);
            return false;
        }
        if (this.serverTimestamp == null) {
            this.serverTimestamp = new EventTimeSlice(ts);
            this.serverTimestamp.addEvent(evt);
        } else if (ts > this.serverTimestamp.getTimeSlice()) {
            logger.debug("Current timestamp {} is GREATER than slice time {}.", (Object)ts, (Object)this.serverTimestamp.getTimeSlice());
            this.serverTimestamp = new EventTimeSlice(ts);
            this.serverTimestamp.addEvent(evt);
        } else if (ts == this.serverTimestamp.getTimeSlice()) {
            logger.debug("Current timestamp {} is EQUAL to slice time {}.", (Object)ts, (Object)this.serverTimestamp.getTimeSlice());
            this.serverTimestamp.addEvent(evt);
        }
        return true;
    }

    public void shutdown() {
        GerritServer server = PluginImpl.getServer_(this.serverName);
        if (server != null) {
            server.removeListener(this);
        } else {
            logger.error("Could not find server {}", (Object)this.serverName);
        }
        this.stopPersistenceCheck();
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public EventTimeSlice getServerTimestamp() {
        return this.serverTimestamp;
    }

    @CheckForNull
    public static XmlFile getConfigXml(String serverName) throws IOException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return null;
        }
        File dataDir = new File(jenkins.getRootDir(), GERRIT_SERVER_EVENT_DATA_FOLDER);
        File serverDataDir = new File(dataDir, serverName);
        serverDataDir.mkdirs();
        File xmlFile = new File(serverDataDir, GERRIT_TRIGGER_SERVER_TIMESTAMPS_XML);
        return new XmlFile(Jenkins.XSTREAM, xmlFile);
    }

    @Override
    public String getDisplayName() {
        return StringUtil.getDefaultDisplayNameForSpecificServer(this, this.getServerName());
    }

    class GerritMissedEventsPlaybackPersistRunnable
    implements Runnable {
        private final AtomicBoolean running = new AtomicBoolean(false);
        private static final long CHECK_INTERVAL = 1000L;
        private ScheduledExecutorService scheduler = Timer.get();
        private ScheduledFuture<?> task = null;

        public synchronized void start() {
            if (!this.isRunning()) {
                this.running.set(true);
                this.task = this.scheduler.scheduleAtFixedRate(this, 0L, 1000L, TimeUnit.MILLISECONDS);
            }
        }

        public void stop() {
            if (this.isRunning()) {
                this.task.cancel(true);
                this.running.set(false);
            }
        }

        public boolean isRunning() {
            return this.running.get();
        }

        @Override
        public void run() {
            if (GerritMissedEventsPlaybackManager.this.serverTimestamp != null && previousTimeSlice < GerritMissedEventsPlaybackManager.this.serverTimestamp.getTimeSlice()) {
                previousTimeSlice = GerritMissedEventsPlaybackManager.this.serverTimestamp.getTimeSlice();
                this.persistTimeStamp();
            }
        }

        private void persistTimeStamp() {
            try {
                XmlFile config = GerritMissedEventsPlaybackManager.getConfigXml(GerritMissedEventsPlaybackManager.this.serverName);
                if (config == null) {
                    logger.error("XML " + GerritMissedEventsPlaybackManager.this.serverName + " is null, please check file permissions.");
                } else {
                    EventTimeSlice serverTimestampCopy = EventTimeSlice.shallowCopy(GerritMissedEventsPlaybackManager.this.serverTimestamp);
                    config.write((Object)serverTimestampCopy);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

