/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.model.BuildMemory;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefUpdated;
import hudson.model.ModelObject;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class BuildMemoryReport
implements Map<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>>,
ModelObject {
    private final Map<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>> internal = new TreeMap<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>>(new Comparator<GerritTriggeredEvent>(){

        @Override
        public int compare(GerritTriggeredEvent a, GerritTriggeredEvent b) {
            int to = a.getEventCreatedOn().compareTo(b.getEventCreatedOn()) * -1;
            if (to == 0) {
                return Integer.valueOf(a.hashCode()).compareTo(b.hashCode()) * -1;
            }
            return to;
        }
    });
    public static final ThreadLocal<DateFormat> TS_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat get() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        }
    };

    public List<Map.Entry<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>>> getSortedEntrySet() {
        LinkedList<Map.Entry<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>>> entries = new LinkedList<Map.Entry<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>>>(this.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>>>(){

            @Override
            public int compare(Map.Entry<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>> a, Map.Entry<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>> b) {
                return a.getKey().getEventCreatedOn().compareTo(b.getKey().getEventCreatedOn()) * -1;
            }
        });
        return entries;
    }

    public String getDisplayNameFor(GerritTriggeredEvent event) {
        StringBuilder display = new StringBuilder(event.getEventType().getTypeValue());
        if (event instanceof ChangeBasedEvent) {
            display.append(' ');
            display.append(((ChangeBasedEvent)event).getChange().getNumber());
            display.append('/');
            display.append(((ChangeBasedEvent)event).getPatchSet().getNumber());
        } else if (event instanceof RefUpdated) {
            display.append(' ');
            display.append(((RefUpdated)event).getRefUpdate().getProject());
        }
        display.append(" @ ");
        display.append(TS_FORMAT.get().format(event.getEventCreatedOn()));
        return display.toString();
    }

    @Override
    public int size() {
        return this.internal.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internal.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internal.containsValue(value);
    }

    @Override
    public List<BuildMemory.MemoryImprint.Entry> get(Object key) {
        return this.internal.get(key);
    }

    @Override
    public List<BuildMemory.MemoryImprint.Entry> put(GerritTriggeredEvent key, List<BuildMemory.MemoryImprint.Entry> value) {
        return this.internal.put(key, value);
    }

    @Override
    public List<BuildMemory.MemoryImprint.Entry> remove(Object key) {
        return this.internal.remove(key);
    }

    @Override
    public void putAll(Map<? extends GerritTriggeredEvent, ? extends List<BuildMemory.MemoryImprint.Entry>> m) {
        this.internal.putAll(m);
    }

    @Override
    public void clear() {
        this.internal.clear();
    }

    @Override
    @Nonnull
    public Set<GerritTriggeredEvent> keySet() {
        return this.internal.keySet();
    }

    @Override
    @Nonnull
    public Collection<List<BuildMemory.MemoryImprint.Entry>> values() {
        return this.internal.values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<GerritTriggeredEvent, List<BuildMemory.MemoryImprint.Entry>>> entrySet() {
        return this.internal.entrySet();
    }

    public String getDisplayName() {
        return Messages.BuildMemoryReport_DisplayName();
    }
}

