/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.SystemEventThread;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.lifecycle.GerritEventLifecycle;
import com.sonymobile.tools.gerrit.gerritevents.GerritHandler;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.workers.Coordinator;
import com.sonymobile.tools.gerrit.gerritevents.workers.EventThread;
import hudson.security.ACL;
import hudson.security.ACLContext;
import org.acegisecurity.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsAwareGerritHandler
extends GerritHandler {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsAwareGerritHandler.class);

    public JenkinsAwareGerritHandler(int numberOfWorkerThreads) {
        super(numberOfWorkerThreads);
    }

    protected EventThread createEventThread(String threadName) {
        return new SystemEventThread((Coordinator)this, threadName);
    }

    public void notifyListeners(GerritEvent event) {
        if (event instanceof GerritEventLifecycle) {
            try {
                ((GerritEventLifecycle)event).fireTriggerScanStarting();
            }
            catch (Exception ex) {
                logger.error("Error when notifying LifecycleListeners. ", (Throwable)ex);
            }
        }
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            super.notifyListeners(event);
        }
        if (event instanceof GerritEventLifecycle) {
            try {
                ((GerritEventLifecycle)event).fireTriggerScanDone();
            }
            catch (Exception ex) {
                logger.error("Error when notifying LifecycleListeners. ", (Throwable)ex);
            }
        }
    }
}

