/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.ExceptionDataHelper;
import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritManagement;
import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritProjectListUpdater;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.VerdictCategory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.Config;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.ReplicationConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritConnectionListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritSlave;
import com.sonyericsson.hudson.plugins.gerrit.trigger.playback.GerritMissedEventsPlaybackManager;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.GerritVersionChecker;
import com.sonymobile.tools.gerrit.gerritevents.ConnectionListener;
import com.sonymobile.tools.gerrit.gerritevents.GerritConnection;
import com.sonymobile.tools.gerrit.gerritevents.GerritConnectionConfig2;
import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import com.sonymobile.tools.gerrit.gerritevents.GerritHandler;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Notify;
import com.sonymobile.tools.gerrit.gerritevents.ssh.Authentication;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshAuthenticationException;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnectException;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnection;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnectionFactory;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshUtil;
import com.sonymobile.tools.gerrit.gerritevents.watchdog.WatchTimeExceptionData;
import hudson.Extension;
import hudson.Functions;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.security.Permission;
import hudson.triggers.Trigger;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportedBean(defaultVisibility=2)
public class GerritServer
implements Describable<GerritServer>,
Action {
    private static final Logger logger = LoggerFactory.getLogger(GerritServer.class);
    private static final String START_SUCCESS = "Connection started";
    private static final String START_FAILURE = "Error establising conection";
    private static final String STOP_SUCCESS = "Connection stopped";
    private static final String STOP_FAILURE = "Error terminating connection";
    public static final String ANY_SERVER = "__ANY__";
    private static final int THREADS_FOR_TEST_CONNECTION = 1;
    private static final int TIMEOUT_FOR_TEST_CONNECTION = 10;
    private static final int RESPONSE_COUNT = 1;
    private static final int RESPONSE_INTERVAL_MS = 1000;
    private static final int RESPONSE_TIMEOUT_S = 10;
    private String name;
    @Deprecated
    private transient boolean pseudoMode;
    private boolean noConnectionOnStartup;
    private transient boolean started;
    private transient boolean timeoutWakeup = false;
    private transient String connectionResponse = "";
    private transient GerritHandler gerritEventManager;
    private transient GerritConnection gerritConnection;
    private transient GerritProjectListUpdater projectListUpdater;
    private IGerritHudsonTriggerConfig config;
    private transient GerritConnectionListener gerritConnectionListener;
    private transient GerritMissedEventsPlaybackManager missedEventsPlaybackManager;

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public GerritMissedEventsPlaybackManager getMissedEventsPlaybackManager() {
        return this.missedEventsPlaybackManager;
    }

    public String getParentUrl() {
        return GerritManagement.get().getUrlName();
    }

    public String getUrl() {
        return GerritManagement.get().getUrlName() + "/server/" + this.getUrlEncodedName();
    }

    public GerritServer(String name) {
        this(name, false);
    }

    public GerritServer(String name, boolean noConnectionOnStartup) {
        this.name = name;
        this.pseudoMode = false;
        this.noConnectionOnStartup = noConnectionOnStartup;
        this.config = new Config();
    }

    public static boolean isAnyServer(String serverName) {
        return serverName == null || serverName.isEmpty() || ANY_SERVER.equals(serverName);
    }

    public IGerritHudsonTriggerConfig getConfig() {
        return this.config;
    }

    public void setConfig(IGerritHudsonTriggerConfig config) {
        this.checkPermission();
        this.config = config;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getHostName() {
        return this.config.getGerritHostName();
    }

    @Exported
    public int getSshPort() {
        return this.config.getGerritSshPort();
    }

    @Exported
    public String getUserName() {
        return this.config.getGerritUserName();
    }

    @Exported
    public String getHttpUserName() {
        return this.config.getGerritHttpUserName();
    }

    @Exported
    public String getFrontEndUrl() {
        return this.config.getGerritFrontEndUrl();
    }

    @Deprecated
    public boolean isPseudoMode() {
        return this.pseudoMode;
    }

    @Deprecated
    public void setPseudoMode(boolean pseudoMode) {
        this.pseudoMode = pseudoMode;
    }

    @Exported
    public boolean isNoConnectionOnStartup() {
        return this.noConnectionOnStartup;
    }

    public void setNoConnectionOnStartup(boolean noConnectionOnStartup) {
        this.noConnectionOnStartup = noConnectionOnStartup;
    }

    @Exported
    public boolean isTimeoutWakeup() {
        return this.timeoutWakeup;
    }

    public String getIconFileName() {
        return "/plugin/gerrit-trigger/images/icon24.png";
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getUrlName() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && jenkins.getRootUrl() != null) {
            return Functions.joinPath((String[])new String[]{jenkins.getRootUrl(), this.getParentUrl(), "server", this.getUrlEncodedName()});
        }
        return Functions.joinPath((String[])new String[]{"/", this.getParentUrl(), "server", this.getUrlEncodedName()});
    }

    public String getUrlEncodedName() {
        String urlName;
        try {
            urlName = URLEncoder.encode(this.name, "UTF-8");
        }
        catch (Exception ex) {
            urlName = URLEncoder.encode(this.name);
        }
        return urlName;
    }

    public boolean isLastServer() {
        return PluginImpl.getServers_().size() == 1;
    }

    private void checkPermission() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            jenkins.checkPermission(this.getRequiredPermission());
        }
    }

    public final Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    public void start() {
        this.checkPermission();
        logger.info("Starting GerritServer: " + this.name);
        List<VerdictCategory> categories = this.config.getCategories();
        if (categories == null) {
            categories = new LinkedList<VerdictCategory>();
        }
        if (categories.isEmpty()) {
            categories.add(new VerdictCategory("Code-Review", "Code Review"));
            categories.add(new VerdictCategory("Verified", "Verified"));
        }
        this.config.setCategories(categories);
        this.gerritEventManager = PluginImpl.getHandler_();
        if (this.missedEventsPlaybackManager == null) {
            this.missedEventsPlaybackManager = new GerritMissedEventsPlaybackManager(this.name);
        }
        this.initializeConnectionListener();
        this.projectListUpdater = new GerritProjectListUpdater(this.name);
        this.projectListUpdater.start();
        this.missedEventsPlaybackManager.checkIfEventsLogPluginSupported();
        this.addListener(this.missedEventsPlaybackManager);
        logger.info(this.name + " started");
        this.started = true;
    }

    private void initializeConnectionListener() {
        this.gerritConnectionListener = new GerritConnectionListener(this.name);
        this.addListener(this.gerritConnectionListener);
        this.gerritConnectionListener.setConnected(this.isConnected());
        this.gerritConnectionListener.checkGerritVersionFeatures();
    }

    public void stop() {
        this.checkPermission();
        logger.info("Stopping GerritServer " + this.name);
        if (this.projectListUpdater != null) {
            this.projectListUpdater.shutdown();
            try {
                this.projectListUpdater.join();
            }
            catch (InterruptedException ie) {
                logger.error("project list updater of " + this.name + "interrupted", (Throwable)ie);
            }
            this.projectListUpdater = null;
        }
        if (this.missedEventsPlaybackManager != null) {
            this.missedEventsPlaybackManager.shutdown();
            this.missedEventsPlaybackManager = null;
        }
        if (this.gerritConnection != null) {
            this.gerritConnection.shutdown(false);
            this.gerritConnection = null;
        }
        logger.info(this.name + " stopped");
        this.started = false;
    }

    public void addListener(GerritEventListener listener) {
        if (this.gerritEventManager != null) {
            this.gerritEventManager.addListener(listener);
        }
    }

    public void removeListener(GerritEventListener listener) {
        if (this.gerritEventManager != null) {
            this.gerritEventManager.removeListener(listener);
        }
    }

    public void removeListener(ConnectionListener listener) {
        if (this.gerritConnection != null) {
            this.gerritConnection.removeListener(listener);
        }
    }

    public GerritConnectionListener getGerritConnectionListener() {
        return this.gerritConnectionListener;
    }

    public synchronized void startConnection() {
        this.checkPermission();
        if (!this.config.hasDefaultValues()) {
            if (this.gerritConnection == null) {
                logger.debug("Starting Gerrit connection...");
                this.gerritConnection = new GerritConnection(this.name, (GerritConnectionConfig2)this.config);
                if (this.config.isTriggerOnAllComments()) {
                    logger.info("Will trigger on all comments, even from the configured user.");
                } else {
                    logger.info("Will skip comments added by " + this.config.getGerritUserName());
                    this.gerritEventManager.setIgnoreEMail(this.name, this.config.getGerritEMail());
                }
                this.gerritConnection.setHandler(this.gerritEventManager);
                this.gerritConnection.addListener((ConnectionListener)this.gerritConnectionListener);
                this.gerritConnection.addListener((ConnectionListener)this.projectListUpdater);
                this.missedEventsPlaybackManager.checkIfEventsLogPluginSupported();
                this.gerritConnection.addListener((ConnectionListener)this.missedEventsPlaybackManager);
                this.gerritConnection.start();
            } else {
                logger.warn("Already started!");
            }
        }
    }

    public synchronized void stopConnection() {
        this.checkPermission();
        if (this.gerritConnection != null) {
            this.gerritConnection.shutdown(true);
            this.gerritConnection.removeListener((ConnectionListener)this.gerritConnectionListener);
            this.gerritConnection.removeListener((ConnectionListener)this.missedEventsPlaybackManager);
            this.gerritConnection = null;
            this.gerritEventManager.setIgnoreEMail(this.name, null);
        } else {
            logger.warn("Was told to shutdown again?");
        }
    }

    @Exported
    public synchronized boolean isConnected() {
        if (this.gerritConnection != null) {
            return this.gerritConnection.isConnected();
        }
        return false;
    }

    public void restartConnection() {
        this.stopConnection();
        this.startConnection();
    }

    public void addListener(ConnectionListener listener) {
        if (this.gerritConnection != null) {
            this.gerritConnection.addListener(listener);
        }
    }

    public List<String> getGerritProjects() {
        if (this.projectListUpdater != null) {
            return this.projectListUpdater.getGerritProjects();
        }
        return new ArrayList<String>();
    }

    public void triggerEvent(GerritEvent event) {
        if (this.gerritEventManager == null) {
            throw new IllegalStateException("Manager not started!");
        }
        this.gerritEventManager.post(event);
    }

    public String getGerritVersion() {
        if (this.gerritConnection != null) {
            return this.gerritConnection.getGerritVersion();
        }
        return null;
    }

    public boolean isReplicationEventsSupported() {
        return GerritVersionChecker.isCorrectVersion(GerritVersionChecker.Feature.replicationEvents, this.name);
    }

    public boolean isProjectCreatedEventsSupported() {
        return GerritVersionChecker.isCorrectVersion(GerritVersionChecker.Feature.projectCreatedEvents, this.name, true);
    }

    public static Map<Notify, String> notificationLevelTextsById() {
        ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);
        LinkedHashMap<Notify, String> textsById = new LinkedHashMap<Notify, String>(Notify.values().length, 1.0f);
        for (Notify level : Notify.values()) {
            textsById.put(level, holder.format("NotificationLevel_" + level, new Object[0]));
        }
        return textsById;
    }

    @RequirePOST
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException {
        JSONObject form;
        String newName;
        this.checkPermission();
        if (logger.isDebugEnabled()) {
            logger.debug("submit {}", (Object)req.toString());
        }
        if (!this.name.equals(newName = (form = req.getSubmittedForm()).getString("name"))) {
            if (PluginImpl.containsServer_(newName)) {
                throw new Failure("A server already exists with the name '" + newName + "'");
            }
            if (ANY_SERVER.equals(newName)) {
                throw new Failure("Illegal name '" + newName + "'");
            }
            this.rename(newName);
        }
        this.noConnectionOnStartup = form.getBoolean("noConnectionOnStartup");
        this.config.setValues(form);
        PluginImpl.save_();
        if (!this.started) {
            this.start();
        } else if (this.missedEventsPlaybackManager != null) {
            this.missedEventsPlaybackManager.checkIfEventsLogPluginSupported();
        }
        rsp.sendRedirect("../..");
    }

    private void rename(String newName) {
        this.checkPermission();
        if (this.isConnected()) {
            this.stopConnection();
            this.stop();
            String oldName = this.name;
            this.name = newName;
            this.start();
            this.startConnection();
            this.changeSelectedServerInJobs(oldName);
        } else {
            this.stop();
            String oldName = this.name;
            this.name = newName;
            this.start();
            this.changeSelectedServerInJobs(oldName);
        }
    }

    public List<Job> getConfiguredJobs() {
        return PluginImpl.getConfiguredJobs_(this.name);
    }

    private void changeSelectedServerInJobs(String oldName) {
        for (Job job : PluginImpl.getConfiguredJobs_(oldName)) {
            if (!(job instanceof AbstractProject)) {
                logger.warn("Unable to modify Gerrit Trigger configurations for job [" + job.getName() + "] after Gerrit server has been renamed from [" + oldName + "] to [" + this.name + "]. This feature is only supported for AbstractProject types e.g. Freestyle Jobs.");
                return;
            }
            AbstractProject project = (AbstractProject)job;
            GerritTrigger trigger = (GerritTrigger)project.getTrigger(GerritTrigger.class);
            if (trigger == null) continue;
            try {
                trigger.setServerName(this.name);
                trigger.start(job, false);
                project.addTrigger((Trigger)trigger);
                project.save();
            }
            catch (IOException e) {
                logger.error("Error saving Gerrit Trigger configurations for job [" + job.getName() + "] after Gerrit server has been renamed from [" + oldName + "] to [" + this.name + "]");
            }
        }
    }

    private void removeGerritTriggerInJobs() {
        for (Job job : this.getConfiguredJobs()) {
            if (!(job instanceof AbstractProject)) {
                logger.warn("Unable to remove Gerrit Trigger ffrom job [" + job.getName() + "].  This feature is only supported for AbstractProject types e.g. Freestyle Jobs.");
                return;
            }
            AbstractProject project = (AbstractProject)job;
            GerritTrigger trigger = (GerritTrigger)project.getTrigger(GerritTrigger.class);
            trigger.stop();
            try {
                project.removeTrigger(trigger.getDescriptor());
            }
            catch (IOException e) {
                logger.error("Error removing Gerrit trigger from job [" + job.getName() + "]. Please check job config");
            }
            trigger = null;
            try {
                job.save();
            }
            catch (IOException e) {
                logger.error("Error saving configuration of job [" + job.getName() + "] while trying to remove Gerrit server [" + this.name + "]. Please check job config.");
            }
        }
    }

    @RequirePOST
    public JSONObject doWakeup() {
        this.checkPermission();
        Timer timer = new Timer();
        try {
            this.startConnection();
            final CountDownLatch responseLatch = new CountDownLatch(1);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (GerritServer.this.gerritConnectionListener != null && GerritServer.this.gerritConnectionListener.isConnected()) {
                        responseLatch.countDown();
                    }
                }
            }, 1000L, 1000L);
            if (!responseLatch.await(10L, TimeUnit.SECONDS)) {
                this.timeoutWakeup = true;
                throw new InterruptedException("time out.");
            }
            this.timeoutWakeup = false;
            this.setConnectionResponse(START_SUCCESS);
        }
        catch (Exception ex) {
            this.setConnectionResponse(START_FAILURE);
            logger.error("Could not start connection. ", (Throwable)ex);
        }
        timer.cancel();
        JSONObject obj = new JSONObject();
        String status = "down";
        if (this.gerritConnectionListener != null && this.gerritConnectionListener.isConnected()) {
            status = "up";
        }
        obj.put("status", (Object)status);
        return obj;
    }

    @RequirePOST
    public JSONObject doSleep() {
        this.checkPermission();
        Timer timer = new Timer();
        try {
            this.stopConnection();
            final CountDownLatch responseLatch = new CountDownLatch(1);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (GerritServer.this.gerritConnectionListener == null || !GerritServer.this.gerritConnectionListener.isConnected()) {
                        responseLatch.countDown();
                    }
                }
            }, 1000L, 1000L);
            if (!responseLatch.await(10L, TimeUnit.SECONDS)) {
                throw new InterruptedException("time out.");
            }
            this.setConnectionResponse(STOP_SUCCESS);
        }
        catch (Exception ex) {
            this.setConnectionResponse(STOP_FAILURE);
            logger.error("Could not stop connection. ", (Throwable)ex);
        }
        timer.cancel();
        JSONObject obj = new JSONObject();
        String status = "down";
        if (this.gerritConnectionListener != null && this.gerritConnectionListener.isConnected()) {
            status = "up";
        }
        obj.put("status", (Object)status);
        return obj;
    }

    public boolean hasErrors() {
        return this.isConnectionError();
    }

    public boolean hasWarnings() {
        return this.isGerritSnapshotVersion() || this.hasDisabledFeatures();
    }

    @JavaScriptMethod
    public boolean isConnectionError() {
        return this.gerritConnectionListener != null && !this.gerritConnectionListener.isConnected() && this.timeoutWakeup;
    }

    @JavaScriptMethod
    public boolean isGerritSnapshotVersion() {
        return this.gerritConnectionListener != null && this.gerritConnectionListener.isConnected() && this.gerritConnectionListener.isSnapShotGerrit();
    }

    @JavaScriptMethod
    public boolean isGerritMissedEventsSupported() {
        if (this.gerritConnectionListener != null && this.gerritConnectionListener.isConnected()) {
            return this.missedEventsPlaybackManager.isSupported();
        }
        return false;
    }

    @JavaScriptMethod
    public boolean hasDisabledFeatures() {
        List<GerritVersionChecker.Feature> disabledFeatures;
        return this.gerritConnectionListener != null && this.gerritConnectionListener.isConnected() && (disabledFeatures = this.gerritConnectionListener.getDisabledFeatures()) != null && !disabledFeatures.isEmpty();
    }

    public List<GerritVersionChecker.Feature> getDisabledFeatures() {
        List<GerritVersionChecker.Feature> features;
        if (this.gerritConnectionListener != null && this.gerritConnectionListener.isConnected() && (features = this.gerritConnectionListener.getDisabledFeatures()) != null) {
            return features;
        }
        return new LinkedList<GerritVersionChecker.Feature>();
    }

    public String getConnectionResponse() {
        return this.connectionResponse;
    }

    private void setConnectionResponse(String response) {
        this.connectionResponse = response;
    }

    @RequirePOST
    public void doRemoveConfirm(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException {
        Jenkins jenkins;
        this.checkPermission();
        this.stopConnection();
        this.stop();
        PluginImpl plugin = PluginImpl.getInstance();
        this.removeGerritTriggerInJobs();
        if (plugin != null) {
            plugin.removeServer(this);
            plugin.save();
        }
        if ((jenkins = Jenkins.getInstance()) != null) {
            rsp.sendRedirect(jenkins.getRootUrl() + GerritManagement.get().getUrlName());
        }
    }

    public FormValidation doPositiveIntegerCheck(@QueryParameter(value="value") String value) {
        return FormValidation.validatePositiveInteger((String)value);
    }

    public FormValidation doNonNegativeIntegerCheck(@QueryParameter(value="value") String value) {
        return FormValidation.validateNonNegativeInteger((String)value);
    }

    public FormValidation doDynamicConfigRefreshCheck(@QueryParameter(value="value") String value) {
        FormValidation validatePositive = FormValidation.validatePositiveInteger((String)value);
        if (!validatePositive.kind.equals((Object)FormValidation.Kind.OK)) {
            return validatePositive;
        }
        int intValue = Integer.parseInt(value);
        if (intValue < 5) {
            return FormValidation.error((String)Messages.DynamicConfRefreshTooLowError(5));
        }
        return FormValidation.ok();
    }

    public FormValidation doIntegerCheck(@QueryParameter(value="value") String value) {
        try {
            Integer.parseInt(value);
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)Messages.NotANumber());
        }
    }

    public FormValidation doEmptyOrIntegerCheck(@QueryParameter(value="value") String value) {
        if (value == null || value.length() <= 0) {
            return FormValidation.ok();
        }
        try {
            Integer.parseInt(value);
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)Messages.NotANumber());
        }
    }

    public FormValidation doUrlCheck(@QueryParameter(value="value") String value) {
        if (value == null || value.length() <= 0) {
            return FormValidation.error((String)Messages.EmptyError());
        }
        try {
            new URL(value);
            return FormValidation.ok();
        }
        catch (MalformedURLException ex) {
            return FormValidation.error((String)Messages.BadUrlError());
        }
    }

    public FormValidation doValidKeyFileCheck(@QueryParameter(value="value") String value) {
        File f = new File(value);
        if (!f.exists()) {
            return FormValidation.error((String)Messages.FileNotFoundError(value));
        }
        if (!f.isFile()) {
            return FormValidation.error((String)Messages.NotFileError(value));
        }
        if (SshUtil.isPrivateKeyFileValid((File)f)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.InvalidKeyFileError(value));
    }

    public FormValidation doValidTimeCheck(@QueryParameter String fromValue, @QueryParameter String toValue) {
        int toMinute;
        int toHour;
        int fromMinute;
        int fromHour;
        String[] splitFrom = fromValue.split(":");
        String[] splitTo = toValue.split(":");
        if (splitFrom.length != 2 || splitTo.length != 2) {
            return FormValidation.error((String)Messages.InvalidTimeString());
        }
        try {
            fromHour = Integer.parseInt(splitFrom[0]);
            fromMinute = Integer.parseInt(splitFrom[1]);
            toHour = Integer.parseInt(splitTo[0]);
            toMinute = Integer.parseInt(splitTo[1]);
        }
        catch (NumberFormatException nfe) {
            return FormValidation.error((String)Messages.InvalidTimeString());
        }
        if (fromHour < 0 || fromHour > 23 || fromMinute < 0 || fromMinute > 59 || toHour < 0 || toHour > 23 || toMinute < 0 || toMinute > 59) {
            return FormValidation.error((String)Messages.InvalidTimeString());
        }
        if (fromHour > toHour || fromHour == toHour && fromMinute > toMinute) {
            return FormValidation.error((String)Messages.InvalidTimeSpan());
        }
        return FormValidation.ok();
    }

    public FormValidation doNameFreeCheck(@QueryParameter(value="value") String value) {
        this.checkPermission();
        if (!value.equals(this.name)) {
            if (PluginImpl.containsServer_(value)) {
                return FormValidation.error((String)("The server name " + value + " is already in use!"));
            }
            if (ANY_SERVER.equals(value)) {
                return FormValidation.error((String)("Illegal name " + value + "!"));
            }
            return FormValidation.warning((String)("The server " + this.name + " will be renamed"));
        }
        return FormValidation.ok();
    }

    public List<ExceptionDataHelper> generateHelper() {
        WatchTimeExceptionData data = this.config.getExceptionData();
        LinkedList<ExceptionDataHelper> list = new LinkedList<ExceptionDataHelper>();
        list.add(new ExceptionDataHelper(Messages.MondayDisplayName(), 2, data));
        list.add(new ExceptionDataHelper(Messages.TuesdayDisplayName(), 3, data));
        list.add(new ExceptionDataHelper(Messages.WednesdayDisplayName(), 4, data));
        list.add(new ExceptionDataHelper(Messages.ThursdayDisplayName(), 5, data));
        list.add(new ExceptionDataHelper(Messages.FridayDisplayName(), 6, data));
        list.add(new ExceptionDataHelper(Messages.SaturdayDisplayName(), 7, data));
        list.add(new ExceptionDataHelper(Messages.SundayDisplayName(), 1, data));
        return list;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GerritServer> {
        public String getDisplayName() {
            return "Gerrit Server with Default Configurations";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doTestConnection(@QueryParameter(value="gerritHostName") String gerritHostName, @QueryParameter(value="gerritSshPort") int gerritSshPort, @QueryParameter(value="gerritProxy") String gerritProxy, @QueryParameter(value="gerritUserName") String gerritUserName, @QueryParameter(value="gerritAuthKeyFile") String gerritAuthKeyFile, @QueryParameter(value="gerritAuthKeyFilePassword") String gerritAuthKeyFilePassword) {
            if (logger.isDebugEnabled()) {
                logger.debug("gerritHostName = {}\ngerritSshPort = {}\ngerritProxy = {}\ngerritUserName = {}\ngerritAuthKeyFile = {}\ngerritAuthKeyFilePassword = {}", new Object[]{gerritHostName, gerritSshPort, gerritProxy, gerritUserName, gerritAuthKeyFile, gerritAuthKeyFilePassword});
            }
            File file = new File(gerritAuthKeyFile);
            String password = null;
            if (gerritAuthKeyFilePassword != null && gerritAuthKeyFilePassword.length() > 0) {
                password = Secret.fromString((String)gerritAuthKeyFilePassword).getPlainText();
            }
            if (SshUtil.checkPassPhrase((File)file, password)) {
                if (file.exists() && file.isFile()) {
                    try {
                        int readChar;
                        final SshConnection sshConnection = SshConnectionFactory.getConnection((String)gerritHostName, (int)gerritSshPort, (String)gerritProxy, (Authentication)new Authentication(file, gerritUserName, password));
                        ExecutorService service = Executors.newFixedThreadPool(1);
                        Future<Integer> future = service.submit(new Callable<Integer>(){

                            @Override
                            public Integer call() throws Exception {
                                return sshConnection.executeCommandReader("gerrit stream-events").read();
                            }
                        });
                        try {
                            readChar = future.get(10L, TimeUnit.SECONDS);
                        }
                        catch (TimeoutException ex) {
                            readChar = 0;
                        }
                        finally {
                            sshConnection.disconnect();
                        }
                        if (readChar < 0) {
                            return FormValidation.error((String)Messages.StreamEventsCapabilityException(gerritUserName));
                        }
                        return FormValidation.ok((String)Messages.Success());
                    }
                    catch (SshConnectException ex) {
                        return FormValidation.error((String)Messages.SshConnectException());
                    }
                    catch (SshAuthenticationException ex) {
                        return FormValidation.error((String)Messages.SshAuthenticationException(ex.getMessage()));
                    }
                    catch (Exception e) {
                        return FormValidation.error((String)Messages.ConnectionError(e.getMessage()));
                    }
                }
                return FormValidation.error((String)Messages.SshKeyFileNotFoundError(gerritAuthKeyFile));
            }
            return FormValidation.error((String)Messages.BadSshkeyOrPasswordError());
        }

        public FormValidation doTestRestConnection(@QueryParameter(value="gerritFrontEndUrl") String gerritFrontEndUrl, @QueryParameter(value="gerritHttpUserName") String gerritHttpUserName, @QueryParameter(value="gerritHttpPassword") String gerritHttpPassword) {
            HttpResponse execute;
            String password = Secret.fromString((String)gerritHttpPassword).getPlainText();
            String restUrl = gerritFrontEndUrl;
            if (gerritFrontEndUrl != null && !gerritFrontEndUrl.endsWith("/")) {
                restUrl = gerritFrontEndUrl + "/";
            }
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(gerritHttpUserName, password));
            CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            HttpGet httpGet = new HttpGet(restUrl + "a/projects/?d");
            try {
                execute = httpclient.execute((HttpUriRequest)httpGet);
            }
            catch (IOException e) {
                return FormValidation.error((String)Messages.ConnectionError(e.getMessage()));
            }
            int statusCode = execute.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    return FormValidation.ok((String)Messages.Success());
                }
                case 401: {
                    return FormValidation.error((String)Messages.HttpConnectionUnauthorized());
                }
            }
            return FormValidation.error((String)Messages.HttpConnectionError(statusCode));
        }

        public ListBoxModel doFillDefaultSlaveIdItems(@QueryParameter(value="name") @RelativePath(value="../..") String serverName) {
            ListBoxModel items = new ListBoxModel();
            logger.trace("filling default gerrit slave drop down for sever {}", (Object)serverName);
            GerritServer server = PluginImpl.getServer_(serverName);
            if (server == null) {
                logger.warn(Messages.CouldNotFindServer(serverName));
                items.add(Messages.CouldNotFindServer(serverName), "");
                return items;
            }
            ReplicationConfig replicationConfig = server.getConfig().getReplicationConfig();
            if (replicationConfig == null || !replicationConfig.isEnableReplication() || replicationConfig.getGerritSlaves().size() == 0) {
                logger.trace(Messages.GerritSlaveNotDefined());
                items.add(Messages.GerritSlaveNotDefined(), "");
                return items;
            }
            for (GerritSlave slave : replicationConfig.getGerritSlaves()) {
                boolean selected = slave.getId().equals(replicationConfig.getDefaultSlaveId());
                items.add((Object)new ListBoxModel.Option(slave.getName(), slave.getId(), selected));
            }
            return items;
        }

        public ListBoxModel doFillNotificationLevelItems() {
            Map<Notify, String> levelTextsById = GerritServer.notificationLevelTextsById();
            ListBoxModel items = new ListBoxModel(levelTextsById.size());
            for (Map.Entry<Notify, String> level : levelTextsById.entrySet()) {
                items.add((Object)new ListBoxModel.Option(level.getValue(), level.getKey().toString()));
            }
            return items;
        }
    }
}

