/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics.support;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.Content;
import com.cloudbees.jenkins.support.api.PrintedContent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics.Diagnostics;
import com.sonyericsson.hudson.plugins.gerrit.trigger.diagnostics.EventListenersReport;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.EventListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.Branch;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritProject;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.security.Permission;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Extension(optional=true)
public class EventListenersComponent
extends Component {
    private static final int MAX_PROJECT_BRANCH_LIST_LENGTH = 5;

    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Diagnostics.getRequiredPermission());
    }

    @NonNull
    public String getDisplayName() {
        return "Gerrit: " + Messages.EventListenersReport_DisplayName();
    }

    public boolean isSelectedByDefault() {
        return false;
    }

    public void addContents(@NonNull Container container) {
        container.add((Content)new PrintedContent("gerrit/event-listeners.md"){

            protected void printTo(PrintWriter out) throws IOException {
                out.println("#" + EventListenersComponent.this.getDisplayName());
                out.println();
                EventListenersReport report = EventListenersReport.report();
                if (report == null) {
                    out.println("No report could be generated, see the system log for indications.");
                    return;
                }
                out.println("##Jobs");
                for (EventListener eventListener : report.getJobs()) {
                    Job job = eventListener.findJob();
                    GerritTrigger trigger = eventListener.getTrigger();
                    if (job != null) {
                        out.format(" * __Job: %s _(%s)___\n", job.getFullDisplayName(), eventListener.getJob());
                    } else {
                        out.format(" * __Job: _(%s)___\n", eventListener.getJob());
                    }
                    if (trigger == null) continue;
                    out.println("    - Trigger on: ");
                    List<GerritProject> projects = trigger.getGerritProjects();
                    for (int i = 0; i < Math.min(5, projects.size()); ++i) {
                        GerritProject pr = projects.get(i);
                        out.format("        * _%s_: %s\n", pr.getCompareType().getDisplayName(), pr.getPattern());
                        List<Branch> branches = pr.getBranches();
                        for (int j = 0; j < Math.min(5, branches.size()); ++j) {
                            Branch branch = branches.get(0);
                            out.format("            - _%s_: %s\n", branch.getCompareType().getDisplayName(), branch.getPattern());
                        }
                        if (branches.size() < 5) continue;
                        out.println("            - ...");
                    }
                    if (projects.size() >= 5) {
                        out.println("        * ...");
                    }
                    out.println(("    - Server: " + trigger.getServerName()).replace("_", "\\_"));
                    out.println("    - Silent Mode: " + trigger.isSilentMode());
                    out.println("    - Silent Start: " + trigger.isSilentStartMode());
                    out.println("    - Trigger Types: ");
                    for (PluginGerritEvent event : trigger.getTriggerOnEvents()) {
                        Descriptor descriptor = event.getDescriptor();
                        if (descriptor != null) {
                            out.println("        * " + descriptor.getDisplayName());
                            continue;
                        }
                        out.println("        * <unknown>");
                    }
                }
                out.println();
                out.println("##Others");
                for (GerritEventListener gerritEventListener : report.getOthers()) {
                    out.println(" * " + report.getName(gerritEventListener));
                }
            }
        });
    }
}

