/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.parameters.Base64EncodedStringParameterValue;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Account;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeAbandoned;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeMerged;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeRestored;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefUpdated;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.TopicChanged;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import hudson.model.TextParameterValue;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.jvnet.localizer.Localizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GerritTriggerParameters {
    GERRIT_CHANGE_SUBJECT,
    GERRIT_CHANGE_COMMIT_MESSAGE,
    GERRIT_BRANCH,
    GERRIT_TOPIC,
    GERRIT_OLD_TOPIC,
    GERRIT_TOPIC_CHANGER,
    GERRIT_TOPIC_CHANGER_NAME,
    GERRIT_TOPIC_CHANGER_EMAIL,
    GERRIT_CHANGE_ID,
    GERRIT_CHANGE_NUMBER,
    GERRIT_CHANGE_URL,
    GERRIT_PATCHSET_NUMBER,
    GERRIT_PATCHSET_REVISION,
    GERRIT_PROJECT,
    GERRIT_REFSPEC,
    GERRIT_CHANGE_ABANDONER,
    GERRIT_CHANGE_ABANDONER_NAME,
    GERRIT_CHANGE_ABANDONER_EMAIL,
    GERRIT_CHANGE_OWNER,
    GERRIT_CHANGE_OWNER_NAME,
    GERRIT_CHANGE_OWNER_EMAIL,
    GERRIT_CHANGE_RESTORER,
    GERRIT_CHANGE_RESTORER_NAME,
    GERRIT_CHANGE_RESTORER_EMAIL,
    GERRIT_PATCHSET_UPLOADER,
    GERRIT_PATCHSET_UPLOADER_NAME,
    GERRIT_PATCHSET_UPLOADER_EMAIL,
    GERRIT_EVENT_ACCOUNT,
    GERRIT_EVENT_ACCOUNT_NAME,
    GERRIT_EVENT_ACCOUNT_EMAIL,
    GERRIT_REFNAME,
    GERRIT_OLDREV,
    GERRIT_NEWREV,
    GERRIT_SUBMITTER,
    GERRIT_SUBMITTER_NAME,
    GERRIT_SUBMITTER_EMAIL,
    GERRIT_NAME,
    GERRIT_HOST,
    GERRIT_PORT,
    GERRIT_SCHEME,
    GERRIT_VERSION,
    GERRIT_EVENT_HASH,
    GERRIT_EVENT_TYPE,
    GERRIT_EVENT_COMMENT_TEXT;

    private static final Logger logger;

    public static Set<String> getNamesSet() {
        TreeSet<String> names = new TreeSet<String>();
        for (GerritTriggerParameters p : GerritTriggerParameters.values()) {
            names.add(p.name());
        }
        return names;
    }

    private void setOrCreateParameterValue(List<ParameterValue> parameters, String value, boolean escapeQuotes, Class<? extends StringParameterValue> clazz) {
        String stringValue;
        ParameterValue parameter = null;
        for (ParameterValue p : parameters) {
            if (!p.getName().toUpperCase().equals(this.name())) continue;
            parameter = p;
            break;
        }
        String description = null;
        if (parameter != null) {
            if (parameter instanceof StringParameterValue) {
                description = parameter.getDescription();
            }
            parameters.remove(parameter);
        }
        if ((stringValue = escapeQuotes ? StringUtil.escapeQuotes(value) : value) == null) {
            stringValue = "";
        }
        Class[] types = new Class[]{String.class, String.class, String.class};
        Object[] args = new Object[]{this.name(), stringValue, description};
        try {
            Constructor<? extends StringParameterValue> constructor = clazz.getConstructor(types);
            parameter = (ParameterValue)constructor.newInstance(args);
            parameters.add(parameter);
        }
        catch (Exception ex) {
            parameter = null;
        }
    }

    public void setOrCreateStringParameterValue(List<ParameterValue> parameters, String value, boolean escapeQuotes) {
        this.setOrCreateParameterValue(parameters, value, escapeQuotes, StringParameterValue.class);
    }

    public void setOrCreateTextParameterValue(List<ParameterValue> parameters, String value, boolean escapeQuotes) {
        this.setOrCreateParameterValue(parameters, value, escapeQuotes, TextParameterValue.class);
    }

    public void setOrCreateBase64EncodedStringParameterValue(List<ParameterValue> parameters, String value, boolean escapeQuotes) {
        this.setOrCreateParameterValue(parameters, value, escapeQuotes, Base64EncodedStringParameterValue.class);
    }

    public static void setOrCreateParameters(GerritTriggeredEvent gerritEvent, List<ParameterValue> parameters) {
        GerritTriggerParameters.setOrCreateParameters(gerritEvent, null, parameters);
    }

    public static void setOrCreateParameters(GerritTriggeredEvent gerritEvent, Job project, List<ParameterValue> parameters) {
        Provider provider;
        ChangeBasedEvent event;
        GerritTrigger trigger;
        ParameterMode nameAndEmailParameterMode = ParameterMode.PLAIN;
        boolean escapeQuotes = false;
        ParameterMode commitMessageMode = ParameterMode.BASE64;
        ParameterMode changeSubjectMode = ParameterMode.PLAIN;
        ParameterMode commentTextMode = ParameterMode.BASE64;
        if (project != null && (trigger = GerritTrigger.getTrigger(project)) != null) {
            nameAndEmailParameterMode = trigger.getNameAndEmailParameterMode();
            escapeQuotes = trigger.isEscapeQuotes();
            commitMessageMode = trigger.getCommitMessageParameterMode();
            changeSubjectMode = trigger.getChangeSubjectParameterMode();
            commentTextMode = trigger.getCommentTextParameterMode();
        }
        GERRIT_EVENT_TYPE.setOrCreateStringParameterValue(parameters, gerritEvent.getEventType().getTypeValue(), escapeQuotes);
        GERRIT_EVENT_HASH.setOrCreateStringParameterValue(parameters, String.valueOf(gerritEvent.hashCode()), escapeQuotes);
        if (gerritEvent instanceof ChangeBasedEvent) {
            String comment;
            event = (ChangeBasedEvent)gerritEvent;
            GERRIT_BRANCH.setOrCreateStringParameterValue(parameters, event.getChange().getBranch(), escapeQuotes);
            GERRIT_TOPIC.setOrCreateStringParameterValue(parameters, event.getChange().getTopic(), escapeQuotes);
            GERRIT_CHANGE_NUMBER.setOrCreateStringParameterValue(parameters, event.getChange().getNumber(), escapeQuotes);
            GERRIT_CHANGE_ID.setOrCreateStringParameterValue(parameters, event.getChange().getId(), escapeQuotes);
            String pNumber = null;
            if (null != event.getPatchSet()) {
                pNumber = event.getPatchSet().getNumber();
                GERRIT_PATCHSET_NUMBER.setOrCreateStringParameterValue(parameters, pNumber, escapeQuotes);
                GERRIT_PATCHSET_REVISION.setOrCreateStringParameterValue(parameters, event.getPatchSet().getRevision(), escapeQuotes);
                GERRIT_REFSPEC.setOrCreateStringParameterValue(parameters, StringUtil.makeRefSpec(event), escapeQuotes);
            }
            GERRIT_PROJECT.setOrCreateStringParameterValue(parameters, event.getChange().getProject(), escapeQuotes);
            if (event instanceof ChangeRestored) {
                nameAndEmailParameterMode.setOrCreateParameterValue(GERRIT_CHANGE_RESTORER, parameters, GerritTriggerParameters.getNameAndEmail(((ChangeRestored)event).getRestorer()), ParameterMode.PlainMode.STRING, escapeQuotes);
                GERRIT_CHANGE_RESTORER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(((ChangeRestored)event).getRestorer()), escapeQuotes);
                GERRIT_CHANGE_RESTORER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(((ChangeRestored)event).getRestorer()), escapeQuotes);
            }
            changeSubjectMode.setOrCreateParameterValue(GERRIT_CHANGE_SUBJECT, parameters, event.getChange().getSubject(), ParameterMode.PlainMode.STRING, escapeQuotes);
            String url = GerritTriggerParameters.getURL(event, project);
            String commitMessage = event.getChange().getCommitMessage();
            if (commitMessage != null) {
                commitMessageMode.setOrCreateParameterValue(GERRIT_CHANGE_COMMIT_MESSAGE, parameters, commitMessage, ParameterMode.PlainMode.TEXT, escapeQuotes);
            }
            GERRIT_CHANGE_URL.setOrCreateStringParameterValue(parameters, url, escapeQuotes);
            if (event instanceof ChangeAbandoned) {
                nameAndEmailParameterMode.setOrCreateParameterValue(GERRIT_CHANGE_ABANDONER, parameters, GerritTriggerParameters.getNameAndEmail(((ChangeAbandoned)event).getAbandoner()), ParameterMode.PlainMode.STRING, escapeQuotes);
                GERRIT_CHANGE_ABANDONER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(((ChangeAbandoned)event).getAbandoner()), escapeQuotes);
                GERRIT_CHANGE_ABANDONER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(((ChangeAbandoned)event).getAbandoner()), escapeQuotes);
            }
            if (event instanceof TopicChanged) {
                GERRIT_OLD_TOPIC.setOrCreateStringParameterValue(parameters, ((TopicChanged)event).getOldTopic(), escapeQuotes);
                nameAndEmailParameterMode.setOrCreateParameterValue(GERRIT_TOPIC_CHANGER, parameters, GerritTriggerParameters.getNameAndEmail(((TopicChanged)event).getChanger()), ParameterMode.PlainMode.STRING, escapeQuotes);
                GERRIT_TOPIC_CHANGER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(((TopicChanged)event).getChanger()), escapeQuotes);
                GERRIT_TOPIC_CHANGER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(((TopicChanged)event).getChanger()), escapeQuotes);
            }
            if (event instanceof ChangeMerged) {
                GERRIT_NEWREV.setOrCreateStringParameterValue(parameters, ((ChangeMerged)event).getNewRev(), escapeQuotes);
            }
            nameAndEmailParameterMode.setOrCreateParameterValue(GERRIT_CHANGE_OWNER, parameters, GerritTriggerParameters.getNameAndEmail(event.getChange().getOwner()), ParameterMode.PlainMode.STRING, escapeQuotes);
            GERRIT_CHANGE_OWNER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(event.getChange().getOwner()), escapeQuotes);
            GERRIT_CHANGE_OWNER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(event.getChange().getOwner()), escapeQuotes);
            Account uploader = GerritTriggerParameters.findUploader(event);
            nameAndEmailParameterMode.setOrCreateParameterValue(GERRIT_PATCHSET_UPLOADER, parameters, GerritTriggerParameters.getNameAndEmail(uploader), ParameterMode.PlainMode.STRING, escapeQuotes);
            GERRIT_PATCHSET_UPLOADER_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(uploader), escapeQuotes);
            GERRIT_PATCHSET_UPLOADER_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(uploader), escapeQuotes);
            if (event instanceof CommentAdded && (comment = ((CommentAdded)event).getComment()) != null) {
                commentTextMode.setOrCreateParameterValue(GERRIT_EVENT_COMMENT_TEXT, parameters, comment, ParameterMode.PlainMode.TEXT, escapeQuotes);
            }
        } else if (gerritEvent instanceof RefUpdated) {
            event = (RefUpdated)gerritEvent;
            GERRIT_REFNAME.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getRefName(), escapeQuotes);
            GERRIT_PROJECT.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getProject(), escapeQuotes);
            GERRIT_OLDREV.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getOldRev(), escapeQuotes);
            GERRIT_NEWREV.setOrCreateStringParameterValue(parameters, event.getRefUpdate().getNewRev(), escapeQuotes);
        }
        Account account = gerritEvent.getAccount();
        if (account != null) {
            nameAndEmailParameterMode.setOrCreateParameterValue(GERRIT_EVENT_ACCOUNT, parameters, GerritTriggerParameters.getNameAndEmail(account), ParameterMode.PlainMode.STRING, escapeQuotes);
            GERRIT_EVENT_ACCOUNT_NAME.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getName(account), escapeQuotes);
            GERRIT_EVENT_ACCOUNT_EMAIL.setOrCreateStringParameterValue(parameters, GerritTriggerParameters.getEmail(account), escapeQuotes);
        }
        if ((provider = gerritEvent.getProvider()) != null) {
            GERRIT_NAME.setOrCreateStringParameterValue(parameters, provider.getName(), escapeQuotes);
            GERRIT_HOST.setOrCreateStringParameterValue(parameters, provider.getHost(), escapeQuotes);
            GERRIT_PORT.setOrCreateStringParameterValue(parameters, provider.getPort(), escapeQuotes);
            GERRIT_SCHEME.setOrCreateStringParameterValue(parameters, provider.getScheme(), escapeQuotes);
            GERRIT_VERSION.setOrCreateStringParameterValue(parameters, provider.getVersion(), escapeQuotes);
        }
    }

    private static String getURL(ChangeBasedEvent event, Job project) {
        String name;
        String url = "";
        String serverName = null;
        if (event.getProvider() != null) {
            serverName = event.getProvider().getName();
        } else if (project != null && !"__ANY__".equals(name = GerritTrigger.getTrigger(project).getServerName())) {
            serverName = name;
        }
        GerritServer firstServer = PluginImpl.getFirstServer_();
        if (serverName == null && firstServer != null) {
            logger.warn("No server could be determined from event or project config, defaulting to the first configured server. Event: [{}] Project: [{}]", (Object)event, (Object)project);
            serverName = firstServer.getName();
        } else if (serverName == null) {
            throw new IllegalStateException("Cannot determine a Gerrit server to link to. Have you configured one?");
        }
        GerritServer server = PluginImpl.getServer_(serverName);
        if (server != null) {
            IGerritHudsonTriggerConfig config = server.getConfig();
            if (config != null) {
                url = config.getGerritFrontEndUrlFor((GerritTriggeredEvent)event);
            } else {
                logger.error("Could not find config for Gerrit server {}", (Object)serverName);
            }
        } else {
            logger.error("Could not find Gerrit server {}", (Object)serverName);
        }
        return url;
    }

    private static Account findUploader(ChangeBasedEvent event) {
        if (event.getPatchSet() != null && event.getPatchSet().getUploader() != null) {
            return event.getPatchSet().getUploader();
        }
        return event.getAccount();
    }

    private static String getName(Account account) {
        if (account == null) {
            return "";
        }
        return account.getName();
    }

    private static String getNameAndEmail(Account account) {
        if (account == null) {
            return "";
        }
        return account.getNameAndEmail();
    }

    private static String getEmail(Account account) {
        if (account == null) {
            return "";
        }
        return account.getEmail();
    }

    static {
        logger = LoggerFactory.getLogger(GerritTriggerParameters.class);
    }

    public static enum ParameterMode {
        PLAIN(Messages._ParameterMode_PLAIN()){

            @Override
            void setOrCreateParameterValue(GerritTriggerParameters parameter, List<ParameterValue> parameters, String value, PlainMode mode, boolean escapeQuotes) {
                parameter.setOrCreateParameterValue(parameters, value, escapeQuotes, mode.clazz);
            }
        }
        ,
        BASE64(Messages._ParameterMode_BASE64()){

            @Override
            void setOrCreateParameterValue(GerritTriggerParameters parameter, List<ParameterValue> parameters, String value, PlainMode mode, boolean escapeQuotes) {
                try {
                    parameter.setOrCreateBase64EncodedStringParameterValue(parameters, 2.encodeBase64(value), escapeQuotes);
                }
                catch (UnsupportedEncodingException uee) {
                    logger.error("Failed to encode " + parameter.name() + " as Base64: ", (Throwable)uee);
                }
            }
        }
        ,
        NONE(Messages._ParameterMode_NONE()){

            @Override
            void setOrCreateParameterValue(GerritTriggerParameters parameter, List<ParameterValue> parameters, String value, PlainMode mode, boolean escapeQuotes) {
            }
        };

        private final Localizable displayName;

        public static String encodeBase64(String original) throws UnsupportedEncodingException {
            byte[] encodedBytes = Base64.encodeBase64((byte[])original.getBytes("UTF-8"));
            return new String(encodedBytes, Charset.forName("UTF-8"));
        }

        private ParameterMode(Localizable displayName) {
            this.displayName = displayName;
        }

        abstract void setOrCreateParameterValue(GerritTriggerParameters var1, List<ParameterValue> var2, String var3, PlainMode var4, boolean var5);

        public String toString() {
            return this.displayName.toString();
        }

        static enum PlainMode {
            STRING(StringParameterValue.class),
            TEXT(TextParameterValue.class);

            final Class<? extends StringParameterValue> clazz;

            private PlainMode(Class<? extends StringParameterValue> clazz) {
                this.clazz = clazz;
            }
        }
    }
}

