/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritChangeKind;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.PatchsetCreated;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

public class PluginPatchsetCreatedEvent
extends PluginGerritEvent
implements Serializable {
    private static final long serialVersionUID = 970946986242309088L;
    private boolean excludeDrafts = false;
    private boolean excludeTrivialRebase = false;
    private boolean excludeNoCodeChange = false;

    public PluginPatchsetCreatedEvent() {
        this(false, false, false);
    }

    @DataBoundConstructor
    public PluginPatchsetCreatedEvent(boolean excludeDrafts, boolean excludeTrivialRebase, boolean excludeNoCodeChange) {
        this.excludeDrafts = excludeDrafts;
        this.excludeTrivialRebase = excludeTrivialRebase;
        this.excludeNoCodeChange = excludeNoCodeChange;
    }

    public Descriptor<PluginGerritEvent> getDescriptor() {
        return Hudson.getInstance().getDescriptorByType(PluginPatchsetCreatedEventDescriptor.class);
    }

    @Override
    public Class getCorrespondingEventClass() {
        return PatchsetCreated.class;
    }

    public boolean isExcludeDrafts() {
        return this.excludeDrafts;
    }

    public boolean isExcludeTrivialRebase() {
        return this.excludeTrivialRebase;
    }

    public boolean isExcludeNoCodeChange() {
        return this.excludeNoCodeChange;
    }

    @Override
    public boolean shouldTriggerOn(GerritTriggeredEvent event) {
        if (!super.shouldTriggerOn(event)) {
            return false;
        }
        if (this.excludeDrafts && ((PatchsetCreated)event).getPatchSet().isDraft()) {
            return false;
        }
        if (event instanceof ManualPatchsetCreated) {
            return true;
        }
        if (this.excludeTrivialRebase && GerritChangeKind.TRIVIAL_REBASE == ((PatchsetCreated)event).getPatchSet().getKind()) {
            return false;
        }
        return !this.excludeNoCodeChange || GerritChangeKind.NO_CODE_CHANGE != ((PatchsetCreated)event).getPatchSet().getKind();
    }

    @Extension
    public static class PluginPatchsetCreatedEventDescriptor
    extends PluginGerritEvent.PluginGerritEventDescriptor {
        public String getDisplayName() {
            return Messages.PatchsetCreatedDisplayName();
        }
    }
}

