/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.VerdictCategory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.CommentAdded;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PluginCommentAddedEvent
extends PluginGerritEvent
implements Serializable {
    private static final long serialVersionUID = -1190562081236235819L;
    private String verdictCategory;
    private String commentAddedTriggerApprovalValue;

    @DataBoundConstructor
    public PluginCommentAddedEvent(String verdictCategory, String commentAddedTriggerApprovalValue) {
        this.verdictCategory = verdictCategory;
        this.commentAddedTriggerApprovalValue = commentAddedTriggerApprovalValue;
    }

    public PluginCommentAddedEvent() {
    }

    public String getCommentAddedTriggerApprovalValue() {
        return this.commentAddedTriggerApprovalValue;
    }

    public String getVerdictCategory() {
        return this.verdictCategory;
    }

    public Descriptor<PluginGerritEvent> getDescriptor() {
        return Hudson.getInstance().getDescriptorByType(PluginCommentAddedEventDescriptor.class);
    }

    @Override
    public Class getCorrespondingEventClass() {
        return CommentAdded.class;
    }

    @Extension
    public static class PluginCommentAddedEventDescriptor
    extends PluginGerritEvent.PluginGerritEventDescriptor {
        public String getDisplayName() {
            return Messages.CommentAddedDisplayName();
        }

        public ListBoxModel doFillVerdictCategoryItems(@QueryParameter(value="serverName") @RelativePath(value="..") String serverName) {
            ListBoxModel m = new ListBoxModel();
            Collection list = null;
            if ("__ANY__".equals(serverName)) {
                HashMap<String, VerdictCategory> map = new HashMap<String, VerdictCategory>();
                for (GerritServer server : PluginImpl.getServers_()) {
                    for (VerdictCategory vc : server.getConfig().getCategories()) {
                        if (map.containsKey(vc.getVerdictValue())) continue;
                        map.put(vc.getVerdictValue(), vc);
                    }
                }
                list = map.values();
            } else {
                IGerritHudsonTriggerConfig config;
                GerritServer server = PluginImpl.getServer_(serverName);
                if (server != null && (config = server.getConfig()) != null) {
                    list = config.getCategories();
                }
            }
            if (list != null && !list.isEmpty()) {
                for (VerdictCategory v : list) {
                    m.add(v.getVerdictDescription(), v.getVerdictValue());
                }
            }
            return m;
        }
    }
}

