/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.manual;

import com.sonyericsson.hudson.plugins.gerrit.trigger.events.lifecycle.GerritEventLifecycle;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.lifecycle.GerritEventLifecycleListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggeredItemEntity;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import hudson.model.BallColor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TriggerMonitor
implements GerritEventLifecycleListener {
    private List<EventState> events = new LinkedList<EventState>();

    public synchronized void add(GerritEventLifecycle gerritEventLifecycle) {
        if (!this.contains(gerritEventLifecycle)) {
            gerritEventLifecycle.addListener(this);
            this.events.add(new EventState(gerritEventLifecycle));
        }
    }

    public synchronized boolean contains(GerritEventLifecycle gerritEventLifecycle) {
        return this.findState(gerritEventLifecycle.getEvent()) != null;
    }

    private synchronized EventState findState(GerritEvent gerritEvent) {
        for (EventState state : this.events) {
            if (!state.gerritEventLifecycle.getEvent().equals(gerritEvent)) continue;
            return state;
        }
        return null;
    }

    @Override
    public synchronized void triggerScanStarting(GerritEvent event) {
        EventState state = this.findState(event);
        if (state != null) {
            state.triggerScanStarted = true;
        }
    }

    @Override
    public synchronized void triggerScanDone(GerritEvent event) {
        EventState state = this.findState(event);
        if (state != null) {
            state.triggerScanDone = true;
        }
    }

    @Override
    public synchronized void projectTriggered(GerritEvent event, Job project) {
        EventState state = this.findState(event);
        if (state != null) {
            state.addProject(project);
        }
    }

    @Override
    public synchronized void buildStarted(GerritEvent event, Run build) {
        EventState state = this.findState(event);
        if (state != null) {
            state.setBuild(build);
        }
    }

    @Override
    public synchronized void buildCompleted(GerritEvent event, Run build) {
        EventState state = this.findState(event);
        if (state != null && state.allBuildsCompleted && state.isReallyAllBuildsCompleted()) {
            state.gerritEventLifecycle.removeListener(this);
        }
    }

    @Override
    public synchronized void allBuildsCompleted(GerritEvent event) {
        EventState state = this.findState(event);
        if (state != null) {
            state.allBuildsCompleted = true;
            if (state.isReallyAllBuildsCompleted()) {
                state.gerritEventLifecycle.removeListener(this);
            }
        }
    }

    public synchronized List<EventState> getEvents() {
        return this.events;
    }

    public synchronized Iterator<EventState> getEventsIterator() {
        return this.events.iterator();
    }

    public static class EventState {
        private GerritEventLifecycle gerritEventLifecycle;
        private boolean triggerScanStarted = false;
        private boolean triggerScanDone = false;
        private boolean allBuildsCompleted = false;
        private List<TriggeredItemEntity> builds;

        EventState(GerritEventLifecycle gerritEventLifecycle) {
            this.gerritEventLifecycle = gerritEventLifecycle;
            this.builds = new LinkedList<TriggeredItemEntity>();
        }

        void addProject(Job project) {
            this.builds.add(new TriggeredItemEntity(project));
        }

        void setBuild(Run build) {
            for (TriggeredItemEntity entity : this.builds) {
                if (!entity.equals(build.getParent())) continue;
                entity.setBuild(build);
            }
        }

        public String getBallColor() {
            if (!this.triggerScanStarted) {
                return BallColor.GREY.getImage();
            }
            if (!this.triggerScanDone) {
                return BallColor.GREY_ANIME.getImage();
            }
            if (this.isUnTriggered()) {
                return BallColor.DISABLED.getImage();
            }
            Result result = this.getLeastFavorableResult();
            if (result != null) {
                return result.color.getImage();
            }
            return BallColor.GREY_ANIME.getImage();
        }

        private Result getLeastFavorableResult() {
            Result least = null;
            for (TriggeredItemEntity entity : this.builds) {
                if (entity.getBuild() == null || entity.getBuild().getResult() == null) continue;
                Result tmp = entity.getBuild().getResult();
                if (least == null) {
                    least = tmp;
                    continue;
                }
                least = least.combine(tmp);
            }
            return least;
        }

        public boolean isUnTriggered() {
            if (!this.triggerScanStarted) {
                return false;
            }
            return this.triggerScanDone && this.builds.size() <= 0;
        }

        public GerritEventLifecycle getEvent() {
            return this.gerritEventLifecycle;
        }

        public boolean isTriggerScanStarted() {
            return this.triggerScanStarted;
        }

        public boolean isTriggerScanDone() {
            return this.triggerScanDone;
        }

        public boolean isAllBuildsCompleted() {
            return this.allBuildsCompleted;
        }

        public List<TriggeredItemEntity> getBuilds() {
            return this.builds;
        }

        public boolean isReallyAllBuildsCompleted() {
            for (TriggeredItemEntity entity : this.builds) {
                if (entity.getBuild() != null && entity.getBuild().isLogUpdated()) continue;
                return false;
            }
            return true;
        }
    }
}

