/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.Branch;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.CompareType;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.FilePath;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritProject;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.Topic;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritDynamicUrlProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GerritDynamicUrlProcessor.class);
    private static final String SHORTNAME_PROJECT = "p";
    private static final String SHORTNAME_BRANCH = "b";
    private static final String SHORTNAME_TOPIC = "t";
    private static final String SHORTNAME_FILE = "f";
    private static final String SHORTNAME_FORBIDDEN_FILE = "o";
    private static final int SOCKET_READ_TIMEOUT = 10000;

    private GerritDynamicUrlProcessor() {
    }

    private static Pattern buildLinePattern() {
        String projectBranchFile = "^(p|b|t|f|o)";
        StringBuilder operators = new StringBuilder("(");
        boolean firstoperator = true;
        for (CompareType type : CompareType.values()) {
            if (!firstoperator) {
                operators.append("|");
            }
            operators.append(type.getOperator());
            firstoperator = false;
        }
        operators.append(")");
        return Pattern.compile(projectBranchFile + "\\s*" + operators.toString() + "\\s*(.+)$");
    }

    private static List<GerritProject> readAndParseTriggerConfig(BufferedReader reader, String serverName) throws IOException, ParseException {
        Pattern linePattern = GerritDynamicUrlProcessor.buildLinePattern();
        ArrayList<GerritProject> dynamicGerritProjects = new ArrayList<GerritProject>();
        ArrayList<Branch> branches = null;
        ArrayList<Topic> topics = null;
        ArrayList<FilePath> filePaths = null;
        ArrayList<FilePath> forbiddenFilePaths = null;
        GerritProject dynamicGerritProject = null;
        String line = "";
        int lineNr = 0;
        while ((line = reader.readLine()) != null) {
            FilePath filePath;
            ++lineNr;
            int commentPos = line.indexOf(35);
            if (commentPos > -1) {
                line = line.substring(0, commentPos);
            }
            if ((commentPos = line.indexOf(59)) > -1) {
                line = line.substring(0, commentPos);
            }
            if ((line = line.trim()).isEmpty()) continue;
            Matcher matcher = linePattern.matcher(line);
            if (!matcher.matches()) {
                throw new ParseException("Line " + lineNr + ": cannot parse '" + line + "'", lineNr);
            }
            String item = matcher.group(1);
            String oper = matcher.group(2);
            String text = matcher.group(3);
            if (item == null || oper == null || text == null) {
                throw new ParseException("Line " + lineNr + ": cannot parse '" + line + "'", lineNr);
            }
            char operChar = oper.charAt(0);
            CompareType type = CompareType.findByOperator(operChar);
            logger.trace("==> item:({0}) oper:({1}) text:({2})", new Object[]{item, oper, text});
            if (SHORTNAME_PROJECT.equals(item)) {
                if (dynamicGerritProject != null) {
                    dynamicGerritProjects.add(dynamicGerritProject);
                }
                branches = new ArrayList<Branch>();
                topics = new ArrayList<Topic>();
                filePaths = new ArrayList<FilePath>();
                forbiddenFilePaths = new ArrayList<FilePath>();
                dynamicGerritProject = new GerritProject(type, text, branches, topics, filePaths, forbiddenFilePaths, false);
                continue;
            }
            if (SHORTNAME_BRANCH.equals(item)) {
                if (branches == null) {
                    throw new ParseException("Line " + lineNr + ": attempt to use 'Branch' before 'Project'", lineNr);
                }
                Branch branch = new Branch(type, text);
                branches.add(branch);
                dynamicGerritProject.setBranches(branches);
                continue;
            }
            if (SHORTNAME_TOPIC.equals(item)) {
                if (topics == null) {
                    throw new ParseException("Line " + lineNr + ": attempt to use 'Topic' before 'Project'", lineNr);
                }
                Topic topic = new Topic(type, text);
                topics.add(topic);
                dynamicGerritProject.setTopics(topics);
                continue;
            }
            if (SHORTNAME_FILE.equals(item)) {
                if (filePaths == null) {
                    throw new ParseException("Line " + lineNr + ": attempt to use 'FilePath' before 'Project'", lineNr);
                }
                filePath = new FilePath(type, text);
                filePaths.add(filePath);
                dynamicGerritProject.setFilePaths(filePaths);
                continue;
            }
            if (!SHORTNAME_FORBIDDEN_FILE.equals(item)) continue;
            if (forbiddenFilePaths == null) {
                throw new ParseException("Line " + lineNr + ": attempt to use 'ForbiddenFilePath' before 'Project'", lineNr);
            }
            filePath = new FilePath(type, text);
            forbiddenFilePaths.add(filePath);
            dynamicGerritProject.setForbiddenFilePaths(filePaths);
        }
        if (dynamicGerritProject != null) {
            dynamicGerritProjects.add(dynamicGerritProject);
        }
        return dynamicGerritProjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GerritProject> fetch(String gerritTriggerConfigUrl, String serverName) throws IOException, ParseException {
        if (gerritTriggerConfigUrl == null) {
            throw new MalformedURLException("The gerritTriggerConfigUrl is null");
        }
        if (gerritTriggerConfigUrl.isEmpty()) {
            throw new MalformedURLException("The gerritTriggerConfigUrl is empty");
        }
        URL url = new URL(gerritTriggerConfigUrl);
        URLConnection connection = url.openConnection();
        connection.setReadTimeout(10000);
        connection.setDoInput(true);
        InputStream instream = null;
        BufferedReader reader = null;
        try {
            instream = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(instream, Charset.forName("UTF-8")));
            List<GerritProject> list = GerritDynamicUrlProcessor.readAndParseTriggerConfig(reader, serverName);
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            } else if (instream != null) {
                instream.close();
            }
        }
    }
}

