/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import hudson.model.AbstractProject;
import hudson.model.Action;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RetriggerAllAction
implements Action {
    private TriggerContext context;

    public RetriggerAllAction(TriggerContext context) {
        this.context = context;
    }

    public RetriggerAllAction() {
    }

    public String getIconFileName() {
        if (!this.hasPermission() || this.isBuilding() || !this.hasOthers()) {
            return null;
        }
        return "/plugin/gerrit-trigger/images/icon_retrigger24.png";
    }

    public String getDisplayName() {
        if (!this.hasPermission() || this.isBuilding() || !this.hasOthers()) {
            return null;
        }
        return Messages.RetriggerAll();
    }

    public String getUrlName() {
        if (!this.hasPermission() || this.isBuilding() || !this.hasOthers()) {
            return null;
        }
        return "gerrit-trigger-retrigger-all";
    }

    private boolean hasOthers() {
        if (this.context != null) {
            return this.context.hasOthers();
        }
        return false;
    }

    private boolean isBuilding() {
        if (this.context != null) {
            return this.context.getThisBuild().getBuild().isBuilding() || ToGerritRunListener.getInstance().isBuilding(this.context.getEvent());
        }
        return false;
    }

    private boolean hasPermission() {
        if (this.context == null || this.context.getThisBuild() == null) {
            return false;
        }
        if (this.context.getThisBuild().getProject().hasPermission(AbstractProject.BUILD)) {
            for (AbstractProject project : this.context.getOtherProjects()) {
                if (project.hasPermission(AbstractProject.BUILD)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        if (this.context == null || this.context.getThisBuild() == null) {
            return;
        }
        if (!this.hasPermission()) {
            return;
        }
        if (this.isBuilding()) {
            return;
        }
        if (!this.context.hasOthers()) {
            return;
        }
        TriggerContext.TriggeredItemEntity entity = this.context.getThisBuild();
        GerritTrigger trigger = (GerritTrigger)entity.getProject().getTrigger(GerritTrigger.class);
        if (trigger == null) {
            return;
        }
        trigger.retriggerAllBuilds(this.context);
        response.sendRedirect2(entity.getProject().getAbsoluteUrl());
    }
}

