/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.GerritEventListener;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.GerritEvent;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ChangeAbandoned;
import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.BadgeAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritUserCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.RetriggerAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.RetriggerAllAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.CompareType;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritProject;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GerritTrigger
extends Trigger<AbstractProject>
implements GerritEventListener {
    public static final int BUILD_SCHEDULE_DELAY = 3;
    public static final String GERRIT_CHANGE_SUBJECT = "GERRIT_CHANGE_SUBJECT";
    public static final String GERRIT_BRANCH = "GERRIT_BRANCH";
    public static final String GERRIT_CHANGE_ID = "GERRIT_CHANGE_ID";
    public static final String GERRIT_CHANGE_NUMBER = "GERRIT_CHANGE_NUMBER";
    public static final String GERRIT_CHANGE_URL = "GERRIT_CHANGE_URL";
    public static final String GERRIT_PATCHSET_NUMBER = "GERRIT_PATCHSET_NUMBER";
    public static final String GERRIT_PATCHSET_REVISION = "GERRIT_PATCHSET_REVISION";
    public static final String GERRIT_PROJECT = "GERRIT_PROJECT";
    public static final String GERRIT_REFSPEC = "GERRIT_REFSPEC";
    private static final Logger logger = LoggerFactory.getLogger(GerritTrigger.class);
    private transient AbstractProject myProject;
    private List<GerritProject> gerritProjects;
    private Integer gerritBuildStartedVerifiedValue;
    private Integer gerritBuildStartedCodeReviewValue;
    private Integer gerritBuildSuccessfulVerifiedValue;
    private Integer gerritBuildSuccessfulCodeReviewValue;
    private Integer gerritBuildFailedVerifiedValue;
    private Integer gerritBuildFailedCodeReviewValue;
    private Integer gerritBuildUnstableVerifiedValue;
    private Integer gerritBuildUnstableCodeReviewValue;
    private boolean silentMode;

    @DataBoundConstructor
    public GerritTrigger(List<GerritProject> gerritProjects, Integer gerritBuildStartedVerifiedValue, Integer gerritBuildStartedCodeReviewValue, Integer gerritBuildSuccessfulVerifiedValue, Integer gerritBuildSuccessfulCodeReviewValue, Integer gerritBuildFailedVerifiedValue, Integer gerritBuildFailedCodeReviewValue, Integer gerritBuildUnstableVerifiedValue, Integer gerritBuildUnstableCodeReviewValue, boolean silentMode) {
        this.gerritProjects = gerritProjects;
        this.gerritBuildStartedVerifiedValue = gerritBuildStartedVerifiedValue;
        this.gerritBuildStartedCodeReviewValue = gerritBuildStartedCodeReviewValue;
        this.gerritBuildSuccessfulVerifiedValue = gerritBuildSuccessfulVerifiedValue;
        this.gerritBuildSuccessfulCodeReviewValue = gerritBuildSuccessfulCodeReviewValue;
        this.gerritBuildFailedVerifiedValue = gerritBuildFailedVerifiedValue;
        this.gerritBuildFailedCodeReviewValue = gerritBuildFailedCodeReviewValue;
        this.gerritBuildUnstableVerifiedValue = gerritBuildUnstableVerifiedValue;
        this.gerritBuildUnstableCodeReviewValue = gerritBuildUnstableCodeReviewValue;
        this.silentMode = silentMode;
    }

    public void start(AbstractProject project, boolean newInstance) {
        logger.debug("Start project: {}", (Object)project);
        super.start((Item)project, newInstance);
        this.myProject = project;
        try {
            if (PluginImpl.getInstance() != null) {
                PluginImpl.getInstance().addListener(this);
            } else {
                logger.warn("The plugin instance could not be found! Project {} will not be triggered!", (Object)project.getFullDisplayName());
            }
        }
        catch (IllegalStateException e) {
            logger.error("I am too early!", (Throwable)e);
        }
    }

    public void stop() {
        logger.debug("Stop");
        super.stop();
        try {
            if (PluginImpl.getInstance() != null) {
                PluginImpl.getInstance().removeListener(this);
            }
        }
        catch (IllegalStateException e) {
            logger.error("I am too late!", (Throwable)e);
        }
    }

    public void gerritEvent(GerritEvent event) {
    }

    public void gerritEvent(PatchsetCreated event) {
        logger.trace("event: {}", (Object)event);
        if (!this.myProject.isBuildable()) {
            logger.trace("Disabled.");
            return;
        }
        if (this.isInteresting(event)) {
            logger.trace("The event is interesting.");
            if (!this.silentMode) {
                ToGerritRunListener.getInstance().onTriggered(this.myProject, event);
            }
            GerritCause cause = new GerritCause(event, this.silentMode);
            this.schedule(cause, event);
        }
    }

    protected void schedule(GerritCause cause, PatchsetCreated event) {
        this.schedule(cause, event, this.myProject);
    }

    protected void schedule(GerritCause cause, PatchsetCreated event, AbstractProject project) {
        boolean ok = project.scheduleBuild(3, (Cause)cause, new Action[]{new BadgeAction(event), new RetriggerAction(cause.getContext()), new RetriggerAllAction(cause.getContext()), this.createParameters(event, cause, project)});
        logger.info("Project {} Build Scheduled: {} By event: {}", new Object[]{project.getName(), ok, event.getChange().getNumber() + "/" + event.getPatchSet().getNumber()});
    }

    protected ParametersAction createParameters(PatchsetCreated event, GerritCause cause, AbstractProject project) {
        List<ParameterValue> parameters = this.getDefaultParametersValues(project);
        this.setOrCreateStringParameterValue(parameters, GERRIT_BRANCH, event.getChange().getBranch());
        this.setOrCreateStringParameterValue(parameters, GERRIT_BRANCH, event.getChange().getBranch());
        this.setOrCreateStringParameterValue(parameters, GERRIT_CHANGE_NUMBER, event.getChange().getNumber());
        this.setOrCreateStringParameterValue(parameters, GERRIT_CHANGE_ID, event.getChange().getId());
        this.setOrCreateStringParameterValue(parameters, GERRIT_PATCHSET_NUMBER, event.getPatchSet().getNumber());
        this.setOrCreateStringParameterValue(parameters, GERRIT_PATCHSET_REVISION, event.getPatchSet().getRevision());
        this.setOrCreateStringParameterValue(parameters, GERRIT_REFSPEC, StringUtil.makeRefSpec(event));
        this.setOrCreateStringParameterValue(parameters, GERRIT_PROJECT, event.getChange().getProject());
        this.setOrCreateStringParameterValue(parameters, GERRIT_CHANGE_SUBJECT, event.getChange().getSubject());
        this.setOrCreateStringParameterValue(parameters, GERRIT_CHANGE_URL, cause.getUrl());
        return new ParametersAction(parameters);
    }

    private void setOrCreateStringParameterValue(List<ParameterValue> parameters, String name, String value) {
        StringParameterValue parameter = null;
        for (ParameterValue p : parameters) {
            if (!p.getName().toUpperCase().equals(name)) continue;
            parameter = p;
            break;
        }
        String description = null;
        if (parameter != null) {
            if (parameter instanceof StringParameterValue) {
                description = parameter.getDescription();
            }
            parameters.remove(parameter);
        }
        parameter = new StringParameterValue(name, value, description);
        parameters.add((ParameterValue)parameter);
    }

    private List<ParameterValue> getDefaultParametersValues(AbstractProject project) {
        ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
        if (paramDefProp == null) {
            return defValues;
        }
        for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
            ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
            if (defaultValue == null) continue;
            defValues.add(defaultValue);
        }
        return defValues;
    }

    public void retriggerThisBuild(TriggerContext context) {
        if (context.getThisBuild().getProject().isBuildable() && !ToGerritRunListener.getInstance().isBuilding(context.getThisBuild().getProject(), context.getEvent())) {
            if (!this.silentMode) {
                ToGerritRunListener.getInstance().onRetriggered(context.getThisBuild().getProject(), context.getEvent(), context.getOtherBuilds());
            }
            GerritUserCause cause = new GerritUserCause(context.getEvent(), this.silentMode);
            this.schedule(cause, context.getEvent(), context.getThisBuild().getProject());
        }
    }

    public void retriggerAllBuilds(TriggerContext context) {
        if (!ToGerritRunListener.getInstance().isBuilding(context.getEvent())) {
            this.retrigger(context.getThisBuild().getProject(), context.getEvent());
            for (AbstractBuild build : context.getOtherBuilds()) {
                GerritTrigger trigger = (GerritTrigger)build.getProject().getTrigger(GerritTrigger.class);
                if (trigger == null) continue;
                trigger.retrigger(build.getProject(), context.getEvent());
            }
        }
    }

    private void retrigger(AbstractProject project, PatchsetCreated event) {
        if (project.isBuildable()) {
            if (!this.silentMode) {
                ToGerritRunListener.getInstance().onRetriggered(project, event, null);
            }
            GerritUserCause cause = new GerritUserCause(event, this.silentMode);
            this.schedule(cause, event, project);
        }
    }

    public void gerritEvent(ChangeAbandoned event) {
    }

    public List<GerritProject> getGerritProjects() {
        return this.gerritProjects;
    }

    public void setGerritProjects(List<GerritProject> gerritProjects) {
        this.gerritProjects = gerritProjects;
    }

    public Integer getGerritBuildFailedCodeReviewValue() {
        return this.gerritBuildFailedCodeReviewValue;
    }

    public void setGerritBuildFailedCodeReviewValue(Integer gerritBuildFailedCodeReviewValue) {
        this.gerritBuildFailedCodeReviewValue = gerritBuildFailedCodeReviewValue;
    }

    public Integer getGerritBuildFailedVerifiedValue() {
        return this.gerritBuildFailedVerifiedValue;
    }

    public void setGerritBuildFailedVerifiedValue(Integer gerritBuildFailedVerifiedValue) {
        this.gerritBuildFailedVerifiedValue = gerritBuildFailedVerifiedValue;
    }

    public Integer getGerritBuildStartedCodeReviewValue() {
        return this.gerritBuildStartedCodeReviewValue;
    }

    public void setGerritBuildStartedCodeReviewValue(Integer gerritBuildStartedCodeReviewValue) {
        this.gerritBuildStartedCodeReviewValue = gerritBuildStartedCodeReviewValue;
    }

    public Integer getGerritBuildStartedVerifiedValue() {
        return this.gerritBuildStartedVerifiedValue;
    }

    public void setGerritBuildStartedVerifiedValue(Integer gerritBuildStartedVerifiedValue) {
        this.gerritBuildStartedVerifiedValue = gerritBuildStartedVerifiedValue;
    }

    public Integer getGerritBuildSuccessfulCodeReviewValue() {
        return this.gerritBuildSuccessfulCodeReviewValue;
    }

    public void setGerritBuildSuccessfulCodeReviewValue(Integer gerritBuildSuccessfulCodeReviewValue) {
        this.gerritBuildSuccessfulCodeReviewValue = gerritBuildSuccessfulCodeReviewValue;
    }

    public Integer getGerritBuildSuccessfulVerifiedValue() {
        return this.gerritBuildSuccessfulVerifiedValue;
    }

    public void setGerritBuildSuccessfulVerifiedValue(Integer gerritBuildSuccessfulVerifiedValue) {
        this.gerritBuildSuccessfulVerifiedValue = gerritBuildSuccessfulVerifiedValue;
    }

    public Integer getGerritBuildUnstableCodeReviewValue() {
        return this.gerritBuildUnstableCodeReviewValue;
    }

    public void setGerritBuildUnstableCodeReviewValue(Integer gerritBuildUnstableCodeReviewValue) {
        this.gerritBuildUnstableCodeReviewValue = gerritBuildUnstableCodeReviewValue;
    }

    public Integer getGerritBuildUnstableVerifiedValue() {
        return this.gerritBuildUnstableVerifiedValue;
    }

    public void setGerritBuildUnstableVerifiedValue(Integer gerritBuildUnstableVerifiedValue) {
        this.gerritBuildUnstableVerifiedValue = gerritBuildUnstableVerifiedValue;
    }

    public boolean isSilentMode() {
        return this.silentMode;
    }

    public void setSilentMode(boolean silentMode) {
        this.silentMode = silentMode;
    }

    private boolean isInteresting(PatchsetCreated event) {
        logger.trace("entering isInteresting projects configured: {} the event: {}", (Object)this.gerritProjects.size(), (Object)event);
        for (GerritProject p : this.gerritProjects) {
            if (!p.isInteresting(event.getChange().getProject(), event.getChange().getBranch())) continue;
            logger.trace("According to {} the event is interesting.", (Object)p);
            return true;
        }
        logger.trace("Nothing interesting here, move along folks!");
        return false;
    }

    @Extension
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        public DescriptorImpl() {
            super(GerritTrigger.class);
        }

        public boolean isApplicable(Item item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.TriggerDisplayName();
        }

        public String getHelpFile() {
            return "/plugin/gerrit-trigger/help-whatIsGerritTrigger.html";
        }

        public CompareType[] getCompareTypes() {
            return CompareType.values();
        }
    }
}

