/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.PatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import hudson.model.Cause;

public class GerritCause
extends Cause {
    private PatchsetCreated event;
    private boolean silentMode;
    private TriggerContext context;

    public GerritCause(PatchsetCreated event, boolean silentMode) {
        this.event = event;
        this.silentMode = silentMode;
        this.context = new TriggerContext(event);
    }

    public GerritCause(PatchsetCreated event, boolean silentMode, TriggerContext context) {
        this.event = event;
        this.silentMode = silentMode;
        this.context = context;
    }

    public GerritCause() {
    }

    public PatchsetCreated getEvent() {
        return this.event;
    }

    public void setEvent(PatchsetCreated event) {
        this.event = event;
    }

    public boolean isSilentMode() {
        return this.silentMode;
    }

    public void setSilentMode(boolean silentMode) {
        this.silentMode = silentMode;
    }

    public TriggerContext getContext() {
        return this.context;
    }

    public void setContext(TriggerContext context) {
        this.context = context;
    }

    public String getShortDescription() {
        if (this.isSilentMode()) {
            return Messages.TriggeredShortDescriptionInSilentMode(this.getUrl());
        }
        return Messages.TriggeredShortDescription(this.getUrl());
    }

    public String getUrl() {
        return PluginImpl.getInstance().getConfig().getGerritFrontEndUrlFor(this.event.getChange().getNumber(), this.event.getPatchSet().getNumber());
    }

    public String toString() {
        return "GerritCause: " + this.event + " silent: " + this.silentMode;
    }
}

