/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.gerritevents.ConnectionListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GerritAdministrativeMonitor
extends AdministrativeMonitor
implements ConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(GerritAdministrativeMonitor.class);
    private boolean connected = true;

    public GerritAdministrativeMonitor() {
        if (PluginImpl.getInstance() != null) {
            PluginImpl.getInstance().addListener(this);
        } else {
            Runnable runner = new Runnable(){
                private static final int SLEEP_INTERVAL = 500;

                public void run() {
                    while (PluginImpl.getInstance() == null) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ex) {
                            logger.debug("Got interrupted while sleeping...", (Throwable)ex);
                        }
                    }
                    PluginImpl plugin = PluginImpl.getInstance();
                    if (plugin != null) {
                        plugin.addListener(GerritAdministrativeMonitor.this);
                    } else {
                        logger.error("Unable to register GerritAdministrativeMonitor");
                    }
                }
            };
            Thread thread = new Thread(runner);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public boolean isActivated() {
        return !this.connected;
    }

    public void connectionEstablished() {
        this.connected = true;
    }

    public void connectionDown() {
        this.connected = false;
    }
}

