/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import hudson.Extension;
import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import hudson.triggers.Trigger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ChangeIdAnnotator
extends ChangeLogAnnotator {
    private static final Pattern CHANGE_ID = Pattern.compile("(?<=\\bChange-Id: )I[0-9a-fA-F]{40}\\b");

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        IGerritHudsonTriggerConfig config = PluginImpl.getInstance().getConfig();
        this.annotate(build.getProject(), text, config);
    }

    public void annotate(AbstractProject<?, ?> project, MarkupText text, IGerritHudsonTriggerConfig config) {
        for (MarkupText.SubText token : text.findTokens(CHANGE_ID)) {
            if (!this.hasGerritTrigger(project)) {
                return;
            }
            token.href(config.getGerritFrontEndUrl() + "r/" + token.getText());
        }
    }

    private boolean hasGerritTrigger(AbstractProject<?, ?> project) {
        for (Trigger t : project.getTriggers().values()) {
            if (!(t instanceof GerritTrigger)) continue;
            return true;
        }
        return false;
    }
}

