/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jms.SolQueueBrowserIF;
import com.solacesystems.jms.encoding.JMSDecoder;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolQueueBrowserEnumeration
implements Enumeration<Message> {
    private static final Log log = LogFactory.getLog(SolQueueBrowserEnumeration.class);
    public static int HasMoreElementsSleepTime = 10;
    private SolQueueBrowserIF mQueueBrowser;

    public SolQueueBrowserEnumeration(SolQueueBrowserIF queueBrowser) {
        this.mQueueBrowser = queueBrowser;
    }

    @Override
    public boolean hasMoreElements() {
        try {
            int timeout = this.mQueueBrowser.getTimeout();
            if (timeout < 0) {
                return this.mQueueBrowser.getJCSMPBrowser().hasMore();
            }
            if (timeout == 0) {
                while (!this.mQueueBrowser.getJCSMPBrowser().hasMore()) {
                    Thread.sleep(HasMoreElementsSleepTime);
                }
                return true;
            }
            boolean hasMore = false;
            long endTime = System.currentTimeMillis() + (long)timeout;
            while (!(hasMore = this.mQueueBrowser.getJCSMPBrowser().hasMore()) && System.currentTimeMillis() < endTime) {
                Thread.sleep(HasMoreElementsSleepTime);
            }
            return hasMore;
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"error during \"Enumeration.hasMoreElements()\"", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public Message nextElement() {
        try {
            BytesXMLMessage xmlMessage = this.mQueueBrowser.getJCSMPBrowser().getNext();
            if (xmlMessage != null) {
                return JMSDecoder.createJMSMessage(xmlMessage);
            }
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"error during \"Enumeration.nextElement()\"", (Throwable)e);
            }
            throw new NoSuchElementException(e.getMessage());
        }
        throw new NoSuchElementException();
    }
}

