/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.property;

import com.solacesystems.common.property.Property;
import com.solacesystems.common.property.PropertyConversionException;
import com.solacesystems.common.property.PropertySource;
import com.solacesystems.common.property.PropertyVetoException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSConnectionFactoryPropertyBean {
    private TreeMap<String, Property<?>> mPropertyMap = new TreeMap();

    public JMSConnectionFactoryPropertyBean(Collection<Property<?>> properties) {
        for (Property<?> property : properties) {
            if (property.getSource("Connection Factory") == null) continue;
            this.mPropertyMap.put(property.getId(), property);
        }
    }

    public Map<String, Property<?>> getPropertyMap() {
        return this.mPropertyMap;
    }

    private Property<?> getProperty(String propertyName) {
        Property<?> property = this.mPropertyMap.get(propertyName);
        if (property == null) {
            throw new IllegalArgumentException("Property \"" + propertyName + "\" Not Found");
        }
        return property;
    }

    private PropertySource<?> getPropertySource(String propertyName) {
        Property<?> property = this.getProperty(propertyName);
        PropertySource<?> source = property.getSource("Connection Factory");
        if (source == null) {
            throw new IllegalArgumentException("Property \"" + propertyName + "\" Source \"Connection Factory\" Not Found");
        }
        return source;
    }

    public Object getValue(String propertyName) {
        return this.getPropertySource(propertyName).getValue();
    }

    public void setValue(String propertyName, Object propertyValue) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource(propertyName).setObjectValue(propertyValue);
    }

    public String getAuthenticationScheme() {
        return (String)this.getPropertySource("AuthenticationScheme").getValue();
    }

    public void setAuthenticationScheme(String AuthenticationScheme) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("AuthenticationScheme").setObjectValue(AuthenticationScheme);
    }

    public boolean isSetAuthenticationScheme() {
        return this.getPropertySource("AuthenticationScheme").isSet();
    }

    public Integer getBrowserTimeoutInMS() {
        return (Integer)this.getPropertySource("BrowserTimeoutInMS").getValue();
    }

    public void setBrowserTimeoutInMS(Integer BrowserTimeoutInMS) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("BrowserTimeoutInMS").setObjectValue(BrowserTimeoutInMS);
    }

    public boolean isSetBrowserTimeoutInMS() {
        return this.getPropertySource("BrowserTimeoutInMS").isSet();
    }

    public Boolean getCallbackOnIOThread() {
        return (Boolean)this.getPropertySource("CallbackOnIOThread").getValue();
    }

    public void setCallbackOnIOThread(Boolean CallbackOnIOThread) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("CallbackOnIOThread").setObjectValue(CallbackOnIOThread);
    }

    public boolean isSetCallbackOnIOThread() {
        return this.getPropertySource("CallbackOnIOThread").isSet();
    }

    public String getClientDescription() {
        return (String)this.getPropertySource("ClientDescription").getValue();
    }

    public void setClientDescription(String ClientDescription) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ClientDescription").setObjectValue(ClientDescription);
    }

    public boolean isSetClientDescription() {
        return this.getPropertySource("ClientDescription").isSet();
    }

    public String getClientID() {
        return (String)this.getPropertySource("ClientID").getValue();
    }

    public void setClientID(String ClientID) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ClientID").setObjectValue(ClientID);
    }

    public boolean isSetClientID() {
        return this.getPropertySource("ClientID").isSet();
    }

    public Integer getCompressionLevel() {
        return (Integer)this.getPropertySource("CompressionLevel").getValue();
    }

    public void setCompressionLevel(Integer CompressionLevel) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("CompressionLevel").setObjectValue(CompressionLevel);
    }

    public boolean isSetCompressionLevel() {
        return this.getPropertySource("CompressionLevel").isSet();
    }

    public Integer getConnectRetries() {
        return (Integer)this.getPropertySource("ConnectRetries").getValue();
    }

    public void setConnectRetries(Integer ConnectRetries) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ConnectRetries").setObjectValue(ConnectRetries);
    }

    public boolean isSetConnectRetries() {
        return this.getPropertySource("ConnectRetries").isSet();
    }

    public Integer getConnectRetriesPerHost() {
        return (Integer)this.getPropertySource("ConnectRetriesPerHost").getValue();
    }

    public void setConnectRetriesPerHost(Integer ConnectRetriesPerHost) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ConnectRetriesPerHost").setObjectValue(ConnectRetriesPerHost);
    }

    public boolean isSetConnectRetriesPerHost() {
        return this.getPropertySource("ConnectRetriesPerHost").isSet();
    }

    public Integer getConnectTimeoutInMillis() {
        return (Integer)this.getPropertySource("ConnectTimeoutInMillis").getValue();
    }

    public void setConnectTimeoutInMillis(Integer ConnectTimeoutInMillis) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ConnectTimeoutInMillis").setObjectValue(ConnectTimeoutInMillis);
    }

    public boolean isSetConnectTimeoutInMillis() {
        return this.getPropertySource("ConnectTimeoutInMillis").isSet();
    }

    public Boolean getDeliverToOne() {
        return (Boolean)this.getPropertySource("DeliverToOne").getValue();
    }

    public void setDeliverToOne(Boolean DeliverToOne) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("DeliverToOne").setObjectValue(DeliverToOne);
    }

    public boolean isSetDeliverToOne() {
        return this.getPropertySource("DeliverToOne").isSet();
    }

    public Boolean getDeliverToOneOverride() {
        return (Boolean)this.getPropertySource("DeliverToOneOverride").getValue();
    }

    public void setDeliverToOneOverride(Boolean DeliverToOneOverride) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("DeliverToOneOverride").setObjectValue(DeliverToOneOverride);
    }

    public boolean isSetDeliverToOneOverride() {
        return this.getPropertySource("DeliverToOneOverride").isSet();
    }

    public Integer getDeliveryMode() {
        return (Integer)this.getPropertySource("DeliveryMode").getValue();
    }

    public void setDeliveryMode(Integer DeliveryMode2) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("DeliveryMode").setObjectValue(DeliveryMode2);
    }

    public boolean isSetDeliveryMode() {
        return this.getPropertySource("DeliveryMode").isSet();
    }

    public Boolean getDirectOptimized() {
        return (Boolean)this.getPropertySource("DirectOptimized").getValue();
    }

    public void setDirectOptimized(Boolean DirectOptimized) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("DirectOptimized").setObjectValue(DirectOptimized);
    }

    public boolean isSetDirectOptimized() {
        return this.getPropertySource("DirectOptimized").isSet();
    }

    public Boolean getDirectTransport() {
        return (Boolean)this.getPropertySource("DirectTransport").getValue();
    }

    public void setDirectTransport(Boolean DirectTransport) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("DirectTransport").setObjectValue(DirectTransport);
    }

    public boolean isSetDirectTransport() {
        return this.getPropertySource("DirectTransport").isSet();
    }

    public Boolean getJMSXUserIDEnabled() {
        return (Boolean)this.getPropertySource("JMSXUserIDEnabled").getValue();
    }

    public boolean isSetJMSXUserIDEnabled() {
        return this.getPropertySource("JMSXUserIDEnabled").isSet();
    }

    public Boolean getAllowDuplicateClientId() {
        return (Boolean)this.getPropertySource("AllowDuplicateClientId").getValue();
    }

    public boolean isSetAllowDuplicateClientId() {
        return this.getPropertySource("AllowDuplicateClientId").isSet();
    }

    public Boolean getDmqEligible() {
        return (Boolean)this.getPropertySource("DmqEligible").getValue();
    }

    public void setDmqEligible(Boolean DmqEligible) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("DmqEligible").setObjectValue(DmqEligible);
    }

    public boolean isSetDmqEligible() {
        return this.getPropertySource("DmqEligible").isSet();
    }

    public Boolean getDynamicDurables() {
        return (Boolean)this.getPropertySource("DynamicDurables").getValue();
    }

    public void setDynamicDurables(Boolean DynamicDurables) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("DynamicDurables").setObjectValue(DynamicDurables);
    }

    public boolean isSetDynamicDurables() {
        return this.getPropertySource("DynamicDurables").isSet();
    }

    public Boolean getElidingEligible() {
        return (Boolean)this.getPropertySource("ElidingEligible").getValue();
    }

    public void setElidingEligible(Boolean ElidingEligible) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ElidingEligible").setObjectValue(ElidingEligible);
    }

    public boolean isSetElidingEligible() {
        return this.getPropertySource("ElidingEligible").isSet();
    }

    public Boolean getGenerateSenderID() {
        return (Boolean)this.getPropertySource("GenerateSenderID").getValue();
    }

    public void setGenerateSenderID(Boolean GenerateSenderID) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("GenerateSenderID").setObjectValue(GenerateSenderID);
    }

    public boolean isSetGenerateSenderID() {
        return this.getPropertySource("GenerateSenderID").isSet();
    }

    public String getHost() {
        return (String)this.getPropertySource("Host").getValue();
    }

    public void setHost(String Host) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("Host").setObjectValue(Host);
    }

    public boolean isSetHost() {
        return this.getPropertySource("Host").isSet();
    }

    public Boolean getKRBMutualAuthentication() {
        return (Boolean)this.getPropertySource("KRBMutualAuthentication").getValue();
    }

    public void setKRBMutualAuthentication(Boolean KRBMutualAuthentication) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("KRBMutualAuthentication").setObjectValue(KRBMutualAuthentication);
    }

    public boolean isSetKRBMutualAuthentication() {
        return this.getPropertySource("KRBMutualAuthentication").isSet();
    }

    public String getKRBServiceName() {
        return (String)this.getPropertySource("KRBServiceName").getValue();
    }

    public void setKRBServiceName(String KRBServiceName) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("KRBServiceName").setObjectValue(KRBServiceName);
    }

    public boolean isSetKRBServiceName() {
        return this.getPropertySource("KRBServiceName").isSet();
    }

    public Integer getKeepAliveCountMax() {
        return (Integer)this.getPropertySource("KeepAliveCountMax").getValue();
    }

    public void setKeepAliveCountMax(Integer KeepAliveCountMax) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("KeepAliveCountMax").setObjectValue(KeepAliveCountMax);
    }

    public boolean isSetKeepAliveCountMax() {
        return this.getPropertySource("KeepAliveCountMax").isSet();
    }

    public Integer getKeepAliveIntervalInMillis() {
        return (Integer)this.getPropertySource("KeepAliveIntervalInMillis").getValue();
    }

    public void setKeepAliveIntervalInMillis(Integer KeepAliveIntervalInMillis) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("KeepAliveIntervalInMillis").setObjectValue(KeepAliveIntervalInMillis);
    }

    public boolean isSetKeepAliveIntervalInMillis() {
        return this.getPropertySource("KeepAliveIntervalInMillis").isSet();
    }

    public Boolean getKeepAlives() {
        return (Boolean)this.getPropertySource("KeepAlives").getValue();
    }

    public void setKeepAlives(Boolean KeepAlives) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("KeepAlives").setObjectValue(KeepAlives);
    }

    public boolean isSetKeepAlives() {
        return this.getPropertySource("KeepAlives").isSet();
    }

    public Boolean getLargeMessaging() {
        return (Boolean)this.getPropertySource("LargeMessaging").getValue();
    }

    public void setLargeMessaging(Boolean LargeMessaging) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("LargeMessaging").setObjectValue(LargeMessaging);
    }

    public boolean isSetLargeMessaging() {
        return this.getPropertySource("LargeMessaging").isSet();
    }

    public Integer getLargeMessagingConsumeTimeoutInMillis() {
        return (Integer)this.getPropertySource("LargeMessagingConsumeTimeoutInMillis").getValue();
    }

    public void setLargeMessagingConsumeTimeoutInMillis(Integer LargeMessagingConsumeTimeoutInMillis) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("LargeMessagingConsumeTimeoutInMillis").setObjectValue(LargeMessagingConsumeTimeoutInMillis);
    }

    public boolean isSetLargeMessagingConsumeTimeoutInMillis() {
        return this.getPropertySource("LargeMessagingConsumeTimeoutInMillis").isSet();
    }

    public String getLargeMessagingIncompletePolicy() {
        return (String)this.getPropertySource("LargeMessagingIncompletePolicy").getValue();
    }

    public void setLargeMessagingIncompletePolicy(String LargeMessagingIncompletePolicy) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("LargeMessagingIncompletePolicy").setObjectValue(LargeMessagingIncompletePolicy);
    }

    public boolean isSetLargeMessagingIncompletePolicy() {
        return this.getPropertySource("LargeMessagingIncompletePolicy").isSet();
    }

    public Integer getLargeMessagingSegmentSize() {
        return (Integer)this.getPropertySource("LargeMessagingSegmentSize").getValue();
    }

    public void setLargeMessagingSegmentSize(Integer LargeMessagingSegmentSize) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("LargeMessagingSegmentSize").setObjectValue(LargeMessagingSegmentSize);
    }

    public boolean isSetLargeMessagingSegmentSize() {
        return this.getPropertySource("LargeMessagingSegmentSize").isSet();
    }

    public Integer getLargeMessagingMaximumSize() {
        return (Integer)this.getPropertySource("LargeMessagingMaximumSize").getValue();
    }

    public void setLargeMessagingMaximumSize(Integer LargeMessagingMaximumSize) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("LargeMessagingMaximumSize").setObjectValue(LargeMessagingMaximumSize);
    }

    public boolean isSetLargeMessagingMaximumSize() {
        return this.getPropertySource("LargeMessagingMaximumSize").isSet();
    }

    public String getPassword() {
        return (String)this.getPropertySource("Password").getValue();
    }

    public void setPassword(String Password) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("Password").setObjectValue(Password);
    }

    public boolean isSetPassword() {
        return this.getPropertySource("Password").isSet();
    }

    public Integer getPort() {
        return (Integer)this.getPropertySource("Port").getValue();
    }

    public void setPort(Integer Port) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("Port").setObjectValue(Port);
    }

    public boolean isSetPort() {
        return this.getPropertySource("Port").isSet();
    }

    public Integer getReadTimeoutInMillis() {
        return (Integer)this.getPropertySource("ReadTimeoutInMillis").getValue();
    }

    public void setReadTimeoutInMillis(Integer ReadTimeoutInMillis) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ReadTimeoutInMillis").setObjectValue(ReadTimeoutInMillis);
    }

    public boolean isSetReadTimeoutInMillis() {
        return this.getPropertySource("ReadTimeoutInMillis").isSet();
    }

    public Integer getReceiveADAckThreshold() {
        return (Integer)this.getPropertySource("ReceiveADAckThreshold").getValue();
    }

    public void setReceiveADAckThreshold(Integer ReceiveADAckThreshold) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ReceiveADAckThreshold").setObjectValue(ReceiveADAckThreshold);
    }

    public boolean isSetReceiveADAckThreshold() {
        return this.getPropertySource("ReceiveADAckThreshold").isSet();
    }

    public Integer getReceiveADAckTimerInMillis() {
        return (Integer)this.getPropertySource("ReceiveADAckTimerInMillis").getValue();
    }

    public void setReceiveADAckTimerInMillis(Integer ReceiveADAckTimerInMillis) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ReceiveADAckTimerInMillis").setObjectValue(ReceiveADAckTimerInMillis);
    }

    public boolean isSetReceiveADAckTimerInMillis() {
        return this.getPropertySource("ReceiveADAckTimerInMillis").isSet();
    }

    public Integer getReceiveADWindowSize() {
        return (Integer)this.getPropertySource("ReceiveADWindowSize").getValue();
    }

    public void setReceiveADWindowSize(Integer ReceiveADWindowSize) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ReceiveADWindowSize").setObjectValue(ReceiveADWindowSize);
    }

    public boolean isSetReceiveADWindowSize() {
        return this.getPropertySource("ReceiveADWindowSize").isSet();
    }

    public Integer getReceiveBufferSize() {
        return (Integer)this.getPropertySource("ReceiveBufferSize").getValue();
    }

    public void setReceiveBufferSize(Integer ReceiveBufferSize) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ReceiveBufferSize").setObjectValue(ReceiveBufferSize);
    }

    public boolean isSetReceiveBufferSize() {
        return this.getPropertySource("ReceiveBufferSize").isSet();
    }

    public Integer getReceiveReconnectRetries() {
        return (Integer)this.getPropertySource("ReceiveReconnectRetries").getValue();
    }

    public void setReceiveReconnectRetries(Integer ReconnectRetries) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ReceiveReconnectRetries").setObjectValue(ReconnectRetries);
    }

    public boolean isSetReceiveReconnectRetries() {
        return this.getPropertySource("ReceiveReconnectRetries").isSet();
    }

    public Integer getReceiveReconnectRetryWaitInMillis() {
        return (Integer)this.getPropertySource("ReceiveReconnectRetryWaitInMillis").getValue();
    }

    public void setReceiveReconnectRetryWaitInMillis(Integer ReconnectRetryWaitInMillis) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ReceiveReconnectRetryWaitInMillis").setObjectValue(ReconnectRetryWaitInMillis);
    }

    public boolean isSetReceiveReconnectRetryWaitInMillis() {
        return this.getPropertySource("ReceiveReconnectRetryWaitInMillis").isSet();
    }

    public Integer getReconnectRetries() {
        return (Integer)this.getPropertySource("ReconnectRetries").getValue();
    }

    public void setReconnectRetries(Integer ReconnectRetries) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ReconnectRetries").setObjectValue(ReconnectRetries);
    }

    public boolean isSetReconnectRetries() {
        return this.getPropertySource("ReconnectRetries").isSet();
    }

    public Integer getReconnectRetryWaitInMillis() {
        return (Integer)this.getPropertySource("ReconnectRetryWaitInMillis").getValue();
    }

    public void setReconnectRetryWaitInMillis(Integer ReconnectRetryWaitInMillis) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("ReconnectRetryWaitInMillis").setObjectValue(ReconnectRetryWaitInMillis);
    }

    public boolean isSetReconnectRetryWaitInMillis() {
        return this.getPropertySource("ReconnectRetryWaitInMillis").isSet();
    }

    public Boolean getRespectTTL() {
        return (Boolean)this.getPropertySource("RespectTTL").getValue();
    }

    public void setRespectTTL(Boolean RespectTTL) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("RespectTTL").setObjectValue(RespectTTL);
    }

    public boolean isSetRespectTTL() {
        return this.getPropertySource("RespectTTL").isSet();
    }

    public String getSSLCipherSuites() {
        return (String)this.getPropertySource("SSLCipherSuites").getValue();
    }

    public void setSSLCipherSuites(String SSLCipherSuites) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLCipherSuites").setObjectValue(SSLCipherSuites);
    }

    public boolean isSetSSLCipherSuites() {
        return this.getPropertySource("SSLCipherSuites").isSet();
    }

    public String getSSLExcludedProtocols() {
        return (String)this.getPropertySource("SSLExcludedProtocols").getValue();
    }

    public void setSSLExcludedProtocols(String SSLExcludedProtocols) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLExcludedProtocols").setObjectValue(SSLExcludedProtocols);
    }

    public boolean isSetSSLExcludedProtocols() {
        return this.getPropertySource("SSLExcludedProtocols").isSet();
    }

    public String getSSLConnectionDowngradeTo() {
        return (String)this.getPropertySource("SSLConnectionDowngradeTo").getValue();
    }

    public void setSSLConnectionDowngradeTo(String SSLConnectionDowngradeTo) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLConnectionDowngradeTo").setObjectValue(SSLConnectionDowngradeTo);
    }

    public boolean isSetSSLConnectionDowngradeTo() {
        return this.getPropertySource("SSLConnectionDowngradeTo").isSet();
    }

    public String getSSLKeyStore() {
        return (String)this.getPropertySource("SSLKeyStore").getValue();
    }

    public void setSSLKeyStore(String SSLKeyStore) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLKeyStore").setObjectValue(SSLKeyStore);
    }

    public boolean isSetSSLKeyStore() {
        return this.getPropertySource("SSLKeyStore").isSet();
    }

    public String getSSLKeyStoreFormat() {
        return (String)this.getPropertySource("SSLKeyStoreFormat").getValue();
    }

    public void setSSLKeyStoreFormat(String SSLKeyStoreFormat) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLKeyStoreFormat").setObjectValue(SSLKeyStoreFormat);
    }

    public String getSSLKeyStoreNormalizedFormat() {
        return (String)this.getPropertySource("SSLKeyStoreNormalizedFormat").getValue();
    }

    public void setSSLKeyStoreNormalizedFormat(String SSLKeyStoreNormalizedFormat) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLKeyStoreNormalizedFormat").setObjectValue(SSLKeyStoreNormalizedFormat);
    }

    public boolean isSetSSLKeyStoreFormat() {
        return this.getPropertySource("SSLKeyStoreFormat").isSet();
    }

    public boolean isSetSSLKeyStoreNormalizedFormat() {
        return this.getPropertySource("SSLKeyStoreNormalizedFormat").isSet();
    }

    public String getSSLKeyStorePassword() {
        return (String)this.getPropertySource("SSLKeyStorePassword").getValue();
    }

    public void setSSLKeyStorePassword(String SSLKeyStorePassword) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLKeyStorePassword").setObjectValue(SSLKeyStorePassword);
    }

    public boolean isSetSSLKeyStorePassword() {
        return this.getPropertySource("SSLKeyStorePassword").isSet();
    }

    public String getSSLPrivateKeyAlias() {
        return (String)this.getPropertySource("SSLPrivateKeyAlias").getValue();
    }

    public void setSSLPrivateKeyAlias(String SSLPrivateKeyAlias) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLPrivateKeyAlias").setObjectValue(SSLPrivateKeyAlias);
    }

    public boolean isSetSSLPrivateKeyAlias() {
        return this.getPropertySource("SSLPrivateKeyAlias").isSet();
    }

    public String getSSLPrivateKeyPassword() {
        return (String)this.getPropertySource("SSLPrivateKeyPassword").getValue();
    }

    public void setSSLPrivateKeyPassword(String SSLPrivateKeyPassword) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLPrivateKeyPassword").setObjectValue(SSLPrivateKeyPassword);
    }

    public boolean isSetSSLPrivateKeyPassword() {
        return this.getPropertySource("SSLPrivateKeyPassword").isSet();
    }

    public String getSSLProtocol() {
        return (String)this.getPropertySource("SSLProtocol").getValue();
    }

    public void setSSLProtocol(String SSLProtocol) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLProtocol").setObjectValue(SSLProtocol);
    }

    public boolean isSetSSLProtocol() {
        return this.getPropertySource("SSLProtocol").isSet();
    }

    public String getSSLTrustStore() {
        return (String)this.getPropertySource("SSLTrustStore").getValue();
    }

    public void setSSLTrustStore(String SSLTrustStore) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLTrustStore").setObjectValue(SSLTrustStore);
    }

    public boolean isSetSSLTrustStore() {
        return this.getPropertySource("SSLTrustStore").isSet();
    }

    public String getSSLTrustStoreFormat() {
        return (String)this.getPropertySource("SSLTrustStoreFormat").getValue();
    }

    public void setSSLTrustStoreFormat(String SSLTrustStoreFormat) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLTrustStoreFormat").setObjectValue(SSLTrustStoreFormat);
    }

    public boolean isSetSSLTrustStoreFormat() {
        return this.getPropertySource("SSLTrustStoreFormat").isSet();
    }

    public String getSSLTrustStorePassword() {
        return (String)this.getPropertySource("SSLTrustStorePassword").getValue();
    }

    public void setSSLTrustStorePassword(String SSLTrustStorePassword) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLTrustStorePassword").setObjectValue(SSLTrustStorePassword);
    }

    public boolean isSetSSLTrustStorePassword() {
        return this.getPropertySource("SSLTrustStorePassword").isSet();
    }

    public String getSSLTrustedCommonNameList() {
        return (String)this.getPropertySource("SSLTrustedCommonNameList").getValue();
    }

    public void setSSLTrustedCommonNameList(String SSLTrustedCommonNameList) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLTrustedCommonNameList").setObjectValue(SSLTrustedCommonNameList);
    }

    public boolean isSetSSLTrustedCommonNameList() {
        return this.getPropertySource("SSLTrustedCommonNameList").isSet();
    }

    public Boolean getSSLValidateCertificate() {
        return (Boolean)this.getPropertySource("SSLValidateCertificate").getValue();
    }

    public void setSSLValidateCertificate(Boolean SSLValidateCertificate) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLValidateCertificate").setObjectValue(SSLValidateCertificate);
    }

    public boolean isSetSSLValidateCertificate() {
        return this.getPropertySource("SSLValidateCertificate").isSet();
    }

    public Boolean getSSLValidateCertificateDate() {
        return (Boolean)this.getPropertySource("SSLValidateCertificateDate").getValue();
    }

    public void setSSLValidateCertificateDate(Boolean SSLValidateCertificateDate) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SSLValidateCertificateDate").setObjectValue(SSLValidateCertificateDate);
    }

    public boolean isSetSSLValidateCertificateDate() {
        return this.getPropertySource("SSLValidateCertificateDate").isSet();
    }

    public Integer getSendADAckTimerInMillis() {
        return (Integer)this.getPropertySource("SendADAckTimerInMillis").getValue();
    }

    public void setSendADAckTimerInMillis(Integer SendADAckTimerInMillis) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SendADAckTimerInMillis").setObjectValue(SendADAckTimerInMillis);
    }

    public boolean isSetSendADAckTimerInMillis() {
        return this.getPropertySource("SendADAckTimerInMillis").isSet();
    }

    public Integer getSendADMaxResends() {
        return (Integer)this.getPropertySource("SendADMaxResends").getValue();
    }

    public void setSendADMaxResends(Integer SendADMaxResends) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SendADMaxResends").setObjectValue(SendADMaxResends);
    }

    public boolean isSetSendADMaxResends() {
        return this.getPropertySource("SendADMaxResends").isSet();
    }

    public Integer getSendADWindowSize() {
        return (Integer)this.getPropertySource("SendADWindowSize").getValue();
    }

    public void setSendADWindowSize(Integer SendADWindowSize) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SendADWindowSize").setObjectValue(SendADWindowSize);
    }

    public boolean isSetSendADWindowSize() {
        return this.getPropertySource("SendADWindowSize").isSet();
    }

    public Integer getSendBufferSize() {
        return (Integer)this.getPropertySource("SendBufferSize").getValue();
    }

    public void setSendBufferSize(Integer SendBufferSize) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SendBufferSize").setObjectValue(SendBufferSize);
    }

    public boolean isSetSendBufferSize() {
        return this.getPropertySource("SendBufferSize").isSet();
    }

    public Integer getSubscriberLocalPriority() {
        return (Integer)this.getPropertySource("SubscriberLocalPriority").getValue();
    }

    public void setSubscriberLocalPriority(Integer SubscriberLocalPriority) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SubscriberLocalPriority").setObjectValue(SubscriberLocalPriority);
    }

    public boolean isSetSubscriberLocalPriority() {
        return this.getPropertySource("SubscriberLocalPriority").isSet();
    }

    public Integer getSubscriberNetworkPriority() {
        return (Integer)this.getPropertySource("SubscriberNetworkPriority").getValue();
    }

    public void setSubscriberNetworkPriority(Integer SubscriberNetworkPriority) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("SubscriberNetworkPriority").setObjectValue(SubscriberNetworkPriority);
    }

    public boolean isSetSubscriberNetworkPriority() {
        return this.getPropertySource("SubscriberNetworkPriority").isSet();
    }

    public Boolean getTcpNoDelay() {
        return (Boolean)this.getPropertySource("TcpNoDelay").getValue();
    }

    public void setTcpNoDelay(Boolean TcpNoDelay) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("TcpNoDelay").setObjectValue(TcpNoDelay);
    }

    public boolean isSetTcpNoDelay() {
        return this.getPropertySource("TcpNoDelay").isSet();
    }

    public Boolean getUseDefaultContext() {
        return (Boolean)this.getPropertySource("UseDefaultContext").getValue();
    }

    public void setUseDefaultContext(Boolean UseDefaultContext) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("UseDefaultContext").setObjectValue(UseDefaultContext);
    }

    public boolean isSetUseDefaultContext() {
        return this.getPropertySource("UseDefaultContext").isSet();
    }

    public String getUsername() {
        return (String)this.getPropertySource("Username").getValue();
    }

    public void setUsername(String Username) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("Username").setObjectValue(Username);
    }

    public boolean isSetUsername() {
        return this.getPropertySource("Username").isSet();
    }

    public String getVPN() {
        return (String)this.getPropertySource("VPN").getValue();
    }

    public void setVPN(String VPN) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("VPN").setObjectValue(VPN);
    }

    public boolean isSetVPN() {
        return this.getPropertySource("VPN").isSet();
    }

    public Boolean getXA() {
        return (Boolean)this.getPropertySource("XA").getValue();
    }

    public void setXA(Boolean XA) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("XA").setObjectValue(XA);
    }

    public boolean isSetXA() {
        return this.getPropertySource("XA").isSet();
    }

    public Boolean getXmlPayload() {
        return (Boolean)this.getPropertySource("XmlPayload").getValue();
    }

    public void setXmlPayload(Boolean XmlPayload) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("XmlPayload").setObjectValue(XmlPayload);
    }

    public String getUnknownPublisherFlowAction() {
        return (String)this.getPropertySource("UnkownPublisherFlowAction").getValue();
    }

    public void setUnknownPublisherFlowAction(String action) throws PropertyConversionException, PropertyVetoException {
        this.getPropertySource("UnkownPublisherFlowAction").setObjectValue(action);
    }

    public boolean isSetUnknownPublisherFlowAction() {
        return this.getPropertySource("UnkownPublisherFlowAction").isSet();
    }

    public boolean isSetXmlPayload() {
        return this.getPropertySource("XmlPayload").isSet();
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        Iterator<String> it = this.mPropertyMap.keySet().iterator();
        while (it.hasNext()) {
            Property<?> property = this.mPropertyMap.get(it.next());
            bldr.append("property=\"" + property.getId() + "\", ");
            bldr.append(property.getSource("Connection Factory"));
            bldr.append("\n");
        }
        return bldr.toString();
    }
}

