/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.message;

import com.solacesystems.common.util.SolByteBuffer;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jms.message.BytesMessageIF;
import com.solacesystems.jms.message.SolMessage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class SolBytesMessage
extends SolMessage
implements BytesMessageIF,
Serializable {
    private static final long serialVersionUID = 2403029490494583624L;
    private transient DataOutputStream mDataOut = null;
    private transient SolByteBuffer mBytesOut = null;
    private transient DataInputStream mDataIn = null;
    private transient ByteBuffer mByteBufferIn = null;
    private transient int mBodyLength = 0;

    public SolBytesMessage() {
    }

    public SolBytesMessage(BytesXMLMessage message) {
        super(message);
    }

    public byte[] getBackingArray() {
        if (this.mBodyMode == SolMessage.MessageBodyMode.WriteMode) {
            if (this.mBytesOut != null) {
                return this.mBytesOut.getBackingArray();
            }
        } else {
            this.loadPayload();
            if (this.mByteBufferIn != null && this.mByteBufferIn.hasArray()) {
                return this.mByteBufferIn.array();
            }
        }
        return null;
    }

    public int getBackingArrayLength() {
        if (this.mBodyMode == SolMessage.MessageBodyMode.WriteMode) {
            if (this.mBytesOut != null) {
                return this.mBytesOut.getLength();
            }
        } else {
            this.loadPayload();
            if (this.mByteBufferIn != null && this.mByteBufferIn.hasArray()) {
                return this.mByteBufferIn.array().length;
            }
        }
        return 0;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        if (this.mDataOut != null) {
            this.mBytesOut.clear();
        }
        this.mDataIn = null;
        this.mBodyLength = 0;
    }

    public long getBodyLength() throws JMSException {
        if (this.mBodyMode == SolMessage.MessageBodyMode.WriteMode) {
            throw new MessageNotReadableException("This message is in write-only mode");
        }
        this.loadPayload();
        return this.mBodyLength;
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            return this.mDataIn.readBoolean();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            return this.mDataIn.readByte();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.initializeReading();
        try {
            return this.mDataIn.readUnsignedByte();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            return this.mDataIn.readShort();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.initializeReading();
        try {
            return this.mDataIn.readUnsignedShort();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            return this.mDataIn.readChar();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            return this.mDataIn.readInt();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            return this.mDataIn.readLong();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            return this.mDataIn.readFloat();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            return this.mDataIn.readDouble();
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public String readUTF() throws JMSException {
        this.initializeReading();
        return SolBytesMessage.readJMSUTF(this.mDataIn);
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (value == null) {
            throw new NullPointerException("passed value cannot be null");
        }
        if (length < 0 || length > value.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        try {
            this.initializeReading();
        }
        catch (MessageEOFException e) {
            return -1;
        }
        try {
            int n;
            int count;
            for (n = 0; n < length && (count = this.mDataIn.read(value, n, length - n)) >= 0; n += count) {
            }
            if (n == 0 && length > 0) {
                n = -1;
            }
            return n;
        }
        catch (EOFException eof) {
            MessageEOFException jmsEx = new MessageEOFException(eof.getMessage());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Format error occurred" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        try {
            this.mDataOut.writeBoolean(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        try {
            this.mDataOut.writeByte(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        try {
            this.mDataOut.writeShort(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        try {
            this.mDataOut.writeChar(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        try {
            this.mDataOut.writeInt(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        try {
            this.mDataOut.writeLong(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        try {
            this.mDataOut.writeFloat(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        try {
            this.mDataOut.writeDouble(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.initializeWriting();
        SolBytesMessage.writeJMSUTF(this.mDataOut, value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.initializeWriting();
        try {
            this.mDataOut.write(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        try {
            this.mDataOut.write(value, offset, length);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.getMessage());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        this.initializeWriting();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Cannot write non-primitive type:" + value.getClass());
        }
    }

    public void reset() throws JMSException {
        if (this.mBodyMode == SolMessage.MessageBodyMode.WriteMode) {
            if (this.mDataOut != null) {
                try {
                    this.mDataOut.flush();
                    this.mByteBufferIn = ByteBuffer.wrap(this.mBytesOut.getBackingArray(), 0, this.mBytesOut.getLength());
                    this.mDataIn = new DataInputStream(new ByteArrayInputStream(this.mByteBufferIn.array()));
                    this.mBodyLength = this.mBytesOut.getLength();
                    this.mDataOut.close();
                }
                catch (IOException ioe) {
                    JMSException jmsEx = new JMSException("reset failed: " + ioe.getMessage());
                    jmsEx.setLinkedException((Exception)ioe);
                    throw jmsEx;
                }
            }
        } else if (this.mBodyMode == SolMessage.MessageBodyMode.ReadLoadedMode) {
            if (this.mDataIn != null && this.mByteBufferIn != null && this.mByteBufferIn.hasArray()) {
                this.mDataIn = new DataInputStream(new ByteArrayInputStream(this.mByteBufferIn.array()));
                this.mBodyLength = this.mByteBufferIn.array().length;
            }
        } else if (this.mBodyMode == SolMessage.MessageBodyMode.ReadUnloadedMode) {
            return;
        }
        this.mBodyMode = SolMessage.MessageBodyMode.ReadLoadedMode;
        this.mBytesOut = null;
        this.mDataOut = null;
    }

    private void initializeWriting() throws MessageNotWriteableException {
        if (this.mBodyMode != SolMessage.MessageBodyMode.WriteMode) {
            throw new MessageNotWriteableException("This message is in read-only mode");
        }
        if (this.mDataOut == null) {
            this.mBytesOut = new SolByteBuffer(100);
            this.mDataOut = new DataOutputStream(this.mBytesOut);
        }
    }

    private void initializeReading() throws JMSException {
        if (this.mBodyMode == SolMessage.MessageBodyMode.WriteMode) {
            throw new MessageNotReadableException("This message is in write-only mode");
        }
        this.loadPayload();
        if (this.mDataIn == null) {
            throw new MessageEOFException("reached end of data");
        }
    }

    private void loadPayload() {
        if (this.mBodyMode == SolMessage.MessageBodyMode.ReadUnloadedMode) {
            this.mByteBufferIn = this.mMessage.getAttachmentByteBuffer();
            if (this.mByteBufferIn != null && this.mByteBufferIn.hasArray()) {
                this.mDataIn = new DataInputStream(new ByteArrayInputStream(this.mByteBufferIn.array()));
                this.mBodyLength = this.mByteBufferIn.array().length;
            } else {
                this.mByteBufferIn = null;
                this.mDataIn = null;
                this.mBodyLength = 0;
            }
            this.mBodyMode = SolMessage.MessageBodyMode.ReadLoadedMode;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.loadPayload();
        out.defaultWriteObject();
        byte[] backingArray = this.getBackingArray();
        if (backingArray != null) {
            out.write(backingArray, 0, this.getBackingArrayLength());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mDataIn = null;
        this.mByteBufferIn = null;
        this.mBodyLength = 0;
        if (in.available() == 0) {
            this.mDataOut = null;
            this.mBytesOut = null;
        } else {
            byte[] data = this.toByteArray(in);
            this.mBytesOut = new SolByteBuffer(100);
            this.mDataOut = new DataOutputStream(this.mBytesOut);
            this.mDataOut.write(data);
        }
    }
}

