/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.common.HostInfo;
import com.solacesystems.jcsmp.Context;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPChannelProperties;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPGlobalProperties;
import com.solacesystems.jcsmp.JCSMPIncompleteLargeMessageReceivedException;
import com.solacesystems.jcsmp.JCSMPProperties;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.SessionEvent;
import com.solacesystems.jcsmp.SessionEventArgs;
import com.solacesystems.jcsmp.SessionEventHandler;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jms.ConfigurationException;
import com.solacesystems.jms.IncompleteLargeMessageException;
import com.solacesystems.jms.SolConnectionConsumer;
import com.solacesystems.jms.SolConnectionConsumerIF;
import com.solacesystems.jms.SolConnectionConsumerRA;
import com.solacesystems.jms.SolConnectionEventListener;
import com.solacesystems.jms.SolConnectionEventSource;
import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolDestinationInfo;
import com.solacesystems.jms.SolSession;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.SolTemporaryQueueIF;
import com.solacesystems.jms.SolTemporaryTopicIF;
import com.solacesystems.jms.events.SolConnectionEvent;
import com.solacesystems.jms.events.SolReconnectedEvent;
import com.solacesystems.jms.events.SolReconnectingEvent;
import com.solacesystems.jms.impl.ConnectionProperties;
import com.solacesystems.jms.impl.JMSClientInfoProvider;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.SessionTransactionType;
import com.solacesystems.jms.impl.SolCollections;
import com.solacesystems.jms.impl.SolConnectionMetaData;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import com.solacesystems.jms.property.JMSAPIPropertyBean;
import com.solacesystems.jms.property.JMSProperties;
import com.solacesystems.jms.property.JMSPropertyBean;
import java.util.ArrayList;
import java.util.List;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolConnection
implements SolConnectionIF,
SolConnectionEventSource,
ExceptionListener,
SessionEventHandler {
    private static final Log log = LogFactory.getLog(SolConnection.class);
    protected JMSProperties mProperties;
    protected JMSPropertyBean mBean;
    protected JMSAPIPropertyBean mAPIBean;
    protected JCSMPProperties mJCSMPProperties;
    protected ConnectionProperties mConnectionProps;
    protected JMSState mState;
    protected ArrayList<SolSessionIF> mSessions;
    protected ArrayList<SolConnectionConsumerIF> mConnectionConsumers;
    protected ExceptionListener mListener;
    protected ConnectionMetaData mConnectionMetaData;
    protected XMLMessageConsumer mDefaultConsumer;
    protected Object mDefaultConsumerLock;
    protected String mClientID;
    protected SolConnectionEventListener mConnectionEventListener;
    protected boolean mCFClientIDSet;
    protected boolean mProviderGeneratedClientID;
    protected boolean mHasBeenAccessed;

    SolConnection(JMSProperties properties, boolean connectionTypeXA) throws JMSException {
        this(properties, connectionTypeXA, null, null);
    }

    SolConnection(JMSProperties properties, boolean connectionTypeXA, String username, String password) throws JMSException {
        block20: {
            block19: {
                this.mProperties = (JMSProperties)properties.clone();
                this.mBean = new JMSPropertyBean(this.mProperties.getProperties().values());
                this.mAPIBean = new JMSAPIPropertyBean(this.mProperties.getProperties().values());
                if (username != null) {
                    try {
                        this.mAPIBean.setUsername(username);
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block19;
                        log.error((Object)("Error setting username \"" + username + "\""));
                    }
                }
            }
            if (password != null) {
                try {
                    this.mAPIBean.setPassword(password);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block20;
                    log.error((Object)"Error setting password");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating connection.  Properties used for connection creation:\n\n" + this.mProperties));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Creating connection");
        }
        this.mState = JMSState.Stopped;
        this.mSessions = new ArrayList();
        this.mConnectionConsumers = new ArrayList();
        this.mListener = null;
        this.mConnectionMetaData = new SolConnectionMetaData();
        this.mDefaultConsumer = null;
        this.mDefaultConsumerLock = new Object();
        this.mClientID = this.mBean.getClientID();
        this.mCFClientIDSet = this.mClientID != null && this.mClientID.length() > 0;
        this.mProviderGeneratedClientID = this.mBean.getProviderGeneratedClientID();
        this.mHasBeenAccessed = false;
        Context context = null;
        com.solacesystems.jcsmp.Session session = null;
        try {
            this.mJCSMPProperties = SolConnection.toJCSMPProperties(this.mBean, connectionTypeXA);
            boolean allowDupClientId = this.mBean.getAllowDuplicateClientId();
            if (this.mBean.getUseDefaultContext().booleanValue()) {
                session = JCSMPFactory.onlyInstance().createSession(this.mJCSMPProperties, null, this, allowDupClientId);
            } else {
                context = JCSMPFactory.onlyInstance().createContext(null);
                session = JCSMPFactory.onlyInstance().createSession(this.mJCSMPProperties, context, this, allowDupClientId);
            }
            session.connect();
            this.mConnectionProps = new ConnectionProperties(this.mProperties, context, (JCSMPSession)session, this);
            if (this.mConnectionProps.getRouterCapabilities().crMode() && this.mBean.getDirectTransport().booleanValue()) {
                throw new ConfigurationException("Content routing with the JNDI direct transport property set to true is not supported");
            }
        }
        catch (InvalidPropertiesException e) {
            if (context != null) {
                context.destroy();
            }
            throw new ConfigurationException(e.getMessage());
        }
        catch (JCSMPException e) {
            if (session != null) {
                session.closeSession();
            }
            if (context != null) {
                context.destroy();
            }
            throw Validator.createJMSException("soljms.operation.connection.create", (Throwable)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Connection created.");
        }
    }

    public JCSMPProperties getJCSMPProperties() {
        return this.mJCSMPProperties;
    }

    public JMSProperties getJMSProperties() {
        return this.mProperties;
    }

    public synchronized void close() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing connection");
        }
        if (this.mState != JMSState.Closed) {
            this.mHasBeenAccessed = true;
            ArrayList<SolConnectionConsumerIF> ccToClose = new ArrayList<SolConnectionConsumerIF>(this.mConnectionConsumers);
            SolCollections.stopAll(ccToClose);
            SolCollections.closeAll(new ArrayList<SolSessionIF>(this.mSessions));
            this.mSessions.clear();
            SolCollections.closeAll(ccToClose);
            this.mConnectionConsumers.clear();
            if (!this.mConnectionProps.getJCSMPSession().isClosed()) {
                this.mConnectionProps.getJCSMPSession().closeSession();
            }
            if (this.mConnectionProps.getContext() != null) {
                this.mConnectionProps.getContext().destroy();
            }
            this.mState = JMSState.Closed;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection closed");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Connection already closed");
        }
    }

    public synchronized ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createConnectionConsumer()");
        }
        this.checkClosed();
        Validator.checkConsumerDestination(destination, this);
        SolDestinationInfo destInfo = new SolDestinationInfo();
        destInfo.destination = destination;
        destInfo.subscriptionName = null;
        SolConnectionConsumerIF connCons = null;
        Boolean useLegacy = this.mBean.getUseLegacyConnectionConsumer();
        connCons = useLegacy != null && useLegacy != false ? new SolConnectionConsumer(this, destInfo, messageSelector, sessionPool, maxMessages, this.mState) : new SolConnectionConsumerRA(this, destInfo, messageSelector, sessionPool, maxMessages, this.mState);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createConnectionConsumer()");
        }
        return connCons;
    }

    public synchronized ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createDurableConnectionConsumer()");
        }
        this.checkClosed();
        Validator.checkConsumerTopicDestination((Destination)topic, this, true);
        Validator.checkSubscriptionName(subscriptionName);
        SolDestinationInfo destInfo = new SolDestinationInfo();
        destInfo.destination = topic;
        destInfo.subscriptionName = subscriptionName;
        SolConnectionConsumerIF connCons = null;
        Boolean useLegacy = this.mBean.getUseLegacyConnectionConsumer();
        connCons = useLegacy != null && useLegacy != false ? new SolConnectionConsumer(this, destInfo, messageSelector, sessionPool, maxMessages, this.mState) : new SolConnectionConsumerRA(this, destInfo, messageSelector, sessionPool, maxMessages, this.mState);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createDurableConnectionConsumer()");
        }
        return connCons;
    }

    public synchronized Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering createSession()");
        }
        this.checkClosed();
        Validator.checkTransactedAndAckMode(transacted ? SessionTransactionType.LocalTransaction : SessionTransactionType.NoTransaction, acknowledgeMode, this.mConnectionProps.getPropertyBean().getDirectTransport());
        this.mHasBeenAccessed = true;
        SolSession newSession = new SolSession(this, transacted, acknowledgeMode, this.mState);
        this.mSessions.add(newSession);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createSession()");
        }
        return newSession;
    }

    public synchronized String getClientID() throws JMSException {
        this.checkClosed();
        if (this.mProviderGeneratedClientID) {
            return (String)this.mConnectionProps.getJCSMPSession().getProperty("client_name");
        }
        return this.mClientID;
    }

    public synchronized String getClientName() throws JMSException {
        this.checkClosed();
        return (String)this.mConnectionProps.getJCSMPSession().getProperty("client_name");
    }

    public synchronized ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.mListener;
    }

    public synchronized ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return this.mConnectionMetaData;
    }

    public synchronized void setClientID(String clientID) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering setClientID(), clientId: " + clientID));
        }
        this.checkClosed();
        Validator.checkClientId(this.mBean.getJNDIClientID(), clientID);
        if (this.mCFClientIDSet) {
            throw new javax.jms.IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.clientid.set", "soljms.error.clientid.adminstrativelyConfigured", null), "soljms.error.clientid.adminstrativelyConfigured");
        }
        if (this.mHasBeenAccessed) {
            throw new javax.jms.IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.clientid.set", "soljms.error.clientid.notsettable", null), "soljms.error.clientid.notsettable");
        }
        try {
            String generatedClientId = clientID;
            if (clientID != null && !"".equals(clientID) && this.mBean.getAllowDuplicateClientId().booleanValue()) {
                this.mConnectionProps.getJCSMPSession().setJmsClientId(clientID, this.mBean.getAllowDuplicateClientId());
                this.mProviderGeneratedClientID = false;
                generatedClientId = (String)this.mConnectionProps.getJCSMPSession().getProperty("client_name");
            }
            this.mConnectionProps.getJCSMPSession().setProperty("client_name", generatedClientId);
            this.mJCSMPProperties.setProperty("client_name", clientID);
            this.mAPIBean.setClientID(clientID);
            this.mClientID = clientID;
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.clientid.set", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving setClientID()");
        }
    }

    public synchronized void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.mListener = listener;
    }

    public synchronized void start() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering start()");
        }
        this.checkClosed();
        if (this.mState == JMSState.Stopped) {
            this.mHasBeenAccessed = true;
            SolCollections.startAll(this.mSessions);
            SolCollections.startAll(this.mConnectionConsumers);
            this.mState = JMSState.Started;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Leaving start() : Connection started.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving start() : Connection already started");
        }
    }

    public synchronized void stop() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering stop()");
        }
        this.checkClosed();
        if (this.mState == JMSState.Started) {
            this.mHasBeenAccessed = true;
            SolCollections.stopAll(this.mSessions);
            SolCollections.stopAll(this.mConnectionConsumers);
            this.mState = JMSState.Stopped;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Leaving stop() : Connection stopped.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving stop() : Connection already stopped");
        }
    }

    public synchronized void remove(SolSessionIF session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering remove(), session being removed: " + session));
        }
        for (int index = this.mSessions.size() - 1; index >= 0; --index) {
            if (this.mSessions.get(index) != session) continue;
            this.mSessions.remove(index);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Leaving remove() : session removed.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving remove(), session to be removed not found.");
        }
    }

    public synchronized void removeConnectionConsumer(SolConnectionConsumerIF cons) {
        this.mConnectionConsumers.remove(cons);
    }

    public synchronized void addConnectionConsumer(SolConnectionConsumerIF cons) {
        this.mConnectionConsumers.add(cons);
    }

    public synchronized void deleteTemporaryQueue(SolTemporaryQueueIF queue) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering deleteTemporaryQueue.  Queue: " + queue.getQueueName()));
        }
        Validator.checkDeleteTempDestination((Destination)queue, this);
        if (this.mState != JMSState.Closed) {
            for (int i = 0; i < this.mSessions.size(); ++i) {
                if (!this.mSessions.get(i).isTemporaryQueueUsed(queue)) continue;
                throw new javax.jms.IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.temp.destination.delete", "soljms.error.tempdestination.inuse", null), "soljms.error.tempdestination.inuse");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving deleteTemporaryQueue");
        }
    }

    public synchronized void deleteTemporaryTopic(SolTemporaryTopicIF topic) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering deleteTemporaryTopic.  Topic : " + topic.getTopicName()));
        }
        Validator.checkDeleteTempDestination((Destination)topic, this);
        if (this.mState != JMSState.Closed) {
            for (int i = 0; i < this.mSessions.size(); ++i) {
                if (!this.mSessions.get(i).isTemporaryTopicUsed(topic)) continue;
                throw new javax.jms.IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.temp.destination.delete", "soljms.error.tempdestination.inuse", null), "soljms.error.tempdestination.inuse");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving deleteTemporaryTopic");
        }
    }

    public ConnectionProperties getProperties() {
        return this.mConnectionProps;
    }

    public void handleEvent(SessionEventArgs event) {
        JMSException jmsEx;
        Exception jcsmpEx;
        if (event.getEvent() == SessionEvent.INCOMPLETE_LARGE_MESSAGE_RECVD) {
            JCSMPIncompleteLargeMessageReceivedException jEx = (JCSMPIncompleteLargeMessageReceivedException)((Object)event.getException());
            IncompleteLargeMessageException ex = new IncompleteLargeMessageException(event.getInfo());
            ex.setSignalMsgDump(jEx.getSignalMsgDump());
            ex.setSignalMsgPhysicalQueueName(jEx.getSignalMsgQueueName());
            ex.setSignalMsgSelector(jEx.getSignalMsgSelector());
            ex.setSegmentMsgPhsicalQueueName(jEx.getSegmentMsgQueueName());
            ex.setSegmentMsgSelector(jEx.getSegmentMsgSelector());
            this.onException(ex);
        }
        if ((jcsmpEx = event.getException()) != null && jcsmpEx instanceof JCSMPErrorResponseException && ((JCSMPErrorResponseException)((Object)jcsmpEx)).getSubcodeEx() == 64) {
            jmsEx = new JMSException(jcsmpEx.getMessage(), "soljms.error.unknowntransactedsessionname");
            this.onException(jmsEx);
        }
        if (event.getEvent().equals((Object)SessionEvent.DOWN_ERROR)) {
            jmsEx = new JMSException(jcsmpEx.getMessage());
            this.onException(jmsEx);
        }
        if (this.mConnectionEventListener != null) {
            SolConnectionEvent solEvent = null;
            if (event.getEvent().equals((Object)SessionEvent.RECONNECTING)) {
                JMSException exception = Validator.createJMSException(null, event.getException());
                solEvent = new SolReconnectingEvent(exception);
            } else if (event.getEvent().equals((Object)SessionEvent.RECONNECTED)) {
                solEvent = new SolReconnectedEvent();
            }
            if (solEvent != null) {
                try {
                    this.mConnectionEventListener.onEvent(solEvent);
                }
                catch (Throwable t) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Exception occurred in connection event listener", t);
                    }
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"Event is not a connection event - cannot notify SolConnectionEventListener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultSubscriber() throws JCSMPException {
        Object object = this.mDefaultConsumerLock;
        synchronized (object) {
            if (this.mDefaultConsumer == null) {
                this.mDefaultConsumer = this.mConnectionProps.getJCSMPSession().getMessageConsumer((XMLMessageListener)null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException exception) {
        block7: {
            ExceptionListener listener;
            if (log.isDebugEnabled()) {
                log.debug((Object)("onException called.  Exception: " + exception.toString()));
            }
            SolConnection solConnection = this;
            synchronized (solConnection) {
                listener = this.mListener;
            }
            if (listener != null) {
                try {
                    listener.onException(exception);
                }
                catch (Throwable t) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)"Error handling async exception", t);
                }
            }
        }
    }

    protected void checkClosed() throws JMSException {
        if (this.mState == JMSState.Closed || this.mConnectionProps.getJCSMPSession().isClosed()) {
            if (this.mState != JMSState.Closed) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Connection closed because JCSMP session is closed.");
                }
                this.mState = JMSState.Closed;
            }
            throw new javax.jms.IllegalStateException("connection closed", "soljms.error.closed");
        }
    }

    public static JCSMPProperties toJCSMPProperties(JMSPropertyBean bean, boolean connectionTypeXA) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entering toJCSMPProperties");
        }
        JCSMPProperties jcsmpProps = new JCSMPProperties();
        JCSMPChannelProperties ccProps = (JCSMPChannelProperties)jcsmpProps.getProperty("client_channel");
        if (!bean.isSetHost()) {
            throw new IllegalArgumentException("Host not specified");
        }
        if (!(bean.getAuthenticationScheme().equals("AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE") || bean.getAuthenticationScheme().equals("AUTHENTICATION_SCHEME_GSS_KRB") || bean.isSetUsername())) {
            throw new IllegalArgumentException("Username not specified");
        }
        String hostlist = bean.getHost();
        int port = bean.getPort();
        if (port != -1) {
            hostlist = SolConnection.buildHostlist(bean, port);
        }
        jcsmpProps.setProperty("host", hostlist);
        if (bean.getUsername() != null) {
            jcsmpProps.setProperty("username", bean.getUsername());
        }
        if (bean.isSetPassword()) {
            jcsmpProps.setProperty("password", bean.getPassword());
        }
        if (bean.isSetVPN()) {
            jcsmpProps.setProperty("vpn_name", bean.getVPN());
        }
        if (bean.isSetAuthenticationScheme()) {
            jcsmpProps.setProperty("AUTHENTICATION_SCHEME", bean.getAuthenticationScheme());
        }
        if (bean.isSetKRBMutualAuthentication()) {
            jcsmpProps.setBooleanProperty("KRB_MUTUAL_AUTHENTICATION", bean.getKRBMutualAuthentication());
        }
        if (bean.isSetKRBServiceName()) {
            jcsmpProps.setProperty("KRB_SERVICE_NAME", bean.getKRBServiceName());
        }
        if (connectionTypeXA) {
            jcsmpProps.setProperty("connection_type", "CONNECTION_TYPE_XA");
        } else {
            jcsmpProps.setProperty("connection_type", "CONNECTION_TYPE_BASIC");
        }
        jcsmpProps.setProperty("client_info_provider", new JMSClientInfoProvider());
        if (bean.isSetClientID() && bean.getClientID().length() > 0) {
            jcsmpProps.setProperty("client_name", bean.getClientID());
        }
        jcsmpProps.setProperty("application_description", bean.getClientDescription());
        jcsmpProps.setProperty("message_ack_mode", "client_ack");
        jcsmpProps.setBooleanProperty("topic_dispatch", bean.getDirectTransport());
        jcsmpProps.setProperty("MESSAGE_CALLBACK_ON_REACTOR", bean.getCallbackOnIOThread());
        jcsmpProps.setProperty("topic_dispatch_optimize_direct", bean.getDirectOptimized());
        jcsmpProps.setIntegerProperty("pub_ack_window_size", bean.getSendADWindowSize());
        jcsmpProps.setIntegerProperty("pub_ack_time", bean.getSendADAckTimerInMillis());
        jcsmpProps.setIntegerProperty("max_resends", bean.getSendADMaxResends());
        jcsmpProps.setIntegerProperty("sub_ack_window_size", bean.getReceiveADWindowSize());
        jcsmpProps.setIntegerProperty("sub_ack_time", bean.getReceiveADAckTimerInMillis());
        jcsmpProps.setIntegerProperty("sub_ack_window_threshold", bean.getReceiveADAckThreshold());
        jcsmpProps.setIntegerProperty("subscriber_local_priority", bean.getSubscriberLocalPriority());
        jcsmpProps.setIntegerProperty("subscriber_network_priority", bean.getSubscriberNetworkPriority());
        jcsmpProps.setBooleanProperty("generate_sender_id", bean.getGenerateSenderID());
        ccProps.setConnectTimeoutInMillis(bean.getConnectTimeoutInMillis());
        ccProps.setReadTimeoutInMillis(bean.getReadTimeoutInMillis());
        ccProps.setConnectRetries(bean.getConnectRetries());
        ccProps.setConnectRetriesPerHost(bean.getConnectRetriesPerHost());
        ccProps.setReconnectRetries(bean.getReconnectRetries());
        ccProps.setReconnectRetryWaitInMillis(bean.getReconnectRetryWaitInMillis());
        if (bean.getKeepAlives().booleanValue()) {
            ccProps.setKeepAliveIntervalInMillis(bean.getKeepAliveIntervalInMillis());
        } else {
            ccProps.setKeepAliveIntervalInMillis(0);
        }
        ccProps.setKeepAliveLimit(bean.getKeepAliveCountMax());
        ccProps.setSendBuffer(bean.getSendBufferSize());
        ccProps.setReceiveBuffer(bean.getReceiveBufferSize());
        ccProps.setTcpNoDelay(bean.getTcpNoDelay());
        int compressionLevel = bean.getCompressionLevel();
        if (compressionLevel == -1) {
            compressionLevel = bean.getJNDICompressionLevel();
        }
        ccProps.setCompressionLevel(compressionLevel);
        jcsmpProps.setBooleanProperty("reapply_subscriptions", true);
        jcsmpProps.setBooleanProperty("calculate_message_expiration", true);
        if (bean.isSetLocalhost()) {
            jcsmpProps.setProperty("localhost", bean.getLocalhost());
        }
        if (bean.isSetSSLCipherSuites()) {
            jcsmpProps.setProperty("SSL_CIPHER_SUITES", bean.getSSLCipherSuites());
        }
        if (bean.isSetSSLExcludedProtocols()) {
            jcsmpProps.setProperty("SSL_EXCLUDED_PROTOCOLS", bean.getSSLExcludedProtocols());
        }
        if (bean.isSetSSLConnectionDowngradeTo()) {
            jcsmpProps.setProperty("SSL_CONNECTION_DOWNGRADE_TO", bean.getSSLConnectionDowngradeTo());
        }
        if (bean.isSetSSLProtocol()) {
            jcsmpProps.setProperty("SSL_PROTOCOL", bean.getSSLProtocol());
        }
        if (bean.isSetSSLTrustedCommonNameList()) {
            jcsmpProps.setProperty("SSL_TRUSTED_COMMON_NAME_LIST", bean.getSSLTrustedCommonNameList());
        }
        if (bean.isSetSSLTrustStore()) {
            jcsmpProps.setProperty("SSL_TRUST_STORE", bean.getSSLTrustStore());
        }
        if (bean.isSetSSLTrustStoreFormat()) {
            jcsmpProps.setProperty("SSL_TRUST_STORE_FORMAT", bean.getSSLTrustStoreFormat());
        }
        if (bean.isSetSSLTrustStorePassword()) {
            jcsmpProps.setProperty("SSL_TRUST_STORE_PASSWORD", bean.getSSLTrustStorePassword());
        }
        if (bean.isSetSSLKeyStore()) {
            jcsmpProps.setProperty("SSL_KEY_STORE", bean.getSSLKeyStore());
        }
        if (bean.isSetSSLKeyStoreFormat()) {
            jcsmpProps.setProperty("SSL_KEY_STORE_FORMAT", bean.getSSLKeyStoreFormat());
        }
        if (bean.isSetSSLKeyStoreNormalizedFormat()) {
            jcsmpProps.setProperty("SSL_KEY_STORE_NORMALIZED_FORMAT", bean.getSSLKeyStoreNormalizedFormat());
        }
        if (bean.isSetSSLKeyStorePassword()) {
            jcsmpProps.setProperty("SSL_KEY_STORE_PASSWORD", bean.getSSLKeyStorePassword());
        }
        if (bean.isSetSSLPrivateKeyAlias()) {
            jcsmpProps.setProperty("SSL_PRIVATE_KEY_ALIAS", bean.getSSLPrivateKeyAlias());
        }
        if (bean.isSetSSLPrivateKeyPassword()) {
            jcsmpProps.setProperty("SSL_PRIVATE_KEY_PASSWORD", bean.getSSLPrivateKeyPassword());
        }
        if (bean.isSetSSLValidateCertificate()) {
            jcsmpProps.setBooleanProperty("SSL_VALIDATE_CERTIFICATE", bean.getSSLValidateCertificate());
        }
        if (bean.isSetSSLValidateCertificateDate()) {
            jcsmpProps.setBooleanProperty("SSL_VALIDATE_CERTIFICATE_DATE", bean.getSSLValidateCertificateDate());
        }
        if (bean.isSetGdReconnectFailAction()) {
            jcsmpProps.setProperty("gd_reconnect_fail_action", bean.getGdReconnectFailAction());
        }
        if (bean.isSetLargeMessaging()) {
            jcsmpProps.setBooleanProperty("large_messaging", bean.getLargeMessaging());
        }
        if (bean.isSetLargeMessagingSegmentSize()) {
            jcsmpProps.setIntegerProperty("large_message_segment_size", bean.getLargeMessagingSegmentSize());
        }
        if (bean.isSetLargeMessagingMaximumSize()) {
            jcsmpProps.setIntegerProperty("large_message_max_size", bean.getLargeMessagingMaximumSize());
        }
        if (bean.isSetJaasConfigFileReloadEnabled()) {
            jcsmpProps.setBooleanProperty("JaasConfigFileReloadEnabled", bean.getJaasConfigFileReloadEnabled());
        }
        if (bean.isSetJaasLoginContext()) {
            jcsmpProps.setProperty("JaasLoginContext", bean.getJaasLoginContext());
        }
        if (bean.isSetLargeMessagingConsumeTimeoutInMillis()) {
            jcsmpProps.setIntegerProperty("large_message_consume_timeout", bean.getLargeMessagingConsumeTimeoutInMillis());
        }
        JCSMPGlobalProperties jcsmpGlobalProperties = new JCSMPGlobalProperties();
        if (bean.isSetConsumerDefaultFlowCongestionLimit()) {
            jcsmpGlobalProperties.setConsumerDefaultFlowCongestionLimit(bean.getConsumerDefaultFlowCongestionLimit());
        }
        if (bean.isSetConsumerDispatcherQueueSize()) {
            jcsmpGlobalProperties.setConsumerDispatcherQueueSize(bean.getConsumerDispatcherQueueSize());
        }
        if (bean.isSetProducerDispatcherQueueSize()) {
            jcsmpGlobalProperties.setProducerDispatcherQueueSize(bean.getProducerDispatcherQueueSize());
        }
        if (bean.isSetFrequencyManagerMaxReconnects()) {
            jcsmpGlobalProperties.setReconnectFreqManagerMaxReconnects(bean.getFrequencyManagerMaxReconnects());
        }
        try {
            JCSMPFactory.onlyInstance().setGlobalProperties(jcsmpGlobalProperties);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Leaving toJCSMPProperties, returning :\n\n" + jcsmpProps));
        }
        return jcsmpProps;
    }

    protected static String buildHostlist(JMSPropertyBean bean, int port) {
        String hostlist = bean.getHost();
        List<HostInfo> jcsmpHostInfo = HostInfo.toHostInfoList(hostlist);
        StringBuilder bldr = new StringBuilder();
        for (int i = 0; i < jcsmpHostInfo.size(); ++i) {
            HostInfo info = jcsmpHostInfo.get(i);
            if (i > 0) {
                bldr.append(",");
            }
            bldr.append(info.getScheme());
            bldr.append("://");
            bldr.append(info.getHost());
            if (port == 0) continue;
            bldr.append(":");
            bldr.append(port);
        }
        return bldr.toString();
    }

    public synchronized JMSState getJMSState() {
        return this.mState;
    }

    public void setConnectionEventListener(SolConnectionEventListener eventListener) {
        this.mConnectionEventListener = eventListener;
    }

    static {
        JCSMPGlobalProperties.setShouldDropInternalReplyMessages(false);
    }
}

