/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.jcsmp.i18n.JCSMPRB;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JCSMPChannelProperties
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2L;
    public static final String SUPPORTED_PROTOCOL_STACK_SMF_TCP = "csmp.smf.tcp";
    public static final String SUPPORTED_PROTOCOL_STACK_SMFS_TCP = "csmp.smfs.tcp";
    protected static final List<String> supportedProtocolStacks = new ArrayList<String>();
    private String stack = "csmp.smf.tcp";
    private boolean tcpNoDelay;
    private int smfPort;
    private int connectTimeoutInMillis;
    private int readTimeoutInMillis;
    private int connectRetries;
    private int reconnectRetries;
    private int reconnectRetryWaitInMillis;
    private int keepAliveIntervalInMillis;
    private int keepAliveLimit;
    private int compressionLevel;
    private int connectRetriesPerHost;
    private int so_sndbuf;
    private int so_rcvbuf;

    public JCSMPChannelProperties() {
        this(SUPPORTED_PROTOCOL_STACK_SMF_TCP, 0, 30000, 10000, 3, 3000, 3000);
    }

    public JCSMPChannelProperties(String stack, int smfPort, int connectTimeoutInMillis, int readTimeoutInMillis, int reconnectRetries, int reconnectRetryWaitInMillis, int keepAliveIntervalInMillis) {
        this.setStack(stack);
        this.setSmfPort(smfPort);
        this.setConnectTimeoutInMillis(connectTimeoutInMillis);
        this.setReadTimeoutInMillis(readTimeoutInMillis);
        this.setConnectRetries(0);
        this.setConnectRetriesPerHost(0);
        this.setReconnectRetries(reconnectRetries);
        this.setReconnectRetryWaitInMillis(reconnectRetryWaitInMillis);
        this.setKeepAliveIntervalInMillis(keepAliveIntervalInMillis);
        this.setTcpNoDelay(true);
        this.setReceiveBuffer(65536);
        this.setSendBuffer(65536);
        this.setKeepAliveLimit(10);
        this.setCompressionLevel(0);
    }

    public Object clone() {
        JCSMPChannelProperties props = new JCSMPChannelProperties(this.stack, this.smfPort, this.connectTimeoutInMillis, this.readTimeoutInMillis, this.reconnectRetries, this.reconnectRetryWaitInMillis, this.keepAliveIntervalInMillis);
        props.setTcpNoDelay(this.isTcpNoDelay());
        props.setReceiveBuffer(this.getReceiveBuffer());
        props.setSendBuffer(this.getSendBuffer());
        props.setKeepAliveLimit(this.getKeepAliveLimit());
        props.setCompressionLevel(this.getCompressionLevel());
        props.setConnectRetries(this.getConnectRetries());
        props.setConnectRetriesPerHost(this.getConnectRetriesPerHost());
        return props;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\n");
        sb.append("\t").append("stack: ").append(this.stack).append("\n");
        sb.append("\t").append("smfPort: ").append(this.smfPort).append("\n");
        sb.append("\t").append("connectRetriesPerHost: ").append(this.connectRetriesPerHost).append("\n");
        sb.append("\t").append("connectRetries: ").append(this.connectRetries).append("\n");
        sb.append("\t").append("connectTimeoutInMillis: ").append(this.connectTimeoutInMillis).append("\n");
        sb.append("\t").append("readTimeoutInMillis: ").append(this.readTimeoutInMillis).append("\n");
        sb.append("\t").append("reconnectRetries: ").append(this.reconnectRetries).append("\n");
        sb.append("\t").append("reconnectRetryWaitInMillis: ").append(this.reconnectRetryWaitInMillis).append("\n");
        sb.append("\t").append("keepAliveIntervalInMillis: ").append(this.keepAliveIntervalInMillis).append("\n");
        sb.append("\t").append("keepAliveLimit: ").append(this.keepAliveLimit).append("\n");
        sb.append("\t").append("tcpNoDelay: ").append(this.tcpNoDelay).append("\n");
        return sb.toString();
    }

    public boolean isSecureChannel() {
        return this.stack.indexOf("https") >= 0 || this.stack.indexOf("smfs") >= 0;
    }

    public int getConnectTimeoutInMillis() {
        return this.connectTimeoutInMillis;
    }

    public void setConnectTimeoutInMillis(int connectTimeoutInMillis) {
        if (connectTimeoutInMillis < 0) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidConnectTimeoutMillis"));
        }
        this.connectTimeoutInMillis = connectTimeoutInMillis;
    }

    public int getSmfPort() {
        if (this.smfPort != 0) {
            return this.smfPort;
        }
        return this.compressionLevel == 0 ? 55555 : 55003;
    }

    public void setSmfPort(int smfPort) {
        if (smfPort < 0 || smfPort > 65535) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidHttpPort"));
        }
        this.smfPort = smfPort;
    }

    public int getKeepAliveIntervalInMillis() {
        return this.keepAliveIntervalInMillis;
    }

    public void setKeepAliveIntervalInMillis(int keepAliveIntervalInMillis) {
        if (keepAliveIntervalInMillis != 0 && keepAliveIntervalInMillis < 50) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidKeepAliveIntervalMillis"));
        }
        this.keepAliveIntervalInMillis = keepAliveIntervalInMillis;
    }

    public int getKeepAliveLimit() {
        return this.keepAliveLimit;
    }

    public void setKeepAliveLimit(int keepAliveLimit) {
        if (keepAliveLimit < 3) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidKeepAliveLimit"));
        }
        this.keepAliveLimit = keepAliveLimit;
    }

    public int getReadTimeoutInMillis() {
        return this.readTimeoutInMillis;
    }

    public void setReadTimeoutInMillis(int readTimeoutInMillis) {
        if (readTimeoutInMillis <= 0) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidReadTimeoutMillis"));
        }
        this.readTimeoutInMillis = readTimeoutInMillis;
    }

    public int getConnectRetries() {
        return this.connectRetries;
    }

    public void setConnectRetries(int connectRetries) {
        if (connectRetries < -1) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidConnectRetries"));
        }
        this.connectRetries = connectRetries;
    }

    public int getReconnectRetries() {
        return this.reconnectRetries;
    }

    public void setReconnectRetries(int reconnectRetries) {
        if (reconnectRetries < -1) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidReconnectRetries"));
        }
        this.reconnectRetries = reconnectRetries;
    }

    public int getReconnectRetryWaitInMillis() {
        return this.reconnectRetryWaitInMillis;
    }

    public void setReconnectRetryWaitInMillis(int reconnectRetryWaitInMillis) {
        if (reconnectRetryWaitInMillis < 0 || reconnectRetryWaitInMillis > 60000) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidReconnectRetryWaitMillis"));
        }
        this.reconnectRetryWaitInMillis = reconnectRetryWaitInMillis;
    }

    public String getStack() {
        return this.stack;
    }

    public void setStack(String stack) {
        if (stack == null || !supportedProtocolStacks.contains(stack)) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidStack"));
        }
        this.stack = stack;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSendBuffer() {
        return this.so_sndbuf;
    }

    public void setSendBuffer(int so_sendbuf) {
        this.so_sndbuf = so_sendbuf;
    }

    public int getReceiveBuffer() {
        return this.so_rcvbuf;
    }

    public void setReceiveBuffer(int so_rcvbuf) {
        this.so_rcvbuf = so_rcvbuf;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidCompressionLevel"));
        }
        this.compressionLevel = compressionLevel;
    }

    public void setConnectRetriesPerHost(int connectRetriesPerHost) {
        if (connectRetriesPerHost < -1) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPChannelProperties.invalidConnectRetriesPerHost"));
        }
        this.connectRetriesPerHost = connectRetriesPerHost;
    }

    public int getConnectRetriesPerHost() {
        return this.connectRetriesPerHost;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JCSMPChannelProperties)) {
            return false;
        }
        JCSMPChannelProperties cp = (JCSMPChannelProperties)o;
        return cp.getConnectTimeoutInMillis() == this.getConnectTimeoutInMillis() && cp.getKeepAliveIntervalInMillis() == this.getKeepAliveIntervalInMillis() && cp.getKeepAliveLimit() == this.getKeepAliveLimit() && cp.getReadTimeoutInMillis() == this.getReadTimeoutInMillis() && cp.getReconnectRetries() == this.getReconnectRetries() && cp.getReconnectRetryWaitInMillis() == this.getReconnectRetryWaitInMillis() && cp.getSmfPort() == this.getSmfPort() && cp.getReceiveBuffer() == this.getReceiveBuffer() && cp.getSendBuffer() == this.getSendBuffer() && cp.getStack().equals(this.getStack()) && cp.getCompressionLevel() == this.getCompressionLevel() && cp.getConnectRetriesPerHost() == this.getConnectRetriesPerHost() && cp.getConnectRetries() == this.getConnectRetries();
    }

    public int hashCode() {
        return super.hashCode();
    }

    static {
        supportedProtocolStacks.add(SUPPORTED_PROTOCOL_STACK_SMF_TCP);
    }
}

