/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.message;

import com.solacesystems.jms.SolSession;
import com.solacesystems.jms.message.SolBytesMessage;
import com.solacesystems.jms.message.SolMapMessage;
import com.solacesystems.jms.message.SolMessage;
import com.solacesystems.jms.message.SolObjectMessage;
import com.solacesystems.jms.message.SolStreamMessage;
import com.solacesystems.jms.message.SolTextMessage;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolMessageFactory {
    private static final Log log = LogFactory.getLog(SolMessageFactory.class);

    public static SolMessage getSolMessage(Message sourceMessage, SolSession mSession) throws JMSException {
        if (sourceMessage == null) {
            return null;
        }
        if (sourceMessage instanceof SolMessage) {
            return (SolMessage)sourceMessage;
        }
        SolMessage solaceTargetMessage = null;
        if (sourceMessage instanceof TextMessage) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will copy provided javax.jms.TextMessage ");
            }
            TextMessage sourceTextMessage = (TextMessage)sourceMessage;
            SolTextMessage solTextMessage = null;
            if (mSession != null) {
                solTextMessage = (SolTextMessage)mSession.createTextMessage(sourceTextMessage.getText());
            } else {
                solTextMessage = new SolTextMessage();
                solTextMessage.setText(sourceTextMessage.getText());
            }
            solaceTargetMessage = solTextMessage;
        } else if (sourceMessage instanceof ObjectMessage) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will copy provided javax.jms.ObjectMessage ");
            }
            ObjectMessage sourceObjectMessage = (ObjectMessage)sourceMessage;
            SolObjectMessage solObjectMessage = null;
            if (mSession != null) {
                solObjectMessage = (SolObjectMessage)mSession.createObjectMessage(sourceObjectMessage.getObject());
            } else {
                solObjectMessage = new SolObjectMessage();
                solObjectMessage.setObject(sourceObjectMessage.getObject());
            }
            solaceTargetMessage = solObjectMessage;
        } else if (sourceMessage instanceof MapMessage) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will copy provided javax.jms.MapMessage ");
            }
            SolMapMessage solMapMessage = null;
            solMapMessage = mSession != null ? (SolMapMessage)mSession.createMapMessage() : new SolMapMessage();
            MapMessage mm = (MapMessage)sourceMessage;
            Enumeration e = mm.getMapNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object objValue = mm.getObject(name);
                if (objValue == null) continue;
                solMapMessage.setObject(name, objValue);
            }
            solaceTargetMessage = solMapMessage;
        } else if (sourceMessage instanceof StreamMessage) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will copy provided javax.jms.StreamMessage ");
            }
            SolStreamMessage solStreamMessage = new SolStreamMessage();
            solStreamMessage = mSession != null ? (SolStreamMessage)mSession.createStreamMessage() : new SolStreamMessage();
            StreamMessage sourceStreamMessage = (StreamMessage)sourceMessage;
            try {
                while (true) {
                    solStreamMessage.writeObject(sourceStreamMessage.readObject());
                }
            }
            catch (MessageEOFException e) {
                solaceTargetMessage = solStreamMessage;
            }
        } else if (sourceMessage instanceof BytesMessage) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will copy provided javax.jms.BytesMessage ");
            }
            BytesMessage sourceBytesMessage = (BytesMessage)sourceMessage;
            SolBytesMessage solBytesMessage = null;
            solBytesMessage = mSession != null ? (SolBytesMessage)mSession.createBytesMessage() : new SolBytesMessage();
            byte[] byteBuffer = new byte[(int)sourceBytesMessage.getBodyLength()];
            sourceBytesMessage.readBytes(byteBuffer);
            solBytesMessage.writeBytes(byteBuffer);
            solaceTargetMessage = solBytesMessage;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will copy provided javax.jms.Message ");
            }
            solaceTargetMessage = mSession != null ? (SolMessage)mSession.createMessage() : new SolMessage();
        }
        if (solaceTargetMessage != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Copy Properties");
            }
            Enumeration pNames = sourceMessage.getPropertyNames();
            while (pNames != null && pNames.hasMoreElements()) {
                String pName = (String)pNames.nextElement();
                solaceTargetMessage.setObjectProperty(pName, sourceMessage.getObjectProperty(pName));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Copy JMS Headers");
            }
            solaceTargetMessage.setJMSDestination(sourceMessage.getJMSDestination());
            if (sourceMessage.getJMSCorrelationID() != null) {
                solaceTargetMessage.setJMSCorrelationID(sourceMessage.getJMSCorrelationID());
            } else if (sourceMessage.getJMSCorrelationIDAsBytes() != null) {
                solaceTargetMessage.setJMSCorrelationIDAsBytes(sourceMessage.getJMSCorrelationIDAsBytes());
            }
            if (sourceMessage.getJMSReplyTo() != null) {
                solaceTargetMessage.setJMSReplyTo(sourceMessage.getJMSReplyTo());
            }
            if (sourceMessage.getJMSType() != null) {
                solaceTargetMessage.setJMSType(sourceMessage.getJMSType());
            }
        }
        return solaceTargetMessage;
    }

    public static SolMessage getSolMessage(Message msg) throws JMSException {
        return SolMessageFactory.getSolMessage(msg, null);
    }
}

