/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.sdt;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.RawSMFMessage;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.impl.sdt.Formatter;
import com.solacesystems.jcsmp.impl.sdt.PermissiveFormatter;
import com.solacesystems.jcsmp.impl.sdt.SDTSerializable;
import com.solacesystems.jcsmp.impl.sdt.SDTStreamIF;
import com.solacesystems.jcsmp.impl.sdt.StreamTLVBuffer;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;

public class StreamImpl
implements SDTStreamIF,
SDTSerializable {
    private static final int DEFAULT_INITIAL_SIZE = 1024;
    protected StreamTLVBuffer mBuffer;
    protected Formatter mFmter;
    protected long mVersion;

    public StreamImpl() {
        this(1024);
    }

    public StreamImpl(int capacity) {
        this.mBuffer = new StreamTLVBuffer(capacity);
        this.mFmter = PermissiveFormatter.OnlyInstance;
        this.mVersion = 0L;
    }

    public StreamImpl(StreamTLVBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        this.mBuffer = buffer;
        this.mFmter = PermissiveFormatter.OnlyInstance;
        this.mVersion = 0L;
    }

    public void serialize(TLVBuffer buffer) {
        buffer.getSolByteBuffer().writeBytes(this.mBuffer.getSolByteBuffer().getBackingArray(), this.mBuffer.getSolByteBuffer().getBackingArrayOffset(), this.mBuffer.getSolByteBuffer().getLength());
    }

    public long getVersion() {
        return this.mVersion;
    }

    public void setFormatter(Formatter fmter) {
        this.mFmter = fmter;
    }

    public void clear() {
        this.mBuffer.clear();
        ++this.mVersion;
    }

    public ByteArray asByteArray() {
        return this.mBuffer.asByteArray();
    }

    public void mark() {
        this.mBuffer.mark();
    }

    public void reset() {
        this.mBuffer.reset();
    }

    public void rewind() {
        this.mBuffer.rewind();
    }

    public boolean hasRemaining() {
        return this.mBuffer.hasRemaining();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StreamImpl) {
            StreamImpl other = (StreamImpl)obj;
            return this.mBuffer.equals(other.mBuffer);
        }
        return false;
    }

    public int hashCode() {
        return this.mBuffer.hashCode();
    }

    public Object read() throws SDTException {
        return this.mBuffer.read();
    }

    public Boolean readBoolean() throws SDTException {
        return this.mFmter.getBoolean(this.mBuffer.read());
    }

    public Byte readByte() throws SDTException {
        return this.mFmter.getByte(this.mBuffer.read());
    }

    public byte[] readBytes() throws SDTException {
        return this.mFmter.getBytes(this.mBuffer.read());
    }

    public ByteArray readByteArray() throws SDTException {
        return this.mFmter.getByteArray(this.mBuffer.read());
    }

    public Character readCharacter() throws SDTException {
        return this.mFmter.getCharacter(this.mBuffer.read());
    }

    public Destination readDestination() throws SDTException {
        return this.mFmter.getDestination(this.mBuffer.read());
    }

    public Double readDouble() throws SDTException {
        return this.mFmter.getDouble(this.mBuffer.read());
    }

    public Float readFloat() throws SDTException {
        return this.mFmter.getFloat(this.mBuffer.read());
    }

    public Integer readInteger() throws SDTException {
        return this.mFmter.getInteger(this.mBuffer.read());
    }

    public Long readLong() throws SDTException {
        return this.mFmter.getLong(this.mBuffer.read());
    }

    public SDTMap readMap() throws SDTException {
        return this.mFmter.getMap(this.mBuffer.read());
    }

    public RawSMFMessage readMessage() throws SDTException {
        return this.mFmter.getMessage(this.mBuffer.read());
    }

    public Short readShort() throws SDTException {
        return this.mFmter.getShort(this.mBuffer.read());
    }

    public SDTStream readStream() throws SDTException {
        return this.mFmter.getStream(this.mBuffer.read());
    }

    public String readString() throws SDTException {
        return this.mFmter.getString(this.mBuffer.read());
    }

    public void writeBoolean(Boolean value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeByte(Byte value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeBytes(byte[] value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeBytes(byte[] value, int offset, int length) {
        this.mBuffer.write(value, offset, length);
        ++this.mVersion;
    }

    public void writeByteArray(ByteArray value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeCharacter(Character value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeDestination(Destination value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeDouble(Double value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeFloat(Float value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeInteger(Integer value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeLong(Long value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeMap(SDTMap value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeMessage(RawSMFMessage value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeObject(Object value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeShort(Short value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeStream(SDTStream value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public void writeString(String value) {
        this.mBuffer.write(value);
        ++this.mVersion;
    }

    public String toString() {
        return this.mBuffer.toString();
    }
}

