/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolEnum;
import com.solacesystems.common.util.StringUtil;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.statistics.StatType;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;

public abstract class JCSMPStats {
    private String title;
    private long lastStatsReset;
    private final StatStrategy statSupport = new StatStrategyNonAtomic();
    private static boolean _disableStats = false;

    public JCSMPStats(String title) {
        this.title = title;
        this.resetStats();
    }

    public String getTitle() {
        return this.title;
    }

    public long getLastStatsReset() {
        return this.lastStatsReset;
    }

    public synchronized void resetStats() {
        this.statSupport.initStatsFromEnumeration(StatType.elements());
        this.lastStatsReset = System.currentTimeMillis();
    }

    public long getStat(StatType t) {
        return this.statSupport.getStat(t);
    }

    public void incStat(StatType t) {
        if (_disableStats) {
            return;
        }
        this.statSupport.incStat(t);
    }

    public void incStat(StatType t, long v) {
        if (_disableStats) {
            return;
        }
        this.statSupport.incStat(t, v);
    }

    protected static final void checkStatFound(Object s) {
        if (s == null) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPStats.invalidStat"));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.title);
        int MINLEN = 44;
        Enumeration<StatType> e = StatType.elements();
        sb.append("\n");
        while (e.hasMoreElements()) {
            StatType t = e.nextElement();
            sb.append(StringUtil.padLeft(t.getLabel(), 44));
            sb.append(": ");
            sb.append(this.getStat(t));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static boolean isDisableStats() {
        return _disableStats;
    }

    static {
        try {
            if (System.getenv("JCSMP_DISABLE_STATS") != null) {
                _disableStats = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StatStrategyNonAtomic
    extends StatStrategy {
        private long[] statTable;

        private StatStrategyNonAtomic() {
        }

        @Override
        final long getStat(StatType stat) {
            int idx = stat.getId();
            return this.statTable[idx];
        }

        @Override
        final void incStat(StatType stat) {
            int idx;
            int n = idx = stat.getId();
            this.statTable[n] = this.statTable[n] + 1L;
        }

        @Override
        final void incStat(StatType stat, long v) {
            int idx;
            int n = idx = stat.getId();
            this.statTable[n] = this.statTable[n] + v;
        }

        @Override
        final void initStatsFromEnumeration(Enumeration<StatType> types) {
            Vector<SolEnum> v = new Vector<SolEnum>();
            while (types.hasMoreElements()) {
                v.add(types.nextElement());
            }
            if (this.statTable == null) {
                this.statTable = new long[v.size()];
            }
            for (SolEnum t : v) {
                this.statTable[t.getId()] = 0L;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatStrategyAtomic
    extends StatStrategy {
        private AtomicLong[] statTable;

        private StatStrategyAtomic() {
        }

        @Override
        long getStat(StatType stat) {
            int idx = stat.getId();
            AtomicLong s = this.statTable[idx];
            JCSMPStats.checkStatFound(s);
            return s.longValue();
        }

        @Override
        void incStat(StatType stat) {
            int idx = stat.getId();
            AtomicLong s = this.statTable[idx];
            JCSMPStats.checkStatFound(s);
            s.incrementAndGet();
        }

        @Override
        void incStat(StatType stat, long v) {
            int idx = stat.getId();
            AtomicLong s = this.statTable[idx];
            JCSMPStats.checkStatFound(s);
            s.addAndGet(v);
        }

        @Override
        void initStatsFromEnumeration(Enumeration<StatType> types) {
            Vector<SolEnum> v = new Vector<SolEnum>();
            while (types.hasMoreElements()) {
                v.add(types.nextElement());
            }
            if (this.statTable == null) {
                this.statTable = new AtomicLong[v.size()];
            }
            for (SolEnum t : v) {
                this.statTable[t.getId()] = new AtomicLong();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class StatStrategy {
        private StatStrategy() {
        }

        abstract long getStat(StatType var1);

        abstract void incStat(StatType var1);

        abstract void incStat(StatType var1, long var2);

        abstract void initStatsFromEnumeration(Enumeration<StatType> var1);
    }
}

