/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.common.util.Arrays;
import com.solacesystems.jcsmp.impl.BufferCloningPool;
import com.solacesystems.jcsmp.impl.BufferCloningUser;
import com.solacesystems.jcsmp.impl.ContentBuffer;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.smf.AbstractTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.FastSmfParamContainer;
import com.solacesystems.jcsmp.protocol.smf.SmfExtendedStreamTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import java.nio.ByteBuffer;

public class SMFPubMsgHeaderBean
implements HeaderDescriptionBean,
BufferCloningUser {
    private int msgLen = 0;
    private int userCosValue = 0;
    private int smfProtocol = 3;
    private FastSmfParamContainer paramCnt;
    private int dto = 0;
    private int adf = 0;
    private int dmqEligible = 0;
    private int elidingEligible = 0;
    private byte[] headerBuf;
    private ByteBuffer headerByteBuffer;
    private ContentBuffer headerByteBufferContainer;
    private int headerBufLen = 0;
    private boolean useDirectBuffer;

    public SMFPubMsgHeaderBean(boolean isDirect) {
        this.useDirectBuffer = isDirect;
        this.paramCnt = new FastSmfParamContainer();
        this.headerByteBufferContainer = new ContentBuffer(2048, this.useDirectBuffer);
        this.headerByteBuffer = this.headerByteBufferContainer.getByteBufferRefInternal();
        this.headerBuf = this.headerByteBuffer.isDirect() ? new byte[2048] : this.headerByteBufferContainer.getByteBufferRefInternal().array();
    }

    public SMFPubMsgHeaderBean(SMFPubMsgHeaderBean toclone, BufferCloningPool bufCloningPool) {
        this.paramCnt = toclone.paramCnt == null ? null : new FastSmfParamContainer(toclone.paramCnt, bufCloningPool);
        this.msgLen = toclone.msgLen;
        this.userCosValue = toclone.userCosValue;
        this.smfProtocol = toclone.smfProtocol;
        this.dto = toclone.dto;
        this.adf = toclone.adf;
        this.dmqEligible = toclone.dmqEligible;
        this.elidingEligible = toclone.elidingEligible;
        this.useDirectBuffer = toclone.useDirectBuffer;
        this.headerByteBufferContainer = bufCloningPool != null ? bufCloningPool.acquireCopy(toclone.headerByteBufferContainer) : new ContentBuffer(toclone.headerByteBufferContainer);
        this.headerByteBuffer = this.headerByteBufferContainer.getByteBufferRefInternal();
        this.headerBuf = this.headerByteBuffer.isDirect() ? Arrays.copyOf(toclone.headerBuf) : this.headerByteBufferContainer.getByteBufferRefInternal().array();
    }

    @Override
    public void reset() {
        this.msgLen = 0;
        this.userCosValue = 0;
        this.dto = 0;
        this.adf = 0;
        this.dmqEligible = 0;
        this.elidingEligible = 0;
        this.paramCnt.reset();
        this.smfProtocol = 3;
        this.headerBufLen = 0;
        this.headerByteBuffer.clear();
    }

    public int getMsgLen() {
        return this.msgLen;
    }

    public SMFPubMsgHeaderBean setMsgLen(int msgLen) {
        this.msgLen = msgLen;
        return this;
    }

    @Override
    public void addParam(AbstractTLVParameter param) {
        if (param instanceof SmfExtendedStreamTLVParameter) {
            SmfExtendedStreamTLVParameter esp = (SmfExtendedStreamTLVParameter)param;
            this.paramCnt.addParam(esp);
        } else {
            this.paramCnt.addParam(param.uh, param.type, param.value);
        }
    }

    public void addParam(int uh, int type, byte[] value) {
        this.paramCnt.addParam(uh, type, value);
    }

    public void addEncodedParam(byte[] encodedParam) {
        this.paramCnt.addEncodedParam(encodedParam);
    }

    public FastSmfParamContainer getParamContainer() {
        return this.paramCnt;
    }

    public SmfTLVParameter[] findParameters(int typeEnum) {
        throw new IllegalArgumentException("not supported");
    }

    public SmfTLVParameter[] getParams() {
        throw new IllegalArgumentException("not supported");
    }

    public int getEncodedParams(byte[] paramData) {
        return this.paramCnt.getEncodedParams(paramData);
    }

    public String toString() {
        String s = "msgLen=" + this.msgLen + ";encodedParamsLen=" + this.paramCnt.getEncodedParamsLen();
        return s;
    }

    @Override
    public int getSmfEncodedLength() {
        int totalLen = 12;
        return totalLen += this.paramCnt.getEncodedParamsLen();
    }

    public int getSmfEncodedLength(int smfVersion) {
        int totalLen = 0;
        switch (smfVersion) {
            case 2: {
                totalLen += 8;
                totalLen += this.paramCnt.getEncodedParamsLen();
                while (totalLen % 4 != 0) {
                    ++totalLen;
                }
                return totalLen;
            }
            case 3: {
                totalLen += 12;
                return totalLen += this.paramCnt.getEncodedParamsLen();
            }
        }
        return 0;
    }

    public int getUserCosValue() {
        return this.userCosValue;
    }

    public void setUserCosValue(int userCosValue) {
        this.userCosValue = userCosValue;
    }

    public int getDto() {
        return this.dto;
    }

    public void setDto(int dto) {
        this.dto = dto;
    }

    public int getAdf() {
        return this.adf;
    }

    public void setAdf(int adf) {
        this.adf = adf;
    }

    public int getDmqEligible() {
        return this.dmqEligible;
    }

    public void setDmqEligible(int dmqEligible) {
        this.dmqEligible = dmqEligible;
    }

    public int getElidingEligible() {
        return this.elidingEligible;
    }

    public void setElidingEligible(int elidingEligible) {
        this.elidingEligible = elidingEligible;
    }

    @Override
    public int getMaxParamAction() {
        return 0;
    }

    @Override
    public boolean isUnkParamFlagSet() {
        return false;
    }

    @Override
    public void setParamAction(int uh) {
    }

    @Override
    public void setUnkParamFlag(boolean unk_param_found) {
    }

    public int getSmfProtocol() {
        return this.smfProtocol;
    }

    public void setSmfProtocol(int smfProtocol) {
        this.smfProtocol = smfProtocol;
    }

    public byte[] getHeaderBuf() {
        return this.headerBuf;
    }

    public int getHeaderBufLen() {
        return this.headerBufLen;
    }

    public void setHeaderBufLen(int len) {
        this.headerBufLen = len;
    }

    public void dumpHeaderToDirectBB() {
        if (this.useDirectBuffer) {
            this.headerByteBuffer.clear();
            this.headerByteBuffer.put(this.headerBuf, 0, this.headerBufLen);
        } else {
            this.headerByteBuffer.clear();
            this.headerByteBuffer.position(this.headerBufLen);
            this.headerByteBuffer.limit(this.headerBuf.length);
        }
    }

    public ByteBuffer getHeaderByteBuffer() {
        return this.headerByteBuffer;
    }

    @Override
    public void releaseContentBuffer(BufferCloningPool bufCloningPool) {
        bufCloningPool.release(this.headerByteBufferContainer);
        this.paramCnt.releaseContentBuffer(bufCloningPool);
    }
}

