/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.message;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.MapMessage;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTFormatException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jcsmp.impl.sdt.MapTLVBuffer;
import com.solacesystems.jcsmp.impl.sdt.SDTMapIF;
import com.solacesystems.jms.encoding.MapFormatter;
import com.solacesystems.jms.message.MapMessageIF;
import com.solacesystems.jms.message.SolMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class SolMapMessage
extends SolMessage
implements MapMessageIF,
Serializable {
    private static final long serialVersionUID = 1001785188200117377L;
    private transient SDTMapIF mMap = null;

    public SolMapMessage() {
    }

    public SolMapMessage(MapMessage message) {
        super(message);
    }

    @Override
    public SDTMap getMap() {
        if (this.mBodyMode == SolMessage.MessageBodyMode.ReadUnloadedMode) {
            this.initializeReading();
        }
        return this.mMap;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        if (this.mMap != null) {
            this.mMap.clear();
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return false;
        }
        try {
            Boolean value = this.mMap.getBoolean(name);
            if (value == null) {
                return false;
            }
            return value;
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public byte getByte(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return 0;
        }
        try {
            Byte value = this.mMap.getByte(name);
            if (value == null) {
                return 0;
            }
            return value;
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public short getShort(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return 0;
        }
        try {
            Short value = this.mMap.getShort(name);
            if (value == null) {
                return 0;
            }
            return value;
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public char getChar(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            throw new NullPointerException();
        }
        try {
            Character value = this.mMap.getCharacter(name);
            if (value == null) {
                throw new NullPointerException();
            }
            return value.charValue();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public int getInt(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return 0;
        }
        try {
            Integer value = this.mMap.getInteger(name);
            if (value == null) {
                return 0;
            }
            return value;
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public long getLong(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return 0L;
        }
        try {
            Long value = this.mMap.getLong(name);
            if (value == null) {
                return 0L;
            }
            return value;
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public float getFloat(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return 0.0f;
        }
        try {
            Float value = this.mMap.getFloat(name);
            if (value == null) {
                return 0.0f;
            }
            return value.floatValue();
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public double getDouble(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return 0.0;
        }
        try {
            Double value = this.mMap.getDouble(name);
            if (value == null) {
                return 0.0;
            }
            return value;
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public String getString(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return null;
        }
        try {
            return this.mMap.getString(name);
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public byte[] getBytes(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return null;
        }
        try {
            return this.mMap.getBytes(name);
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public Object getObject(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return null;
        }
        try {
            Object value = this.mMap.get(name);
            if (value instanceof ByteArray) {
                return ((ByteArray)value).asBytes();
            }
            return value;
        }
        catch (SDTException e) {
            throw this.handleException(e);
        }
    }

    public Enumeration<?> getMapNames() throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return EMPTY_PROPERTY_NAMES;
        }
        return Collections.enumeration(this.mMap.keySet());
    }

    protected void put(String name, Object value) throws JMSException {
        if (name == null) {
            throw new IllegalArgumentException("The name of the property cannot be null.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("The name of the property cannot be an emprty string.");
        }
        try {
            this.mMap.putObject(name, value);
            if (this.mMap.size() > 65535) {
                throw new IllegalArgumentException("The size of the map cannot exceed 65535 entries.");
            }
        }
        catch (SDTException e) {
            throw new MessageNotWriteableException(e.getMessage());
        }
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.initializeWriting();
        this.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Byte(value));
    }

    public void setShort(String name, short value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Short(value));
    }

    public void setChar(String name, char value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Character(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Integer(value));
    }

    public void setLong(String name, long value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Long(value));
    }

    public void setFloat(String name, float value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Float(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Double(value));
    }

    public void setString(String name, String value) throws JMSException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.initializeWriting();
        if (value != null) {
            this.put(name, value);
        } else {
            this.mMap.remove(name);
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        byte[] data = new byte[length];
        System.arraycopy(value, offset, data, 0, length);
        this.put(name, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(String name, Object value) throws JMSException {
        this.initializeWriting();
        if (value != null) {
            if (!(value instanceof Number) && !(value instanceof String) && !(value instanceof Boolean) && !(value instanceof Byte) && !(value instanceof Character) && !(value instanceof byte[])) throw new MessageFormatException(value.getClass() + " is not a primitive type");
            this.put(name, value);
            return;
        } else {
            this.put(name, null);
        }
    }

    public boolean itemExists(String name) throws JMSException {
        this.initializeReading();
        if (this.mMap == null) {
            return false;
        }
        return this.mMap.containsKey(name);
    }

    private void initializeWriting() throws MessageNotWriteableException {
        if (this.mBodyMode != SolMessage.MessageBodyMode.WriteMode) {
            throw new MessageNotWriteableException("This message is in read-only mode");
        }
        if (this.mMap == null) {
            this.mMap = new MapImpl();
            this.mMap.setFormatter(MapFormatter.OnlyInstance);
        }
    }

    private void initializeReading() {
        if (this.mBodyMode == SolMessage.MessageBodyMode.ReadUnloadedMode) {
            this.mMap = (SDTMapIF)((MapMessage)this.mMessage).getMap();
            if (this.mMap != null) {
                this.mMap.setFormatter(MapFormatter.OnlyInstance);
            }
            this.mBodyMode = SolMessage.MessageBodyMode.ReadLoadedMode;
        }
    }

    private JMSException handleException(SDTException e) {
        JMSException jmsEx = e instanceof SDTFormatException ? new MessageFormatException(e.getMessage()) : new JMSException("internal error");
        jmsEx.setLinkedException((Exception)e);
        return jmsEx;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.initializeReading();
        out.defaultWriteObject();
        if (this.mMap != null) {
            ByteArray ba = this.mMap.asByteArray();
            out.write(ba.getBuffer(), ba.getOffset(), ba.getLength());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in.available() == 0) {
            this.mMap = null;
        } else {
            byte[] data = this.toByteArray(in);
            this.mMap = new MapImpl(new MapTLVBuffer(data));
        }
    }
}

