/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPFactory;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.transaction.BaseTransactedSessionImpl;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSMPXMLMessagePool {
    private static final Log Trace = LogFactory.getLog(JCSMPXMLMessagePool.class);
    private final LinkedList<JCSMPGenericXMLMessage> _genericQueue = new LinkedList();
    private int _size = 0;
    private int _allocatedCnt = 0;
    private boolean _throwOnFull = false;
    private BaseTransactedSessionImpl _txSession;

    public JCSMPXMLMessagePool() {
        this(false, null);
    }

    public JCSMPXMLMessagePool(boolean throwOnFull, BaseTransactedSessionImpl txSession) {
        this._throwOnFull = throwOnFull;
        this._txSession = txSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int size) {
        LinkedList<JCSMPGenericXMLMessage> linkedList = this._genericQueue;
        synchronized (linkedList) {
            this._size = size;
        }
    }

    public JCSMPGenericXMLMessage getGenericMessage() {
        JCSMPGenericXMLMessage msg = null;
        try {
            msg = this.getGenericMessageThrows();
        }
        catch (JCSMPException jCSMPException) {
            // empty catch block
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCSMPGenericXMLMessage getGenericMessageThrows() throws JCSMPException {
        JCSMPGenericXMLMessage rMsg = null;
        LinkedList<JCSMPGenericXMLMessage> linkedList = this._genericQueue;
        synchronized (linkedList) {
            while (this._genericQueue.size() == 0) {
                if (this._allocatedCnt < this._size) {
                    this.allocate();
                    continue;
                }
                if (this._throwOnFull && !this._txSession.isTransportAckExpected()) {
                    throw new IllegalStateException("Too many messages in a transaction");
                }
                try {
                    this._genericQueue.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new JCSMPInterruptedException("Interrupted", e);
                }
            }
            rMsg = this._genericQueue.removeFirst();
        }
        rMsg.setFlagReturnedToPool(false);
        return rMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnMessageToPool(XMLMessage message) {
        JCSMPGenericXMLMessage xmlMsg = (JCSMPGenericXMLMessage)message;
        LinkedList<JCSMPGenericXMLMessage> linkedList = this._genericQueue;
        synchronized (linkedList) {
            if (xmlMsg.isFlagReturnedToPool()) {
                return;
            }
            xmlMsg.setFlagReturnedToPool(true);
            this._genericQueue.addFirst((JCSMPGenericXMLMessage)message);
            if (this._genericQueue.size() == 1) {
                this._genericQueue.notifyAll();
            }
        }
    }

    private void allocate() {
        JCSMPGenericXMLMessage message = new JCSMPGenericXMLMessage(JCSMPFactory.onlyInstance().getGlobalProperties().getContentBufferSizeDefault());
        message.setMsgPool(this);
        this._genericQueue.add(message);
        ++this._allocatedCnt;
    }
}

