/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.csmp;

import com.solacesystems.common.util.InetAddressUtil;
import com.solacesystems.jcsmp.protocol.smf.PubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SubCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactoryPubCtrl;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class CSMPMessageFactory {
    private static CSMPMessageFactory instance = new CSMPMessageFactory();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static byte[] XML;
    private static byte[] CLOSE_ATT_TAG;
    private static byte[] ZERO;
    private static byte[] ONE;
    private static byte[] WHITESPACE;
    private static byte[] CSMP_VERION;
    private static byte[] ADD_SUBSCRIBER;
    private static byte[] ADD_SUBSCRIBER_END;
    private static byte[] REMOVE_SUBSCRIBER;
    private static byte[] REMOVE_SUBSCRIBER_END;
    private static byte[] SUBSCRIPTION_UPDATE;
    private static byte[] SUBSCRIPTION_UPDATE_END;
    private static byte[] PACKET_LIST;
    private static byte[] PACKET_LIST_END;
    private static byte[] SUBSCRIPTION_PACKET;
    private static byte[] SUBSCRIPTION_PACKET_END;
    private static byte[] ADD_FLAG;
    private static byte[] QUEUENAME;
    private static byte[] SUBSCRIPTION;
    private static byte[] XPE;
    private static byte[] IS_FILTER;
    private static byte[] CID;
    private static byte[] SUBSCRIPTION_REFRESH_START;
    private static byte[] SUBSCRIPTION_REFRESH_END;

    private CSMPMessageFactory() {
    }

    public static CSMPMessageFactory onlyInstance() {
        return instance;
    }

    private byte[] toBytes(ByteBuffer buffer) {
        if (buffer == null) {
            return new byte[0];
        }
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    public byte[] buildAddSubscriberMessage() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(XML.length + ADD_SUBSCRIBER.length + CSMP_VERION.length + CLOSE_ATT_TAG.length + CLOSE_ATT_TAG.length + ADD_SUBSCRIBER_END.length);
        buffer.put(XML);
        buffer.put(ADD_SUBSCRIBER);
        buffer.put(CSMP_VERION).put(CLOSE_ATT_TAG);
        buffer.put(ADD_SUBSCRIBER_END);
        buffer.flip();
        return this.toBytes(buffer);
    }

    public byte[] buildRemoveSubscriberMessage() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(XML.length + REMOVE_SUBSCRIBER.length + CSMP_VERION.length + CLOSE_ATT_TAG.length + REMOVE_SUBSCRIBER_END.length);
        buffer.put(XML);
        buffer.put(REMOVE_SUBSCRIBER);
        buffer.put(CSMP_VERION).put(CLOSE_ATT_TAG);
        buffer.put(REMOVE_SUBSCRIBER_END);
        buffer.flip();
        return this.toBytes(buffer);
    }

    public SubCtrlHeaderBean buildSubscriberControlPacketHeaderBean() {
        SubCtrlHeaderBean h = new SubCtrlHeaderBean();
        h.setProtocolVersion(3);
        return h;
    }

    public PubCtrlHeaderBean buildPublisherControlMessageBean(int localPort, String localIP, boolean enableExpAck) {
        PubCtrlHeaderBean h = new PubCtrlHeaderBean();
        TlvParameterFactoryPubCtrl fac = TlvParameterFactoryPubCtrl.instance();
        if (enableExpAck) {
            h.addParam(fac.getExplicitAckMode());
        }
        if (localPort > 0) {
            h.addParam(fac.getUdpPort(localPort));
        }
        if (localIP != null && localIP.trim().length() > 0) {
            byte[] addrBytes = InetAddressUtil.ipAddressToBytes(localIP);
            h.addParam(fac.getUdpSourceAddress(addrBytes));
        }
        return h;
    }

    static {
        try {
            XML = "<?xml version='1.0' encoding='UTF-8'?>".getBytes(DEFAULT_ENCODING);
            CLOSE_ATT_TAG = "\"/>".getBytes(DEFAULT_ENCODING);
            ZERO = "0".getBytes(DEFAULT_ENCODING);
            ONE = "1".getBytes(DEFAULT_ENCODING);
            WHITESPACE = " ".getBytes(DEFAULT_ENCODING);
            CSMP_VERION = "<csmpVersion val=\"1.4".getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            ADD_SUBSCRIBER = "<AddSubscriber>".getBytes(DEFAULT_ENCODING);
            ADD_SUBSCRIBER_END = "</AddSubscriber>".getBytes(DEFAULT_ENCODING);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            REMOVE_SUBSCRIBER = "<RemoveSubscriber>".getBytes(DEFAULT_ENCODING);
            REMOVE_SUBSCRIBER_END = "</RemoveSubscriber>".getBytes(DEFAULT_ENCODING);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SUBSCRIPTION_UPDATE = "<SubscriptionUpdate>".getBytes(DEFAULT_ENCODING);
            SUBSCRIPTION_UPDATE_END = "</SubscriptionUpdate>".getBytes(DEFAULT_ENCODING);
            PACKET_LIST = "<PacketList>".getBytes(DEFAULT_ENCODING);
            PACKET_LIST_END = "</PacketList>".getBytes(DEFAULT_ENCODING);
            SUBSCRIPTION_PACKET = "<SubscriptionPacket>".getBytes(DEFAULT_ENCODING);
            SUBSCRIPTION_PACKET_END = "</SubscriptionPacket>".getBytes(DEFAULT_ENCODING);
            ADD_FLAG = "<addFlag val=\"".getBytes(DEFAULT_ENCODING);
            SUBSCRIPTION = "<subscription".getBytes(DEFAULT_ENCODING);
            QUEUENAME = "<queueName val=\"".getBytes(DEFAULT_ENCODING);
            XPE = " xpe=\"".getBytes(DEFAULT_ENCODING);
            IS_FILTER = "<isFilter val=\"".getBytes(DEFAULT_ENCODING);
            CID = "<consumerId val=\"".getBytes(DEFAULT_ENCODING);
            SUBSCRIPTION_REFRESH_START = "<refreshStart val=\"1\"/>".getBytes(DEFAULT_ENCODING);
            SUBSCRIPTION_REFRESH_END = "<refreshEnd val=\"1\"/>".getBytes(DEFAULT_ENCODING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

