/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.compression;

import com.jcraft.jzlib.ZStream;
import com.solacesystems.jcsmp.impl.compression.SolZlibCallResult;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolZlibDeflatePipe {
    private static final Log Trace = LogFactory.getLog(SolZlibDeflatePipe.class);
    static final byte[] hello = "hello! thisisareallyloooooooooooooooooooooooooooongwordthaaaaaaaaaaaaaaaaaaaaaaaaaatdemonstratestheabilitytosetwindowsizeandbythewaywestillnothappywiththeproperlength".getBytes(Charset.forName("UTF-8"));
    static final byte[] abc = "abcdefghijklmnopqrstuvwxyz".getBytes(Charset.forName("UTF-8"));
    static final byte[] dict = "hello word aaaaaaaaaaaaaaaaaaa demonstratestheabilitytosetwindowsizeandbythewaywe".getBytes(Charset.forName("UTF-8"));
    static final String ERR_IOEXCEPTION = "zlib error";
    ZStream infl_stream = new ZStream();
    ZStream defl_stream = new ZStream();
    boolean infl_stream_init = false;
    boolean defl_stream_init = false;
    final int compressionLevel;

    public SolZlibDeflatePipe(int solCompressionLevel) {
        this.init();
        this.compressionLevel = solCompressionLevel;
    }

    private void init() {
    }

    public long deflateAndFlush(byte[] input, int inputStart, int inputEnd, byte[] output, int outputStart, int outputEnd) throws IOException {
        ZStream c_stream = this.defl_stream;
        int returnCode = 0;
        if (!this.defl_stream_init) {
            this.defl_stream_init = true;
            int mem_WBITS = 13;
            returnCode = c_stream.deflateInit(this.compressionLevel, mem_WBITS, true);
            if (returnCode != 0) {
                throw new IOException(ERR_IOEXCEPTION);
            }
        }
        int uncompressedSize = inputEnd - inputStart;
        int compressedAvailable = outputEnd - outputStart;
        c_stream.next_out = output;
        c_stream.next_out_index = outputStart;
        c_stream.avail_out = compressedAvailable;
        c_stream.next_in = input;
        c_stream.next_in_index = inputStart;
        c_stream.avail_in = uncompressedSize;
        int availableIn = uncompressedSize;
        int availableOut = compressedAvailable;
        long prev_total_in = c_stream.total_in;
        long prev_total_out = c_stream.total_out;
        while (c_stream.total_in - prev_total_in < (long)uncompressedSize && c_stream.total_out - prev_total_out < (long)compressedAvailable) {
            c_stream.avail_in = availableIn;
            c_stream.avail_out = availableOut;
            if (c_stream.deflate(2) != 0) {
                throw new IOException(ERR_IOEXCEPTION);
            }
            availableIn -= (int)(c_stream.total_in - prev_total_in);
            availableOut -= (int)(c_stream.total_out - prev_total_out);
        }
        if (availableOut == 0) {
            throw new IOException("Stream compression error: improperly sized compressed output buffer.");
        }
        c_stream.avail_out = availableOut;
        return c_stream.total_out - prev_total_out;
    }

    public SolZlibCallResult inflateChunks(byte[] input, int inputStart, int inputEnd, byte[] output, int outputStart, int outputEnd) {
        AtomicInteger inp_consumed;
        long output_this_chunk;
        int to_process = inputEnd - inputStart;
        int input_consumed = 0;
        int decompressed = 0;
        do {
            inp_consumed = new AtomicInteger(0);
            output_this_chunk = this.inflateChunkWithLookback(input, inputStart, inputEnd, output, outputStart, outputEnd, inp_consumed);
            inputStart += inp_consumed.get();
            outputStart = (int)((long)outputStart + output_this_chunk);
            decompressed = (int)((long)decompressed + output_this_chunk);
            input_consumed += inp_consumed.get();
        } while (output_this_chunk > 0L && (to_process -= inp_consumed.get()) > 0);
        SolZlibCallResult r = new SolZlibCallResult();
        r.bytes_consumed = input_consumed;
        r.bytes_output = decompressed;
        return r;
    }

    public long inflateChunkWithLookback(byte[] input, int inputStart, int inputEnd, byte[] output, int outputStart, int outputEnd, AtomicInteger inputConsumed) {
        long outBytesThisCallStart;
        long inBytesThisPassStart;
        block5: {
            int compressedBufferSize = inputEnd - inputStart;
            int uncompressedBufferAvailableSize = outputEnd - outputStart;
            this.infl_stream.next_in = input;
            this.infl_stream.next_in_index = inputStart;
            this.infl_stream.avail_in = compressedBufferSize;
            this.infl_stream.next_out = output;
            this.infl_stream.next_out_index = outputStart;
            this.infl_stream.avail_out = uncompressedBufferAvailableSize;
            int returnCode = 0;
            if (!this.infl_stream_init) {
                this.infl_stream_init = true;
                returnCode = this.infl_stream.inflateInit(true);
                if (returnCode != 0) {
                    return -1L;
                }
            }
            inBytesThisPassStart = this.infl_stream.total_in;
            outBytesThisCallStart = this.infl_stream.total_out;
            while (true) {
                long outBytesThisPassStart = this.infl_stream.total_out;
                returnCode = this.infl_stream.inflate(2);
                long bytesThisPass = this.infl_stream.total_out - outBytesThisPassStart;
                if (returnCode == 1 || returnCode == 0) {
                    // empty if block
                }
                if (returnCode == 1) {
                    this.infl_stream.inflateEnd();
                    this.infl_stream_init = false;
                    break block5;
                }
                if (returnCode == 0) continue;
                if (returnCode == -5) break block5;
                if (returnCode == -1 || returnCode == -2 || returnCode == -3 || returnCode == -6) break;
            }
            return -1L;
        }
        inputConsumed.set((int)this.infl_stream.total_in - (int)inBytesThisPassStart);
        return this.infl_stream.total_out - outBytesThisCallStart;
    }
}

