/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.concurrent.impl;

import com.solacesystems.common.concurrent.Worker;
import com.solacesystems.common.util.trace.Trace;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class SingleQueueExecutorImpl2
implements Worker {
    ExecutorService ex;

    public SingleQueueExecutorImpl2(final String name) {
        this.ex = Executors.newFixedThreadPool(1, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread th = new Thread(r);
                th.setName(String.format("SQEImpl_Thread_%s", name));
                th.setDaemon(true);
                return th;
            }
        });
    }

    public void enqueue(Runnable r) {
        if (r == null && Trace.isErrorEnabled(this)) {
            Trace.error((Object)this, "cannot enqueue(null)");
            return;
        }
        Future<?> fut = this.ex.submit(r);
    }

    public void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.ex.shutdown();
    }

    public void shutdownNow() {
        this.ex.shutdownNow();
    }

    public boolean isShutdown() {
        return this.ex.isShutdown();
    }
}

