/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.requestreply;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPRequestTimeoutException;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.RequestReplyListener;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageConsumer;
import com.solacesystems.jcsmp.impl.Request;
import com.solacesystems.jcsmp.impl.RequestListener;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericRequestTask
implements RequestListener {
    private static final Log Trace = LogFactory.getLog(GenericRequestTask.class);
    private final ArrayBlockingQueue<Object> _syncQ = new ArrayBlockingQueue(1);
    private final Request _request;
    private final XMLMessage _msg;
    private final JCSMPSession _session;
    private final boolean _correlationIdRequired;
    private final RequestReplyListener _listener;
    private final Object _requestMsgKey;

    public GenericRequestTask(JCSMPSession session, XMLMessage outgoingMsg, XMLMessageProducer producer, JCSMPXMLMessageConsumer consumer, Destination destination, long timeout) {
        this._session = session;
        this._msg = outgoingMsg;
        this._listener = null;
        this._requestMsgKey = null;
        this._correlationIdRequired = timeout > 0L;
        this._request = new Request(this._session, producer, consumer.getLiveMessageController(), outgoingMsg, destination, timeout, this);
    }

    public GenericRequestTask(JCSMPSession session, XMLMessage outgoingMsg, XMLMessageProducer producer, JCSMPXMLMessageConsumer consumer, Destination destination, RequestReplyListener listener, Object key, long timeout) {
        this._session = session;
        this._msg = outgoingMsg;
        this._correlationIdRequired = true;
        this._listener = listener;
        this._requestMsgKey = key;
        this._request = new Request(this._session, producer, consumer.getLiveMessageController(), outgoingMsg, destination, timeout, this);
    }

    private void addCorrelationId(XMLMessage msg, long id) {
        if (msg.getCorrelationId() != null) {
            return;
        }
        msg.setCorrelationId(String.format("#REQ%s", id));
    }

    private void addReplyTo(XMLMessage msg) {
        if (msg.getReplyTo() != null) {
            return;
        }
        Topic replyToTopic = (Topic)this._session.getProperty("p2pinbox_in_use");
        msg.setReplyTo(replyToTopic);
    }

    public void send() throws JCSMPException {
        if (this._correlationIdRequired) {
            this.addCorrelationId(this._msg, this._request.getId());
        }
        this.addReplyTo(this._msg);
        this._request.send();
    }

    public BytesXMLMessage waitForResponse() throws JCSMPException {
        Object ret_obj = null;
        try {
            ret_obj = this._syncQ.take();
        }
        catch (InterruptedException ex) {
            ret_obj = new JCSMPInterruptedException("waitForResponse interrupted", ex);
        }
        if (ret_obj instanceof JCSMPException) {
            throw (JCSMPException)ret_obj;
        }
        return (BytesXMLMessage)ret_obj;
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onException(JCSMPException exception) {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)("RequestTask.onException: " + exception));
        }
        if (this._listener != null) {
            try {
                this._listener.onException(exception, this._requestMsgKey);
            }
            catch (Throwable t) {
                Trace.debug((Object)"onException: got exception ", t);
            }
        } else if (!this._syncQ.offer(exception)) {
            Trace.debug((Object)"offer failed");
        }
    }

    @Override
    public void onResponse(final JCSMPXMLMessage message) {
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)("RequestTask.onResponse: " + message));
        }
        if (this._listener != null) {
            try {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GenericRequestTask.this._listener.onReply(FlowHandleImpl.createStructuredType(message), GenericRequestTask.this._requestMsgKey);
                        }
                        catch (Throwable t) {
                            Trace.debug((Object)"onReply: got exception ", t);
                        }
                    }
                };
                ((JCSMPBasicSession)this._session).getContext().getRequestReplyervice().submit(r);
            }
            catch (Throwable t) {
                Trace.debug((Object)"onReply: got exception ", t);
            }
        } else if (!this._syncQ.offer(FlowHandleImpl.createStructuredType(message))) {
            Trace.debug((Object)"offer failed");
        }
    }

    @Override
    public void onTimeout() {
        if (this._listener != null) {
            try {
                this._listener.onTimeout(this._requestMsgKey);
            }
            catch (Throwable t) {
                Trace.debug((Object)"onTimeout: got exception ", t);
            }
        } else {
            JCSMPRequestTimeoutException timeoutEx = new JCSMPRequestTimeoutException("Timeout occurred performing request");
            this.onException(timeoutEx);
        }
    }
}

