/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.xa;

import com.solacesystems.common.xa.XidFormatter;
import javax.transaction.xa.Xid;

public class DefaultXidFormatter
implements XidFormatter {
    public static final DefaultXidFormatter onlyInstance = new DefaultXidFormatter();

    private DefaultXidFormatter() {
    }

    @Override
    public String toString(Xid xid) {
        int i;
        int formatId = xid.getFormatId();
        byte[] globalTxId = xid.getGlobalTransactionId();
        byte[] branchQual = xid.getBranchQualifier();
        StringBuilder bldr = new StringBuilder();
        bldr.append(String.format("%08X-", formatId));
        if (globalTxId == null) {
            bldr.append("null");
        } else {
            for (i = 0; i < globalTxId.length; ++i) {
                bldr.append(String.format("%02X", globalTxId[i]));
            }
            bldr.append("-");
        }
        if (branchQual == null) {
            bldr.append("null");
        } else {
            for (i = 0; i < branchQual.length; ++i) {
                bldr.append(String.format("%02X", branchQual[i]));
            }
        }
        return bldr.toString();
    }
}

