/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.nio.impl;

import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.impl.flow.FlowHandle;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.timers.MsgSegmentReconstructionTimedTask;
import com.solacesystems.jcsmp.impl.timers.SegmentFlowCreationTimedTask;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerMessageNotification;

public class ConsumerLargeMessageNotification
extends ConsumerMessageNotification {
    private XMLMessage signalMessage;
    private String lgmMsgId;
    private Integer numSegments;
    private Integer totalSize;
    private int segmentsRecvd = 0;
    private int lastSegId = 0;
    private byte[] segmentsBuffer;
    private int segmentsBufferPos = 0;
    private int xmlContentLen = 0;
    private XMLMessage lastSegmentMsgRecvd;
    private MsgSegmentReconstructionTimedTask timeoutTask;
    private boolean timeoutNotification = false;
    private SegmentFlowCreationTimedTask flowCreationTimeoutTask;
    private volatile boolean suspended = false;

    public ConsumerLargeMessageNotification(FlowHandle consumer, XMLMessage message, String lgmMsgId, Integer numSegments, Integer totalSize) {
        super(consumer);
        this.signalMessage = message;
        this.lgmMsgId = lgmMsgId;
        this.numSegments = numSegments;
        this.totalSize = totalSize;
        this.segmentsBuffer = new byte[totalSize.intValue()];
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public String toString() {
        return String.format("ConsumerLargeMessageNotification: lgmMsgId=%s, numSegments=%s, totalSize=%s, timeoutNotification=%s, suspended=%s", this.lgmMsgId, this.numSegments, this.totalSize, this.timeoutNotification, this.suspended);
    }

    @Override
    public int handleNotification() {
        if (!this.is_canceled()) {
            ((FlowHandleImpl)this.getConsumer()).handleLargeMsgNotification(this);
        }
        return 0;
    }

    public XMLMessage getSignalMessage() {
        return this.signalMessage;
    }

    public String getLgmMsgId() {
        return this.lgmMsgId;
    }

    public Integer getNumSegments() {
        return this.numSegments;
    }

    public Integer getTotalSize() {
        return this.totalSize;
    }

    public int getSegmentRecvd() {
        return this.segmentsRecvd;
    }

    public int incSegementRecvd() {
        ++this.segmentsRecvd;
        return this.segmentsRecvd;
    }

    public byte[] getSegmentsBuffer() {
        return this.segmentsBuffer;
    }

    public void appendSegment(byte[] segment, boolean xmlContent) {
        if (this.segmentsBuffer != null) {
            System.arraycopy(segment, 0, this.segmentsBuffer, this.segmentsBufferPos, segment.length);
            this.segmentsBufferPos += segment.length;
            if (xmlContent) {
                this.xmlContentLen += segment.length;
            }
        }
    }

    public void clearSegmentsBuffer() {
        if (this.segmentsBuffer != null) {
            this.segmentsBuffer = null;
        }
    }

    public MsgSegmentReconstructionTimedTask getTimeoutTask() {
        return this.timeoutTask;
    }

    public void setTimeoutTask(MsgSegmentReconstructionTimedTask timeoutTask) {
        this.timeoutTask = timeoutTask;
    }

    public XMLMessage getLastSegmentMsgRecvd() {
        return this.lastSegmentMsgRecvd;
    }

    public void setLastSegmentMsgRecvd(XMLMessage lastSegmentMsgRecvd) {
        this.lastSegmentMsgRecvd = lastSegmentMsgRecvd;
    }

    public boolean isTimeoutNotification() {
        return this.timeoutNotification;
    }

    public void setTimeoutNotification(boolean timeoutNotification) {
        this.timeoutNotification = timeoutNotification;
    }

    public void setFlowCreationTimeoutTask(SegmentFlowCreationTimedTask handler) {
        this.flowCreationTimeoutTask = handler;
    }

    public SegmentFlowCreationTimedTask getFlowCreationTimeoutTask() {
        return this.flowCreationTimeoutTask;
    }

    public int getLastSegId() {
        return this.lastSegId;
    }

    public void setLastSegId(int lastSegId) {
        this.lastSegId = lastSegId;
    }

    public int getXmlContentLen() {
        return this.xmlContentLen;
    }
}

