/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf;

import com.solacesystems.common.util.SolByteBuffer;
import java.io.EOFException;
import java.util.LinkedList;
import java.util.List;

public class AssuredCtrlHeaderParameters {
    public static final int PARAM_PADDING = 0;
    public static final int PARAM_LAST_MSGID_SENT = 1;
    public static final int PARAM_LAST_MSGID_ACKED = 2;
    public static final int PARAM_WINDOW_SIZE = 3;
    public static final int PARAM_APPLICATION_ACK = 5;
    public static final int PARAM_FLOW_ID = 6;
    public static final int PARAM_QUEUE_NAME = 7;
    public static final int PARAM_DURABLETOPICENDPOINT_NAME = 8;
    public static final int PARAM_TOPIC_NAME = 9;
    public static final int PARAM_FLOWNAME = 10;
    public static final int PARAM_DURABILITY = 11;
    public static final int PARAM_ACCESS_TYPE = 12;
    public static final int PARAM_MESSAGE_SELECTOR = 13;
    public static final int PARAM_TRANSPORT_WINDOW_SIZE = 14;
    public static final int PARAM_UNBIND_LINGER = 15;
    public static final int PARAM_LAST_MSGID_RECVED = 16;
    public static final int PARAM_ALL_OTHERS_PERMISSIONS = 17;
    public static final int PARAM_FLOW_TYPE = 18;
    public static final int PARAM_ENDPOINT_QUOTA_MB = 19;
    public static final int PARAM_ENDPOINT_MAX_MESSAGE_SIZE = 20;
    public static final int PARAM_GRANTED_PERMISSIONS = 21;
    public static final int PARAM_RESPECT_TTL = 22;
    public static final int PARAM_TRANSACTION_CTRL_MESSAGE_TYPE = 23;
    public static final int PARAM_TRANSACTED_SESSION_ID = 24;
    public static final int PARAM_TRANSACTED_SESSION_NAME = 25;
    public static final int PARAM_TRANSACTION_ID = 26;
    public static final int PARAM_TRANSACTED_SESSION_STATE = 27;
    public static final int PARAM_TRANSACTION_FLOWDESC_PUBNOTIFY = 28;
    public static final int PARAM_TRANSACTION_FLOWDESC_PUBACK = 29;
    public static final int PARAM_TRANSACTION_FLOWDESC_SUBACK = 30;
    public static final int PARAM_NOLOCAL = 31;
    public static final int PARAM_ACTIVEFLOWINDICATION = 32;
    public static final int PARAM_WANTFLOWCHANGEUPDATE = 33;
    public static final int PARAM_QENDPOINTBEHAVIOUR = 34;
    public static final int PARAM_PUBLISHER_ID = 35;
    public static final int PARAM_MAX_MSG_REDELIVERY = 42;
    public static final int PARAM_XA_TRANSACTION_CTRL_MESSAGE_TYPE = 43;
    public static final int PARAM_ENDPOINT_ID = 44;
    public static final int PARAM_ACK_SEQUENCE_NUMBER = 45;
    public static final int PARAM_ACK_RECONCILE_REQUEST = 46;
    public static final int PARAM_START_OF_ACK_RECONCILE = 47;
    public static final int PARAM_REMOTE_QUEUE_TIMESTAMP = 48;
    public static final int PARAM_MAX_DELIVERED_UNACKED_MSGS_PER_FLOW = 49;
    public static final int PARAM_START_LOCATION = 51;
    public static final int PARAM_ENDPOINT_ERROR_ID = 52;
    public static final int PARAM_RETRANSMIT_REQUEST = 53;
    public static final int PARAM_SPOOLER_UNIQUE_ID = 54;
    public static final int PARAM_TRANSACTION_GET_STATE_TID = 55;
    public static final boolean[] KNOWN_PARAMS = new boolean[256];

    static {
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[0] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[1] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[2] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[3] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[5] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[6] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[7] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[8] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[9] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[10] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[11] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[12] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[13] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[14] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[15] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[16] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[17] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[18] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[19] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[20] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[21] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[22] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[23] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[24] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[25] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[26] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[27] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[28] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[29] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[30] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[31] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[32] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[33] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[34] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[35] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[43] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[44] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[49] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[51] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[52] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[54] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[53] = true;
        AssuredCtrlHeaderParameters.KNOWN_PARAMS[55] = true;
    }

    public static class ParamTransactionFDSubAck
    extends ParamSupport {
        List<SubAckTuple> _flowDescs = new LinkedList<SubAckTuple>();

        public void clear() {
            this._flowDescs.clear();
        }

        public List<SubAckTuple> getTuples() {
            return this._flowDescs;
        }

        public void addTuple(SubAckTuple t) {
            this._flowDescs.add(t);
        }

        @Override
        public byte[] valueToBytes() {
            SolByteBuffer buf = ParamTransactionFDSubAck.bufToWrite(new byte[this._flowDescs.size() * 36], 0);
            for (SubAckTuple t : this._flowDescs) {
                buf.writeUInt(t.flowId);
                buf.writeLong(t.minAck);
                buf.writeLong(t.maxAck);
                buf.writeUInt(t.msgCount);
                buf.writeLong(t.lastMessageId);
                buf.writeUInt(t.transportWinSz);
            }
            return buf.getBackingArray();
        }

        public static ParamTransactionFDSubAck fromValueBytes(byte[] val, int offset, int length) {
            assert (length % 36 == 0);
            assert (offset + length <= val.length);
            ParamTransactionFDSubAck param = new ParamTransactionFDSubAck();
            int tuples = length / 36;
            SolByteBuffer buf = ParamTransactionFDSubAck.bufToRead(val, offset);
            for (int i = 0; i < tuples; ++i) {
                try {
                    long flowId = buf.readUInt();
                    long minAck = buf.readLong();
                    long maxAck = buf.readLong();
                    int msgCount = (int)buf.readUInt();
                    long lastMessageId = buf.readLong();
                    int transportWinSz = (int)buf.readUInt();
                    param.addTuple(SubAckTuple.newTuple(flowId, minAck, maxAck, msgCount, lastMessageId, transportWinSz));
                    continue;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            return param;
        }

        public static class SubAckTuple {
            static final int SIZE = 36;
            public long flowId = 0L;
            public long minAck = 0L;
            public long maxAck = 0L;
            public int msgCount = 0;
            public long lastMessageId = 0L;
            public int transportWinSz = 0;

            public static SubAckTuple newTuple(long flowId, long minAck, long maxAck, int msgCount, long lastMessageId, int transportWinSz) {
                SubAckTuple t = new SubAckTuple();
                t.flowId = flowId;
                t.minAck = minAck;
                t.maxAck = maxAck;
                t.msgCount = msgCount;
                t.lastMessageId = lastMessageId;
                t.transportWinSz = transportWinSz;
                return t;
            }
        }
    }

    public static class ParamTransactionFDPubAck
    extends ParamSupport {
        List<PubAckTuple> _flowDescs = new LinkedList<PubAckTuple>();

        public void clear() {
            this._flowDescs.clear();
        }

        public List<PubAckTuple> getTuples() {
            return this._flowDescs;
        }

        public void addTuple(PubAckTuple t) {
            this._flowDescs.add(t);
        }

        @Override
        public byte[] valueToBytes() {
            SolByteBuffer buf = ParamTransactionFDPubAck.bufToWrite(new byte[this._flowDescs.size() * 16], 0);
            for (PubAckTuple t : this._flowDescs) {
                buf.writeUInt(t.flowId);
                buf.writeLong(t.lastMessageId);
                buf.writeUInt(t.transportWinSz);
            }
            return buf.getBackingArray();
        }

        public static ParamTransactionFDPubAck fromValueBytes(byte[] val, int offset, int length) {
            assert (length % 16 == 0);
            assert (offset + length <= val.length);
            ParamTransactionFDPubAck param = new ParamTransactionFDPubAck();
            int tuples = length / 16;
            SolByteBuffer buf = ParamTransactionFDPubAck.bufToRead(val, offset);
            for (int i = 0; i < tuples; ++i) {
                try {
                    int flowId = (int)buf.readUInt();
                    long lastMessageId = buf.readLong();
                    int transportWinSz = (int)buf.readUInt();
                    param.addTuple(PubAckTuple.newTuple(flowId, lastMessageId, transportWinSz));
                    continue;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            return param;
        }

        public static class PubAckTuple {
            static final int SIZE = 16;
            public int flowId = 0;
            public long lastMessageId = 0L;
            public int transportWinSz = 0;

            public static PubAckTuple newTuple(int flowId, long lastMessageId, int transportWinSz) {
                PubAckTuple t = new PubAckTuple();
                t.flowId = flowId;
                t.lastMessageId = lastMessageId;
                t.transportWinSz = transportWinSz;
                return t;
            }
        }
    }

    public static class ParamTransactionFDPubNotify
    extends ParamSupport {
        List<PubNotifyTuple> _flowDescs = new LinkedList<PubNotifyTuple>();

        public void clear() {
            this._flowDescs.clear();
        }

        public List<PubNotifyTuple> getTuples() {
            return this._flowDescs;
        }

        public void addTuple(PubNotifyTuple t) {
            this._flowDescs.add(t);
        }

        @Override
        public byte[] valueToBytes() {
            SolByteBuffer buf = ParamTransactionFDPubNotify.bufToWrite(new byte[this._flowDescs.size() * 16], 0);
            for (PubNotifyTuple t : this._flowDescs) {
                buf.writeUInt(t.flowId);
                buf.writeUInt(t.messageCount);
                buf.writeLong(t.lastMessageId);
            }
            return buf.getBackingArray();
        }

        public static ParamTransactionFDPubNotify fromValueBytes(byte[] val, int offset, int length) {
            assert (length % 16 == 0);
            assert (offset + length <= val.length);
            ParamTransactionFDPubNotify param = new ParamTransactionFDPubNotify();
            int tuples = length / 16;
            SolByteBuffer buf = ParamTransactionFDPubNotify.bufToRead(val, offset);
            for (int i = 0; i < tuples; ++i) {
                try {
                    long flowId = buf.readUInt();
                    int messageCount = (int)buf.readUInt();
                    long lastMessageId = buf.readLong();
                    param.addTuple(PubNotifyTuple.newTuple(flowId, messageCount, lastMessageId));
                    continue;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            return param;
        }

        public static class PubNotifyTuple {
            static final int SIZE = 16;
            public long flowId = 0L;
            public int messageCount = 0;
            public long lastMessageId = 0L;

            public static PubNotifyTuple newTuple(long flowId, int messageCount, long lastMessageId) {
                PubNotifyTuple t = new PubNotifyTuple();
                t.flowId = flowId;
                t.messageCount = messageCount;
                t.lastMessageId = lastMessageId;
                return t;
            }
        }
    }

    public static class ParamTransactionId
    extends ParamSupport {
        public long a = 0L;
        public long b = 0L;

        public static ParamTransactionId newTid(long a, long b) {
            ParamTransactionId tid = new ParamTransactionId();
            tid.a = a;
            tid.b = b;
            return tid;
        }

        @Override
        public byte[] valueToBytes() {
            SolByteBuffer buf = ParamTransactionId.bufToWrite(new byte[8], 0);
            buf.writeUInt(this.a);
            buf.writeUInt(this.b);
            return buf.getBackingArray();
        }

        public static ParamTransactionId fromValueBytes(byte[] input, int offset) {
            ParamTransactionId pti = new ParamTransactionId();
            SolByteBuffer buf = ParamTransactionId.bufToRead(input, offset);
            try {
                pti.a = buf.readInt();
                pti.b = buf.readInt();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return pti;
        }
    }

    public static abstract class ParamSupport {
        public abstract byte[] valueToBytes();

        static SolByteBuffer bufToRead(byte[] buffer, int offset) {
            return new SolByteBuffer(buffer, offset);
        }

        static SolByteBuffer bufToWrite(byte[] buffer, int offset) {
            SolByteBuffer buf = new SolByteBuffer(buffer, offset);
            buf.clear();
            return buf;
        }
    }
}

