/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms.impl;

import com.solacesystems.jcsmp.Context;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jms.RouterCapabilities;
import com.solacesystems.jms.property.JMSConnectionFactoryPropertyBean;
import com.solacesystems.jms.property.JMSProperties;
import com.solacesystems.jms.property.JMSPropertyBean;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ExceptionListener;

public class ConnectionProperties {
    private JMSProperties mProperties;
    private JMSPropertyBean mBean;
    private JMSConnectionFactoryPropertyBean mCFBean;
    private Context mContext;
    private JCSMPSession mSession;
    private RouterCapabilities mRouterCapabilities;
    private ExceptionListener mExceptionListener;
    private Map<String, Object> mUserProps;

    public ConnectionProperties(JMSProperties properties, Context context, JCSMPSession session, ExceptionListener exceptionListener) {
        this.mProperties = properties;
        this.mBean = new JMSPropertyBean(this.mProperties.getProperties().values());
        this.mCFBean = new JMSConnectionFactoryPropertyBean(this.mProperties.getProperties().values());
        this.mContext = context;
        this.mSession = session;
        this.mRouterCapabilities = new RouterCapabilities(this.mSession);
        this.mExceptionListener = exceptionListener;
        this.mUserProps = new HashMap<String, Object>();
    }

    public JMSProperties getProperties() {
        return this.mProperties;
    }

    public JMSPropertyBean getPropertyBean() {
        return this.mBean;
    }

    public JMSConnectionFactoryPropertyBean getCFPropertyBean() {
        return this.mCFBean;
    }

    public Context getContext() {
        return this.mContext;
    }

    public JCSMPSession getJCSMPSession() {
        return this.mSession;
    }

    public RouterCapabilities getRouterCapabilities() {
        return this.mRouterCapabilities;
    }

    public ExceptionListener getExceptionListener() {
        return this.mExceptionListener;
    }

    public Map<String, Object> getUserProperties() {
        return this.mUserProps;
    }
}

