/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.flow;

import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.SubscriptionMap;
import com.solacesystems.jcsmp.impl.SubscriptionMatchEntry;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.statistics.StatType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SharedSubscriptionManager {
    private static final Log Trace = LogFactory.getLog(SharedSubscriptionManager.class);
    private HashMap<String, SubscriptionMap<FlowHandleImpl>> mSharedSubscriptions = new HashMap();
    private SubscriptionMap<FlowHandleImpl> mNoExportSubscriptions = null;
    final JCSMPBasicSession mSession;
    public static final String SHARED_SUBSCRIPTION_PRIFIX = "#share/";
    public static final String NOEXPORT_SHARED_SUBSCRIPTION_PRIFIX = "#noexport/#share/";
    public static final String NOEXPORT_PRIFIX = "#noexport/";

    public static boolean isNoExportSubcription(String subscription) {
        if (subscription.startsWith(NOEXPORT_PRIFIX)) {
            String[] levels = subscription.split("/", 2);
            return levels.length > 1;
        }
        return false;
    }

    public static boolean isSharedSubcription(String subscription) {
        if (subscription.startsWith(SHARED_SUBSCRIPTION_PRIFIX)) {
            String[] levels = subscription.split("/", 3);
            return levels.length > 2;
        }
        if (subscription.startsWith(NOEXPORT_SHARED_SUBSCRIPTION_PRIFIX)) {
            String[] levels = subscription.split("/", 4);
            return levels.length > 3;
        }
        return false;
    }

    public static boolean isSharedOrNoExportSubscription(String subscription) {
        return SharedSubscriptionManager.isSharedSubcription(subscription) || SharedSubscriptionManager.isNoExportSubcription(subscription);
    }

    public SharedSubscriptionManager(JCSMPBasicSession session) {
        this.mSession = session;
    }

    public synchronized SubscriptionMap<FlowHandleImpl> getSubscriptionMap(String subscription) {
        if (SharedSubscriptionManager.isSharedSubcription(subscription)) {
            String group = this.getSharedSubcriptionGroup(subscription);
            SubscriptionMap<FlowHandleImpl> map = this.mSharedSubscriptions.get(group);
            if (map == null) {
                map = new SubscriptionMap();
                this.mSharedSubscriptions.put(group, map);
            }
            return map;
        }
        if (this.mNoExportSubscriptions == null) {
            this.mNoExportSubscriptions = new SubscriptionMap();
        }
        return this.mNoExportSubscriptions;
    }

    public boolean isSharedOrNoExportSubscriptionEmpty() {
        return this.mNoExportSubscriptions == null && this.mSharedSubscriptions.size() == 0;
    }

    private String getSharedSubcriptionTopic(String subscription) {
        String[] levels;
        if (subscription.startsWith(SHARED_SUBSCRIPTION_PRIFIX)) {
            String[] levels2 = null;
            levels2 = subscription.split("/", 3);
            if (levels2.length > 2) {
                return levels2[2];
            }
        } else if (subscription.contains(NOEXPORT_SHARED_SUBSCRIPTION_PRIFIX) && (levels = subscription.split("/", 4)).length > 3) {
            return levels[3];
        }
        return null;
    }

    private String getSharedSubcriptionGroup(String subscription) {
        String[] levels;
        if (subscription.startsWith(SHARED_SUBSCRIPTION_PRIFIX)) {
            String[] levels2 = subscription.split("/", 3);
            if (levels2.length > 2) {
                return levels2[1];
            }
        } else if (subscription.contains(NOEXPORT_SHARED_SUBSCRIPTION_PRIFIX) && (levels = subscription.split("/", 4)).length > 3) {
            return levels[2];
        }
        return null;
    }

    private String getNoExportSubcriptionTopic(String subscription) {
        String[] levels;
        if (subscription.startsWith(NOEXPORT_PRIFIX) && (levels = subscription.split("/", 2)).length > 1) {
            return levels[1];
        }
        return null;
    }

    public String getShareOrNoExportSubscription(String subscription) {
        if (SharedSubscriptionManager.isSharedSubcription(subscription)) {
            return this.getSharedSubcriptionTopic(subscription);
        }
        if (SharedSubscriptionManager.isNoExportSubcription(subscription)) {
            return this.getNoExportSubcriptionTopic(subscription);
        }
        return null;
    }

    public boolean processMessage(JCSMPXMLMessage msg) {
        ArrayList entries = new ArrayList();
        boolean found = false;
        byte[] destination = msg.getDestinationReceivedBytes();
        Random rand = new Random();
        boolean res = true;
        msg.setReadOnly();
        if (this.mNoExportSubscriptions != null) {
            this.mNoExportSubscriptions.get(destination, entries);
            if (entries.size() != 0) {
                found = true;
                for (int i = 0; i < entries.size(); ++i) {
                    SubscriptionMatchEntry entry = entries.get(i);
                    Iterator it = entry.getEntries().iterator();
                    while (it.hasNext()) {
                        res = ((FlowHandleImpl)it.next()).processMessage(msg);
                        if (res) continue;
                        Trace.info((Object)"FlowHandle received incoming message (flow stopped or duplicate received), ignoring.");
                        this.mSession.getSessionStats().incStat(StatType.MESSAGES_DISCARDED_INTERNAL);
                    }
                }
            }
        }
        Iterator<Map.Entry<String, SubscriptionMap<FlowHandleImpl>>> it = this.mSharedSubscriptions.entrySet().iterator();
        while (it.hasNext()) {
            SubscriptionMap<FlowHandleImpl> map = it.next().getValue();
            entries.clear();
            map.get(destination, entries);
            if (entries.size() <= 0) continue;
            found = true;
            for (int i = 0; i < entries.size(); ++i) {
                int ix;
                SubscriptionMatchEntry entry = entries.get(i);
                List list = entry.getEntries();
                if (list.size() <= 0 || (res = ((FlowHandleImpl)list.get(ix = rand.nextInt(list.size() + 1000) % list.size())).processMessage(msg))) continue;
                Trace.info((Object)"FlowHandle received incoming message (flow stopped or duplicate received), ignoring.");
                this.mSession.getSessionStats().incStat(StatType.MESSAGES_DISCARDED_INTERNAL);
            }
        }
        return found;
    }
}

