/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction;

import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionSteps {
    final boolean extended;
    final HashMap<FlowHandleImpl, InputFlowInfo> inputflows;
    final HashMap<JCSMPXMLMessageProducer, OutputFlowInfo> outputflows;
    private final Log Trace = LogFactory.getLog(TransactionSteps.class);

    public TransactionSteps() {
        this(false);
    }

    public TransactionSteps(boolean extended) {
        this.extended = extended;
        this.inputflows = new HashMap();
        this.outputflows = new HashMap();
    }

    private InputFlowInfo createInputFlowInfo() {
        if (this.extended) {
            return new InputFlowExtendedInfo();
        }
        return new InputFlowInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInputStep(FlowHandleImpl fh, long msgId, long ackMsgId) {
        HashMap<FlowHandleImpl, InputFlowInfo> hashMap = this.inputflows;
        synchronized (hashMap) {
            InputFlowInfo fi = this.inputflows.get(fh);
            if (fi == null) {
                if (this.outputflows.size() < 65535) {
                    fi = this.createInputFlowInfo();
                    this.inputflows.put(fh, fi);
                } else {
                    throw new IllegalStateException("# flows per transaction over limit!");
                }
            }
            if (fi.messageCount >= 65535) {
                throw new IllegalStateException("# messages per flow per transaction over limit!");
            }
            fi.update(msgId, ackMsgId);
            if (this.Trace.isDebugEnabled()) {
                this.Trace.debug((Object)String.format("Flow %d: add message (%d,%d) to inputStep", fh.getFlowId(), msgId, ackMsgId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxAck(FlowHandleImpl fh) {
        HashMap<FlowHandleImpl, InputFlowInfo> hashMap = this.inputflows;
        synchronized (hashMap) {
            InputFlowInfo fi = this.inputflows.get(fh);
            if (fi != null) {
                return fi.maxAck;
            }
            return 0L;
        }
    }

    private OutputFlowInfo createOutputFlowInfo() {
        if (this.extended) {
            return new OutputFlowExtendedInfo();
        }
        return new OutputFlowInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputStep(JCSMPXMLMessageProducer prod, JCSMPXMLMessage msg) {
        HashMap<JCSMPXMLMessageProducer, OutputFlowInfo> hashMap = this.outputflows;
        synchronized (hashMap) {
            OutputFlowInfo fi = this.outputflows.get(prod);
            if (fi == null) {
                fi = this.createOutputFlowInfo();
                this.outputflows.put(prod, fi);
            }
            if (prod.getTransactedSession().isTransportAckExpected()) {
                fi.updateBaseClass(msg);
            } else {
                fi.update(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HashMap<FlowHandleImpl, InputFlowInfo> hashMap = this.inputflows;
        synchronized (hashMap) {
            HashMap<JCSMPXMLMessageProducer, OutputFlowInfo> hashMap2 = this.outputflows;
            synchronized (hashMap2) {
                if (this.Trace.isDebugEnabled()) {
                    this.Trace.debug((Object)String.format("Entering reset(): inputFlows %d, outFlows %d", this.inputflows.size(), this.outputflows.size()));
                }
                this.inputflows.clear();
                for (OutputFlowInfo info : this.outputflows.values()) {
                    info.reset();
                }
                this.outputflows.clear();
            }
        }
    }

    public void reset(TransactionSteps subset) {
        Map<FlowHandleImpl, InputFlowInfo> inputSubset = subset.getInputSteps();
        Map<FlowHandleImpl, InputFlowInfo> input = this.getInputSteps();
        int entries = 0;
        for (Map.Entry<FlowHandleImpl, InputFlowInfo> entry : inputSubset.entrySet()) {
            InputFlowInfo infoSubset = entry.getValue();
            if (!(infoSubset instanceof InputFlowExtendedInfo)) continue;
            InputFlowExtendedInfo exInfoSubset = (InputFlowExtendedInfo)infoSubset;
            InputFlowExtendedInfo myExInfo = (InputFlowExtendedInfo)input.get(entry.getKey());
            if (myExInfo != null) {
                myExInfo.received.removeAll(exInfoSubset.received);
                continue;
            }
            ++entries;
        }
        if (entries > 0 && this.Trace.isInfoEnabled()) {
            this.Trace.info((Object)String.format("reset: found %d entries in the input step map with null InputFlowInfo", entries));
        }
    }

    public Map<FlowHandleImpl, InputFlowInfo> getInputSteps() {
        return this.inputflows;
    }

    public Map<JCSMPXMLMessageProducer, OutputFlowInfo> getOutputSteps() {
        return this.outputflows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<JCSMPXMLMessageProducer, OutputFlowInfo> getOutputStepsCopy() {
        HashMap<JCSMPXMLMessageProducer, OutputFlowInfo> hashMap = this.outputflows;
        synchronized (hashMap) {
            HashMap<JCSMPXMLMessageProducer, OutputFlowInfo> copy = new HashMap<JCSMPXMLMessageProducer, OutputFlowInfo>();
            for (JCSMPXMLMessageProducer producer : this.outputflows.keySet()) {
                OutputFlowExtendedInfo info = (OutputFlowExtendedInfo)this.outputflows.get(producer);
                copy.put(producer, new OutputFlowExtendedInfo(info));
            }
            return copy;
        }
    }

    public static class OutputFlowExtendedInfo
    extends OutputFlowInfo {
        public ArrayList<JCSMPXMLMessage> msgs = null;

        public OutputFlowExtendedInfo() {
            this.msgs = null;
        }

        public OutputFlowExtendedInfo(OutputFlowExtendedInfo copy) {
            super(copy);
            if (copy.msgs == null) {
                this.msgs = null;
            } else {
                this.msgs = new ArrayList();
                this.msgs.addAll(copy.msgs);
            }
        }

        @Override
        public void update(JCSMPXMLMessage msg) {
            super.update(msg);
            if (this.msgs == null) {
                this.msgs = new ArrayList();
            }
            this.msgs.add(msg);
        }

        @Override
        public void reset() {
            if (this.msgs != null) {
                for (JCSMPXMLMessage msg : this.msgs) {
                    if (msg.getMsgPool() == null) continue;
                    msg.returnMessageToPool();
                }
                this.msgs.clear();
            }
        }
    }

    public static class OutputFlowInfo {
        public int messageCount = 0;
        public long lastMsgId = 0L;
        private boolean rollbackOnly = false;

        protected boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        protected void setRollbackOnly(boolean s) {
            this.rollbackOnly = s;
        }

        public OutputFlowInfo() {
            this.messageCount = 0;
            this.lastMsgId = 0L;
        }

        public OutputFlowInfo(OutputFlowInfo copy) {
            this.messageCount = copy.messageCount;
            this.lastMsgId = copy.lastMsgId;
        }

        public void update(JCSMPXMLMessage msg) {
            this.updateBaseClass(msg);
        }

        public void reset() {
            this.messageCount = 0;
            this.lastMsgId = 0L;
        }

        public final void updateBaseClass(JCSMPXMLMessage msg) {
            long msgId = msg.getMessageIdLong();
            assert (msgId > this.lastMsgId) : "MsgId must be greater than last recorded.";
            ++this.messageCount;
            this.lastMsgId = msgId;
        }
    }

    public static class InputFlowExtendedInfo
    extends InputFlowInfo {
        private final Set<Long> received = InputFlowExtendedInfo.newSetFromMap(new ConcurrentHashMap());

        public boolean exists(long ackMsgId) {
            return this.received.contains(ackMsgId);
        }

        @Override
        public void update(long msgId, long ackMsgId) {
            super.update(msgId, ackMsgId);
            this.received.add(ackMsgId);
        }

        public Long[] getReceivedIds(boolean sort) {
            Object[] arr = this.received.toArray(new Long[0]);
            if (sort) {
                Arrays.sort(arr);
            }
            return arr;
        }

        public int size() {
            return this.received.size();
        }

        private static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
            return new SetFromMap<E>(map);
        }

        private static class SetFromMap<E>
        extends AbstractSet<E>
        implements Set<E> {
            private final Map<E, Boolean> m;
            private Set<E> s;

            SetFromMap(Map<E, Boolean> map) {
                if (!map.isEmpty()) {
                    throw new IllegalArgumentException("Map is non-empty");
                }
                this.m = map;
                this.s = map.keySet();
            }

            @Override
            public void clear() {
                this.m.clear();
            }

            @Override
            public int size() {
                return this.m.size();
            }

            @Override
            public boolean isEmpty() {
                return this.m.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.m.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                return this.m.remove(o) != null;
            }

            @Override
            public boolean add(E e) {
                return this.m.put(e, Boolean.TRUE) == null;
            }

            @Override
            public Iterator<E> iterator() {
                return this.s.iterator();
            }

            @Override
            public Object[] toArray() {
                return this.s.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return this.s.toArray(a);
            }

            @Override
            public String toString() {
                return this.s.toString();
            }

            @Override
            public int hashCode() {
                return this.s.hashCode();
            }

            @Override
            public boolean equals(Object o) {
                return o == this || this.s.equals(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.s.containsAll(c);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return this.s.removeAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return this.s.retainAll(c);
            }
        }
    }

    public static class InputFlowInfo {
        public long minAck = 0L;
        public long maxAck = 0L;
        public int messageCount = 0;
        private boolean rollbackOnly = false;

        protected boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        protected void setRollbackOnly(boolean s) {
            this.rollbackOnly = s;
        }

        public void update(long msgId, long ackMsgId) {
            if (msgId >= this.minAck) {
                if (this.minAck == 0L) {
                    this.minAck = msgId;
                }
                this.maxAck = msgId;
            }
            ++this.messageCount;
        }
    }
}

