/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.SDTEOFException;
import com.solacesystems.jcsmp.TextMessage;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessage;
import com.solacesystems.jcsmp.impl.MessageImpl;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextMessageImpl
extends MessageImpl
implements TextMessage {
    private static final Log Trace = LogFactory.getLog(TextMessageImpl.class);
    protected String mText;

    public TextMessageImpl(BytesXMLMessage message) {
        super(message);
        ((JCSMPXMLMessage)((Object)message)).setStructuredMsg(true);
        ((JCSMPXMLMessage)((Object)message)).setStructuredMsgType((byte)7);
        this.mText = null;
    }

    @Override
    public synchronized String getText() {
        block7: {
            if (this.mText == null && this.mMessage.hasAttachment()) {
                int size = this.mMessage.getAttachmentContentLength();
                byte[] attach = new byte[size];
                this.mMessage.readAttachmentBytes(attach);
                TLVBuffer buffer = new TLVBuffer(attach);
                try {
                    Object obj = buffer.read();
                    if (obj instanceof String) {
                        return (String)obj;
                    }
                    if (Trace.isWarnEnabled()) {
                        if (obj == null) {
                            Trace.warn((Object)"error reading text from binary attachment - null");
                        } else {
                            Trace.warn((Object)String.format("error reading text from binary attachment, expecting a String, received a %s (%s)", obj.getClass().getSimpleName(), obj.toString()));
                        }
                    }
                }
                catch (SDTEOFException e) {
                    if (!Trace.isWarnEnabled()) break block7;
                    Trace.warn((Object)"end of data reading text from binary attachment");
                }
            }
        }
        return this.mText;
    }

    @Override
    public synchronized void setText(String text) {
        if (text != null) {
            TLVBuffer buffer = new TLVBuffer(text.length());
            buffer.write(text);
            ByteArray ba = buffer.asByteArray();
            this.mMessage.writeAttachment(ba.getBuffer(), ba.getOffset(), ba.getLength());
        }
        this.mText = text;
    }

    @Override
    public void reset() {
        super.reset();
        this.setText(null);
    }
}

