/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jms.SolConnectionIF;
import com.solacesystems.jms.SolSession;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.SolTopicPublisher;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.TemporaryQueue;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolTopicSession
extends SolSession
implements TopicSession {
    private static final Log log = LogFactory.getLog(SolTopicSession.class);
    private static final String Component = "TopicSession";

    public SolTopicSession(SolConnectionIF connection, boolean transacted, int acknowledgeMode, JMSState state) throws JMSException {
        super(connection, transacted, acknowledgeMode, state);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SolTopicSession created. Transacted: " + transacted + "  acknowledgeMode: " + acknowledgeMode + " State: " + (Object)((Object)state)));
        }
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering createPublisher.  Topic: " + (topic == null ? "null" : topic.getTopicName())));
        }
        Validator.checkClosed(this.mState, Component);
        Validator.checkProducerDestination(this.mSessionProps.getConnectionProperties().getRouterCapabilities().crMode(), (Destination)topic);
        SolTopicPublisher publisher = new SolTopicPublisher((SolSessionIF)this, topic);
        this.mProducers.add(publisher);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving createPublisher");
        }
        return publisher;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return (TopicSubscriber)super.createConsumer((Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)super.createConsumer((Destination)topic, messageSelector, noLocal);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.queue.browser", "soljms.error.illegalstate", "createBrowser()"), "soljms.error.illegalstate");
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.queue.browser", "soljms.error.illegalstate", "createBrowser()"), "soljms.error.illegalstate");
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.queue.create", "soljms.error.illegalstate", "createQueue()"), "soljms.error.illegalstate");
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new IllegalStateException(SolJMSErrorMessages.getMessage("soljms.operation.queue.create", "soljms.error.illegalstate", "createTemporaryQueue()"), "soljms.error.illegalstate");
    }
}

