/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp;

import com.solacesystems.common.SolReserved;
import com.solacesystems.jcsmp.JCSMPErrorResponseSubcode;
import com.solacesystems.jcsmp.JCSMPOperationException;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;

public class JCSMPErrorResponseException
extends JCSMPOperationException {
    static final long serialVersionUID = 1L;
    private int responseCode;
    private String responsePhrase;
    private String responseBody;
    private String connectionInfoStr;
    private JCSMPErrorResponseSubcodeMapper.ErrorContext econtext;

    public JCSMPErrorResponseException(int responseCode, String responsePhrase, String responseBody, String connectionInfoStr) {
        super(responseCode + ": " + responsePhrase);
        this.responseCode = responseCode;
        this.responsePhrase = responsePhrase;
        this.responseBody = responseBody;
        this.connectionInfoStr = connectionInfoStr;
        this.econtext = null;
    }

    @SolReserved
    public JCSMPErrorResponseException(int responseCode, String responsePhrase, String responseBody, String connectionInfoStr, JCSMPErrorResponseSubcodeMapper.ErrorContext ctx) {
        this(responseCode, responsePhrase, responseBody, connectionInfoStr);
        this.econtext = ctx;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponsePhrase() {
        return this.responsePhrase;
    }

    public String getConnectionInfoString() {
        return this.connectionInfoStr;
    }

    @Deprecated
    public JCSMPErrorResponseSubcode getSubcode() {
        return JCSMPErrorResponseSubcodeMapper.map(this.econtext, this.responseCode, this.responsePhrase);
    }

    public int getSubcodeEx() {
        return JCSMPErrorResponseSubcodeMapper.mapEx(this.econtext, this.responseCode, this.responsePhrase);
    }

    public String toString() {
        int subcode = this.getSubcodeEx();
        String strSubcode = subcode != 0 ? " [Subcode:" + subcode + "]" : "";
        return "(" + this.getConnectionInfoString() + ")  " + super.toString() + strSubcode;
    }
}

