/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jms;

import com.solacesystems.jcsmp.Browser;
import com.solacesystems.jcsmp.BrowserProperties;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jms.ConfigurationException;
import com.solacesystems.jms.SolDestination;
import com.solacesystems.jms.SolQueueBrowserEnumeration;
import com.solacesystems.jms.SolQueueBrowserIF;
import com.solacesystems.jms.SolSessionIF;
import com.solacesystems.jms.impl.JMSState;
import com.solacesystems.jms.impl.SolJMSErrorMessages;
import com.solacesystems.jms.impl.Validator;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolQueueBrowser
implements SolQueueBrowserIF {
    private static final Log log = LogFactory.getLog(SolQueueBrowser.class);
    protected static final String Component = "QueueBrowser";
    protected SolSessionIF mSession;
    private javax.jms.Queue mQueue;
    private String mMessageSelector;
    private JMSState mState;
    private SolQueueBrowserEnumeration mEnumeration;
    private Browser mBrowser;
    private int mTimeout;

    public SolQueueBrowser(SolSessionIF session, javax.jms.Queue queue, String messageSelector) throws JMSException {
        this.mSession = session;
        this.mQueue = queue;
        this.mMessageSelector = messageSelector;
        this.mState = JMSState.Started;
        this.mEnumeration = null;
        this.mTimeout = session.getProperties().getConnectionProperties().getPropertyBean().getBrowserTimeoutInMS();
        this.createJCSMPBrowser();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SolQueueBrowser created.  Queue: " + (queue == null ? "null" : queue.getQueueName()) + "   messageSelector: " + messageSelector));
        }
    }

    @Override
    public int getTimeout() {
        return this.mTimeout;
    }

    @Override
    public void close() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"D close().");
        }
        this.mBrowser.close();
        this.mSession.remove(this);
        this.mState = JMSState.Closed;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving close().  SolQueueBrowser closed.");
        }
    }

    public Enumeration<?> getEnumeration() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        if (this.mEnumeration == null) {
            this.mEnumeration = new SolQueueBrowserEnumeration(this);
        }
        return this.mEnumeration;
    }

    public String getMessageSelector() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mMessageSelector;
    }

    public javax.jms.Queue getQueue() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mQueue;
    }

    @Override
    public Browser getJCSMPBrowser() throws JMSException {
        Validator.checkClosed(this.mState, Component);
        return this.mBrowser;
    }

    private void createJCSMPBrowser() throws JMSException {
        if (this.mQueue instanceof TemporaryQueue && this.mSession.getProperties().getConnectionProperties().getPropertyBean().getDirectTransport().booleanValue()) {
            throw new ConfigurationException(SolJMSErrorMessages.getMessage("soljms.operation.queue.browser", "soljms.error.browserdirectmismatch", null), "soljms.error.browserdirectmismatch");
        }
        BrowserProperties browserProps = new BrowserProperties();
        Queue jcsmpQueue = (Queue)((SolDestination)this.mQueue).getJCSMPDestination();
        browserProps.setEndpoint(jcsmpQueue);
        browserProps.setSelector(Validator.checkSelector(this.mMessageSelector));
        if (this.mSession.getProperties().getConnectionProperties().getPropertyBean().isSetReceiveADWindowSize()) {
            browserProps.setTransportWindowSize(this.mSession.getProperties().getConnectionProperties().getPropertyBean().getReceiveADWindowSize());
        }
        if (this.mSession.getProperties().getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetries()) {
            browserProps.setReconnectTries(this.mSession.getProperties().getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetries());
        }
        if (this.mSession.getProperties().getConnectionProperties().getCFPropertyBean().isSetReceiveReconnectRetryWaitInMillis()) {
            browserProps.setReconnectRetryIntervalInMsecs(this.mSession.getProperties().getConnectionProperties().getCFPropertyBean().getReceiveReconnectRetryWaitInMillis());
        }
        try {
            this.mBrowser = this.mSession.getProperties().getConnectionProperties().getJCSMPSession().createBrowser(browserProps);
        }
        catch (Exception e) {
            throw Validator.createJMSException("soljms.operation.queue.browser", e);
        }
    }
}

