/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.nio.impl;

import com.solacesystems.jcsmp.protocol.nio.impl.ReadBufferWrapper;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanningBufferReader {
    private final List<ReadBufferWrapper> bufs;
    private int readPointer = 0;

    public SpanningBufferReader(List<ReadBufferWrapper> input) {
        this.bufs = input;
    }

    public int getTotalSize() {
        int sz = 0;
        for (ReadBufferWrapper w : this.bufs) {
            sz += w.getBufferLimit();
        }
        return sz;
    }

    public int read(ByteBuffer dest, int length) {
        int toSkip = this.readPointer;
        int bytesToRead = length;
        int bytesRead = 0;
        Iterator<ReadBufferWrapper> it = this.bufs.iterator();
        while (it.hasNext() && bytesToRead > 0) {
            ReadBufferWrapper rbw = it.next();
            if (toSkip >= rbw.getBufferLimit()) {
                toSkip -= rbw.getBufferLimit();
                continue;
            }
            int srcOffset = toSkip;
            toSkip = 0;
            byte[] dataSrc = rbw.getBuffer();
            int dataLimit = rbw.getBufferLimit() - srcOffset;
            int toRead = Math.min(bytesToRead, dataLimit);
            dest.put(dataSrc, srcOffset, toRead);
            bytesToRead -= toRead;
            bytesRead += toRead;
            this.readPointer += toRead;
        }
        return bytesRead;
    }

    public void rewind() {
        this.readPointer = 0;
    }
}

