/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.transaction.xa;

import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.common.xa.SolXid;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.InvalidMessageReceivedException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.XAWireMessageEncoder;
import com.solacesystems.jcsmp.impl.timers.JCSMPTimeoutHandler;
import com.solacesystems.jcsmp.impl.transaction.TimerSetter;
import com.solacesystems.jcsmp.impl.transaction.xa.XARecoverResponseParam;
import com.solacesystems.jcsmp.impl.transaction.xa.XAResponseCodes;
import com.solacesystems.jcsmp.impl.transaction.xa.XAResponseParam;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionImpl;
import com.solacesystems.jcsmp.impl.transaction.xa.XASessionManager;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SmfTLVParameter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.concurrent.ArrayBlockingQueue;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XAResourceImpl
implements XAResource {
    private static final Log Trace = LogFactory.getLog(XAResourceImpl.class);
    private static final int ROLLBACK_FLAG = -1;
    private XASessionImpl _xaSession;
    private int _transactionTimeout;
    private Xid _activeXid;
    private Object _lock;
    private String _outstandingMessageLog;
    private XAWireMessageEncoder _request;
    private ArrayBlockingQueue<Object> _responseQueue;
    public TimerSetter _responseTimerSetter;
    private boolean _scanStarted;
    private boolean _activeXidBeforeUnknownSessionNameFailure;
    private boolean _requestSentBeforeUnknownSessionNameFailure;
    private boolean _rebuildRequestMsgRequired;
    private boolean _rollbackEndRequest;

    public XAResourceImpl(XASessionImpl xaSession) {
        this._xaSession = xaSession;
        this._transactionTimeout = 0;
        this._activeXid = null;
        this._activeXidBeforeUnknownSessionNameFailure = false;
        this._requestSentBeforeUnknownSessionNameFailure = false;
        this._rebuildRequestMsgRequired = false;
        this._lock = new Object();
        this._request = null;
        this._responseQueue = new ArrayBlockingQueue(10);
        this._responseTimerSetter = new TimerSetter(xaSession.getXASessionManager().getJCSMPSession().getContext().getIOReactor(), xaSession.getResponseTimeout(), null);
        this._scanStarted = false;
        this._rollbackEndRequest = false;
    }

    public void close(Exception e) {
        this._responseQueue.add((Object)new ClosedFacilityException("XASession Closed", e));
    }

    public boolean hasAssociatedXid() {
        return this._activeXid != null;
    }

    public boolean isActiveXidRollbackPending() {
        return this._activeXid != null && this._activeXidBeforeUnknownSessionNameFailure;
    }

    public void notifyUnknownSessionName() {
        if (this._activeXid != null) {
            this._activeXidBeforeUnknownSessionNameFailure = true;
        }
        if (this._request != null) {
            this._requestSentBeforeUnknownSessionNameFailure = true;
        }
    }

    public void setRebuildRequestMsgRequired(boolean required) {
        this._rebuildRequestMsgRequired = required;
    }

    public boolean noOutStandingRequest() {
        return this._request == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        this._xaSession.checkClosedXA();
        this._xaSession.checkContext();
        String logMessage = String.format("XA Commit (XaSession[id=%s, name=%s], Xid=%s, onePhase=%s)", String.valueOf(this._xaSession.getTransactedSessionId()), this._xaSession.getName(), xid.toString(), String.valueOf(onePhase));
        XASessionManager xaSessionMgr = this._xaSession.getXASessionManager();
        long corrId = xaSessionMgr.getSubChannel().getGeneralSeqAllocator().getNext24b();
        byte flags = 0;
        if (onePhase) {
            flags = 1;
        }
        XAWireMessageEncoder enc = new XAWireMessageEncoder(AssuredCtrlEnums.XACtrlMessageType.XA_COMMIT_REQUEST, this._xaSession, corrId, xid, 0, flags, 0, null, null);
        WireMessage wireMsg = enc.encode();
        wireMsg.encoder = enc;
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("Created ADCTRL TransactionCtrl XACommit Request", new Object[0]));
        }
        try {
            xaSessionMgr.addActiveTransaction(corrId, this._xaSession);
            this.setOutgoingMessage(enc, logMessage);
            this.sendRequest(xaSessionMgr, wireMsg, corrId, null, logMessage, AssuredCtrlEnums.XACtrlMessageType.XA_COMMIT_REQUEST);
        }
        finally {
            xaSessionMgr.removeActiveTransaction(corrId);
            this.unsetOutgoingMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void end(Xid xid, int flags) throws XAException {
        this._xaSession.checkClosedXA();
        this._xaSession.checkContext();
        String logMessage = String.format("XA End (XaSession[id=%s, name=%s], Xid=%s, flags=%s)", String.valueOf(this._xaSession.getTransactedSessionId()), this._xaSession.getName(), xid.toString(), this.getFlagsString(flags));
        if (flags != 0x4000000 && flags != 0x20000000 && flags != 0x2000000 && flags != -1) {
            if (Trace.isWarnEnabled()) {
                Trace.warn((Object)String.format("Illegal flag in - %s, expecting one of [XAResource.TMSUCCESS, XAResource.TMFAIL, XAResource.TMSUSPEND]", logMessage));
            }
            throw new XAException(-5);
        }
        XASessionManager xaSessionMgr = this._xaSession.getXASessionManager();
        long corrId = xaSessionMgr.getSubChannel().getGeneralSeqAllocator().getNext24b();
        byte outFlags = 0;
        this._rollbackEndRequest = this._xaSession.hasUnboundSubFlows();
        if (this.isActiveXidRollbackPending() || this._rollbackEndRequest || flags == -1) {
            outFlags = 4;
        } else if (flags == 0x20000000) {
            outFlags = 2;
        } else if (flags == 0x2000000) {
            outFlags = 1;
        }
        XAWireMessageEncoder enc = new XAWireMessageEncoder(AssuredCtrlEnums.XACtrlMessageType.XA_END_REQUEST, this._xaSession, corrId, xid, flags, outFlags, 0, this._xaSession.getTransactionSteps(), null);
        WireMessage wireMsg = enc.encode();
        wireMsg.encoder = enc;
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("Created ADCTRL TransactionCtrl XAEnd Request", new Object[0]));
        }
        try {
            xaSessionMgr.addActiveTransaction(corrId, this._xaSession);
            this.setOutgoingMessage(enc, logMessage);
            this.sendRequest(xaSessionMgr, wireMsg, corrId, null, logMessage, AssuredCtrlEnums.XACtrlMessageType.XA_END_REQUEST);
        }
        finally {
            xaSessionMgr.removeActiveTransaction(corrId);
            this.unsetOutgoingMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forget(Xid xid) throws XAException {
        this._xaSession.checkClosedXA();
        this._xaSession.checkContext();
        String logMessage = String.format("XA Forget (XaSession[id=%s, name=%s], Xid=%s)", String.valueOf(this._xaSession.getTransactedSessionId()), this._xaSession.getName(), xid.toString());
        XASessionManager xaSessionMgr = this._xaSession.getXASessionManager();
        long corrId = xaSessionMgr.getSubChannel().getGeneralSeqAllocator().getNext24b();
        XAWireMessageEncoder enc = new XAWireMessageEncoder(AssuredCtrlEnums.XACtrlMessageType.XA_FORGET_REQUEST, this._xaSession, corrId, xid, 0, 0, 0, null, null);
        WireMessage wireMsg = enc.encode();
        wireMsg.encoder = enc;
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("Created ADCTRL TransactionCtrl XAForget Request", new Object[0]));
        }
        try {
            xaSessionMgr.addActiveTransaction(corrId, this._xaSession);
            this.setOutgoingMessage(enc, logMessage);
            this.sendRequest(xaSessionMgr, wireMsg, corrId, null, logMessage, AssuredCtrlEnums.XACtrlMessageType.XA_FORGET_REQUEST);
        }
        finally {
            xaSessionMgr.removeActiveTransaction(corrId);
            this.unsetOutgoingMessage();
        }
    }

    public synchronized int getTransactionTimeout() throws XAException {
        this._xaSession.checkClosedXA();
        return this._transactionTimeout;
    }

    public synchronized boolean isSameRM(XAResource xares) throws XAException {
        this._xaSession.checkClosedXA();
        return this == xares;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int prepare(Xid xid) throws XAException {
        this._xaSession.checkClosedXA();
        this._xaSession.checkContext();
        String logMessage = String.format("XA Prepare (XaSession[id=%s, name=%s], Xid=%s)", String.valueOf(this._xaSession.getTransactedSessionId()), this._xaSession.getName(), xid.toString());
        XASessionManager xaSessionMgr = this._xaSession.getXASessionManager();
        long corrId = xaSessionMgr.getSubChannel().getGeneralSeqAllocator().getNext24b();
        XAWireMessageEncoder enc = new XAWireMessageEncoder(AssuredCtrlEnums.XACtrlMessageType.XA_PREPARE_REQUEST, this._xaSession, corrId, xid, 0, 0, 0, null, null);
        WireMessage wireMsg = enc.encode();
        wireMsg.encoder = enc;
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("Created ADCTRL TransactionCtrl XAPrepare Request", new Object[0]));
        }
        try {
            xaSessionMgr.addActiveTransaction(corrId, this._xaSession);
            this.setOutgoingMessage(enc, logMessage);
            this.sendRequest(xaSessionMgr, wireMsg, corrId, null, logMessage, AssuredCtrlEnums.XACtrlMessageType.XA_PREPARE_REQUEST);
        }
        finally {
            xaSessionMgr.removeActiveTransaction(corrId);
            this.unsetOutgoingMessage();
        }
        return 0;
    }

    public void checkClosedXASession() throws XAException {
        this._xaSession.checkClosedXA();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Xid[] recover(int flag) throws XAException {
        this._xaSession.checkClosedXA();
        this._xaSession.checkContext();
        String logMessage = String.format("XA Recover (XaSession[id=%s, name=%s] flags=%s)", String.valueOf(this._xaSession.getTransactedSessionId()), this._xaSession.getName(), this.getFlagsString(flag));
        if (flag != 0x1000000 && flag != 0x800000 && flag != 0 && flag != 0x1800000) {
            if (Trace.isWarnEnabled()) {
                Trace.warn((Object)String.format("Illegal flag in - %s, expecting one of [XAResource.TMSTARTRSCAN, XAResource.TMENDRSCAN, XAResource.TMSTARTRSCAN | XAResource.TMENDRSCAN, XAResource.TMNOFLAGS]", logMessage));
            }
            throw new XAException(-5);
        }
        if ((flag & 0x1000000) == 0x1000000) {
            this._scanStarted = (flag & 0x800000) != 0x800000;
        } else if (flag == 0x800000) {
            if (this._scanStarted) {
                this._scanStarted = false;
                return new Xid[0];
            }
        } else if (flag == 0 && this._scanStarted) {
            return new Xid[0];
        }
        XASessionManager xaSessionMgr = this._xaSession.getXASessionManager();
        try {
            ArrayList<XARecoverResponseParam> responses = new ArrayList<XARecoverResponseParam>();
            int numXids = 0;
            boolean done = false;
            boolean firstTime = true;
            boolean restart = false;
            XARecoverResponseParam respParam = null;
            XAWireMessageEncoder enc = null;
            WireMessage wireMsg = null;
            long corrTag = 0L;
            Integer connIdx = 0;
            while (!done) {
                corrTag = xaSessionMgr.getSubChannel().getGeneralSeqAllocator().getNext24b();
                if (firstTime || restart) {
                    connIdx = xaSessionMgr.getSubChannel().getConnCounterTag();
                    enc = new XAWireMessageEncoder(AssuredCtrlEnums.XACtrlMessageType.XA_RECOVER_REQUEST, this._xaSession, corrTag, null, flag, 0, 0, null, null);
                    wireMsg = enc.encode();
                    wireMsg.encoder = enc;
                    responses.clear();
                    numXids = 0;
                    firstTime = false;
                    restart = false;
                } else {
                    enc = new XAWireMessageEncoder(AssuredCtrlEnums.XACtrlMessageType.XA_RECOVER_REQUEST, this._xaSession, corrTag, null, flag, 0, 0, null, respParam.scanCursorData);
                    wireMsg = enc.encode();
                    wireMsg.encoder = enc;
                }
                try {
                    xaSessionMgr.addActiveTransaction(corrTag, this._xaSession);
                    this.setOutgoingMessage(enc, logMessage);
                    respParam = (XARecoverResponseParam)this.sendRequest(xaSessionMgr, wireMsg, corrTag, connIdx, logMessage, AssuredCtrlEnums.XACtrlMessageType.XA_RECOVER_REQUEST);
                }
                finally {
                    xaSessionMgr.removeActiveTransaction(corrTag);
                    this.unsetOutgoingMessage();
                }
                if (respParam == null) {
                    restart = true;
                    continue;
                }
                responses.add(respParam);
                numXids += respParam.xids.length;
                if (respParam.moreFlag) continue;
                done = true;
            }
            if (responses.size() == 1) {
                if (Trace.isInfoEnabled()) {
                    for (int j = 0; j < ((XARecoverResponseParam)responses.get((int)0)).xids.length; ++j) {
                        String msg = String.format("%s : recovered xid [%d] %s", logMessage, j + 1, ((XARecoverResponseParam)responses.get((int)0)).xids[j]);
                        Trace.info((Object)msg);
                    }
                }
                return ((XARecoverResponseParam)responses.get((int)0)).xids;
            }
            Xid[] xids = new Xid[numXids];
            int index = 0;
            for (int i = 0; i < responses.size(); ++i) {
                XARecoverResponseParam param = (XARecoverResponseParam)responses.get(i);
                for (int j = 0; j < param.xids.length; ++j) {
                    xids[index++] = param.xids[j];
                    if (!Trace.isInfoEnabled()) continue;
                    String msg = String.format("%s : recovered xid [%d] %s", logMessage, index, param.xids[j]);
                    Trace.info((Object)msg);
                }
            }
            return xids;
        }
        catch (XAException e) {
            throw e;
        }
        catch (Throwable t) {
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)("Error sending request for " + logMessage), t);
            }
            XAException e = new XAException(-3);
            e.initCause(t);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(Xid xid) throws XAException {
        this._xaSession.checkClosedXA();
        this._xaSession.checkContext();
        boolean doEnd = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._activeXid != null && this._activeXid.equals(xid)) {
                doEnd = true;
            }
        }
        if (doEnd) {
            this.end(xid, -1);
            return;
        }
        String logMessage = String.format("XA Rollback (XaSession[id=%s, name=%s], Xid=%s)", String.valueOf(this._xaSession.getTransactedSessionId()), this._xaSession.getName(), xid.toString());
        XASessionManager xaSessionMgr = this._xaSession.getXASessionManager();
        long corrId = xaSessionMgr.getSubChannel().getGeneralSeqAllocator().getNext24b();
        XAWireMessageEncoder enc = new XAWireMessageEncoder(AssuredCtrlEnums.XACtrlMessageType.XA_ROLLBACK_REQUEST, this._xaSession, corrId, xid, 0, 0, 0, null, null);
        WireMessage wireMsg = enc.encode();
        wireMsg.encoder = enc;
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("Created ADCTRL TransactionCtrl XARollback Request", new Object[0]));
        }
        try {
            xaSessionMgr.addActiveTransaction(corrId, this._xaSession);
            this.setOutgoingMessage(enc, logMessage);
            this.sendRequest(xaSessionMgr, wireMsg, corrId, null, logMessage, AssuredCtrlEnums.XACtrlMessageType.XA_ROLLBACK_REQUEST);
        }
        finally {
            xaSessionMgr.removeActiveTransaction(corrId);
            this.unsetOutgoingMessage();
        }
    }

    public synchronized boolean setTransactionTimeout(int seconds) throws XAException {
        this._xaSession.checkClosedXA();
        if (seconds < 0) {
            throw new IllegalArgumentException("transaction timeout cannot be less than 0");
        }
        this._transactionTimeout = seconds;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(Xid xid, int flags) throws XAException {
        this._xaSession.checkClosedXA();
        this._xaSession.checkContext();
        String logMessage = String.format("XA Start (XaSession[id=%s, name=%s], Xid=%s, flags=%s)", String.valueOf(this._xaSession.getTransactedSessionId()), this._xaSession.getName(), xid.toString(), this.getFlagsString(flags));
        if (flags != 0 && flags != 0x200000 && flags != 0x8000000) {
            if (Trace.isWarnEnabled()) {
                Trace.warn((Object)String.format("Illegal flag in - %s, expecting one of [XAResource.TMNOFLAGS, XAResource.TMJOIN, XAResource.TMRESUME]", logMessage));
            }
            throw new XAException(-5);
        }
        XASessionManager xaSessionMgr = this._xaSession.getXASessionManager();
        long corrId = xaSessionMgr.getSubChannel().getGeneralSeqAllocator().getNext24b();
        byte outFlags = 0;
        if (flags == 0x8000000) {
            outFlags = (byte)(outFlags | 1);
        } else if (flags == 0x200000) {
            outFlags = (byte)(outFlags | 2);
        }
        XAWireMessageEncoder enc = new XAWireMessageEncoder(AssuredCtrlEnums.XACtrlMessageType.XA_START_REQUEST, this._xaSession, corrId, xid, flags, outFlags, this._transactionTimeout, null, null);
        WireMessage wireMsg = enc.encode();
        wireMsg.encoder = enc;
        try {
            xaSessionMgr.addActiveTransaction(corrId, this._xaSession);
            this.setOutgoingMessage(enc, logMessage);
            try {
                this._xaSession.waitUntilAckComplete();
            }
            catch (InterruptedException e) {
                throw new XAException("start interrupted");
            }
            this.sendRequest(xaSessionMgr, wireMsg, corrId, null, logMessage, AssuredCtrlEnums.XACtrlMessageType.XA_START_REQUEST);
        }
        finally {
            xaSessionMgr.removeActiveTransaction(corrId);
            this.unsetOutgoingMessage();
        }
        Object object = this._lock;
        synchronized (object) {
            this._activeXid = xid;
            this._activeXidBeforeUnknownSessionNameFailure = false;
        }
    }

    /*
     * Exception decompiling
     */
    public void doStartActiveXidIfNeeded() throws JCSMPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerRequestRetransmit() {
        block8: {
            try {
                long currentCorrId = -1L;
                Object object = this._lock;
                synchronized (object) {
                    if (this._request != null) {
                        currentCorrId = this._request.getCorrId();
                    }
                }
                if (currentCorrId != -1L) {
                    if (Trace.isDebugEnabled()) {
                        Trace.debug((Object)("generate a request timeout event for corrId =" + currentCorrId));
                    }
                    this.handleTimeout(currentCorrId);
                }
            }
            catch (Throwable t) {
                if (!Trace.isInfoEnabled()) break block8;
                Trace.info((Object)"Error handling reconnect", t);
            }
        }
    }

    private static boolean clearActiveXid(XAWireMessageEncoder request, XAResponseParam response) {
        if (response.action != 1 && request.getXACtrlMessageType() == AssuredCtrlEnums.XACtrlMessageType.XA_END_REQUEST) {
            if (response.respCode == 0) {
                return true;
            }
            if ((request.getOrigFlags() & 0x2000000) == 0x2000000) {
                if (response.respCode == -6 || response.respCode == -4 || response.respCode == 100 || response.respCode == 107) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private static XAResponseParam parseResponse(XASessionManager xaSessionMgr, WireMessage response) throws XAException {
        try {
            XAResponseParam xaRespParam;
            SMFHeaderBean smfh = response.getSmfHeader();
            int resp_code = smfh.getPm_respcode();
            if (resp_code != -1 && resp_code != 200) {
                if (Trace.isInfoEnabled()) {
                    Trace.info((Object)(xaSessionMgr.getNetworkInfoString() + "Error Response (" + resp_code + ") - " + smfh.getPm_respstr()));
                }
                throw new JCSMPErrorResponseException(resp_code, smfh.getPm_respstr(), "", xaSessionMgr.getNetworkInfoString(), JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            }
            SMFHeaderBean smfHeader = response.getSmfHeader();
            if (smfHeader.getProtocol() != 9) {
                throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssuredCtrlResponseGotWrongType"));
            }
            if (!(response.getHeaderBean() instanceof AssuredCtrlHeaderBean)) {
                throw new InvalidMessageReceivedException(JCSMPRB.BUNDLE.getStringSafely("TcpPublisherChannel.expectedAssredCtrlResponseBlockNotFound"));
            }
            AssuredCtrlHeaderBean adctrl_response = (AssuredCtrlHeaderBean)response.getHeaderBean();
            SmfTLVParameter param = (SmfTLVParameter)adctrl_response.findFirstParameter(43);
            int corrTag = response.getSmfHeader().getPm_corrtag();
            byte[] data = param.value;
            byte xaMsgType = data[0];
            if (xaMsgType == AssuredCtrlEnums.XACtrlMessageType.XA_RESPONSE.smfEnc()) {
                xaRespParam = new XAResponseParam();
                xaRespParam.corrTag = corrTag;
                XAResourceImpl.parseXAResponseParam(xaRespParam, data, 1);
            } else if (xaMsgType == AssuredCtrlEnums.XACtrlMessageType.XA_RECOVER_RESPONSE.smfEnc()) {
                int offset = 2;
                byte flags = data[1];
                XARecoverResponseParam xaRecRespParam = new XARecoverResponseParam();
                xaRespParam = xaRecRespParam;
                xaRespParam.corrTag = corrTag;
                XAResourceImpl.parseXAResponseParam(xaRespParam, data, offset);
                offset += 8;
                boolean bl = xaRecRespParam.moreFlag = (flags & 1) == 1;
                if (xaRecRespParam.moreFlag) {
                    xaRecRespParam.scanCursorLength = (int)NetworkByteOrderNumberUtil.fourByteToUInt(data, offset);
                    xaRecRespParam.scanCursorData = new byte[xaRecRespParam.scanCursorLength];
                    System.arraycopy(data, offset += 4, xaRecRespParam.scanCursorData, 0, xaRecRespParam.scanCursorLength);
                    offset += xaRecRespParam.scanCursorLength;
                } else {
                    xaRecRespParam.scanCursorLength = 0;
                    xaRecRespParam.scanCursorData = null;
                }
                int numXids = (int)NetworkByteOrderNumberUtil.fourByteToUInt(data, offset);
                xaRecRespParam.xids = new Xid[numXids];
                XAResourceImpl.parseXids(numXids, xaRecRespParam.xids, data, offset += 4);
            } else {
                throw new XAException(String.format("Error parsing XAResponse, unknown response %d", xaMsgType));
            }
            return xaRespParam;
        }
        catch (XAException e) {
            throw e;
        }
        catch (Throwable t) {
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)"Error processing XA response", t);
            }
            XAException e = new XAException(-3);
            e.initCause(t);
            throw e;
        }
    }

    public void handleTimeout(long corrId) {
        this._responseQueue.add(new TimeoutException(corrId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAsyncAssuredCtrlMessage(WireMessage wmsg) {
        Object object = this._lock;
        synchronized (object) {
            try {
                XAResponseParam response = XAResourceImpl.parseResponse(this._xaSession.getXASessionManager(), wmsg);
                if (this._request == null) {
                    if (Trace.isDebugEnabled()) {
                        Trace.debug((Object)String.format("Stale response received with correllation tag %d", response.corrTag));
                    }
                } else if (this._request.getCorrId() == (long)response.corrTag) {
                    if (XAResourceImpl.clearActiveXid(this._request, response) && this._activeXid != null) {
                        this._xaSession.resetTransactionSteps();
                        this._activeXid = null;
                        if (this._activeXidBeforeUnknownSessionNameFailure) {
                            response.respCode = (byte)103;
                            response.respSubcode = 61L;
                            this._activeXidBeforeUnknownSessionNameFailure = false;
                        } else if (this._rollbackEndRequest) {
                            response.respCode = (byte)100;
                            response.respSubcode = 62L;
                        }
                    }
                    this._responseQueue.add(response);
                } else if (Trace.isDebugEnabled()) {
                    Trace.debug((Object)String.format("Stale response received with correllation tag %d", response.corrTag));
                }
            }
            catch (XAException e) {
                this._responseQueue.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOutgoingMessage(XAWireMessageEncoder enc, String logMessage) throws XAException {
        Object object = this._lock;
        synchronized (object) {
            if (this._request != null) {
                ConcurrentModificationException e = new ConcurrentModificationException(String.format("Already processing %s when a request to perform %s was received", this._outstandingMessageLog, logMessage));
                if (Trace.isInfoEnabled()) {
                    Trace.info((Object)"Error sending XA request", (Throwable)e);
                }
                XAException xae = new XAException(-3);
                xae.initCause(e);
                throw xae;
            }
            this._request = enc;
            this._outstandingMessageLog = logMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetOutgoingMessage() throws XAException {
        Object object = this._lock;
        synchronized (object) {
            this._request = null;
            this._outstandingMessageLog = null;
        }
    }

    /*
     * Exception decompiling
     */
    private XAResponseParam sendRequest(XASessionManager xaSessionMgr, WireMessage msgReq, long corrId, Integer connIdx, String logMessage, AssuredCtrlEnums.XACtrlMessageType xaMsgType) throws XAException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 20[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void parseXAResponseParam(XAResponseParam param, byte[] data, int offset) {
        byte action_Level = data[offset + 2];
        param.action = (byte)(action_Level >> 4);
        param.logLevel = (byte)(action_Level & 0xF);
        param.respCode = data[offset + 3];
        param.respSubcode = NetworkByteOrderNumberUtil.fourByteToUInt(data, offset + 4);
    }

    private static void parseXids(int numXids, Xid[] xids, byte[] data, int offset) {
        for (int i = 0; i < numXids; ++i) {
            int formatId = (int)NetworkByteOrderNumberUtil.fourByteToUInt(data, offset);
            offset += 4;
            byte txIdSize = data[offset++];
            byte branchQualSize = data[offset++];
            byte[] globalTxId = new byte[txIdSize];
            System.arraycopy(data, offset, globalTxId, 0, txIdSize);
            byte[] branchQual = new byte[branchQualSize];
            System.arraycopy(data, offset += txIdSize, branchQual, 0, branchQualSize);
            offset += branchQualSize;
            xids[i] = new SolXid(formatId, globalTxId, branchQual);
        }
    }

    private boolean isLoggingEnabled(int logLevel) {
        int mappedLogLevel = XAResponseCodes.getMappedLogLevel(logLevel);
        if (mappedLogLevel == -1) {
            return Trace.isFatalEnabled();
        }
        if (mappedLogLevel == 3) {
            return Trace.isErrorEnabled();
        }
        if (mappedLogLevel == 4) {
            return Trace.isWarnEnabled();
        }
        if (mappedLogLevel == 6) {
            return Trace.isInfoEnabled();
        }
        if (mappedLogLevel == 7) {
            return Trace.isDebugEnabled();
        }
        if (mappedLogLevel == 8) {
            return false;
        }
        return false;
    }

    private void log(int logLevel, String message) {
        String outMsg = message;
        int mappedLogLevel = XAResponseCodes.getMappedLogLevel(logLevel);
        if (logLevel != mappedLogLevel) {
            outMsg = String.format("(%s) %s", XAResponseCodes.getLogLevelString(logLevel), message);
        }
        if (mappedLogLevel == -1) {
            Trace.fatal((Object)outMsg);
        } else if (mappedLogLevel == 3) {
            Trace.error((Object)outMsg);
        } else if (mappedLogLevel == 4) {
            Trace.warn((Object)outMsg);
        } else if (mappedLogLevel == 6) {
            Trace.info((Object)outMsg);
        } else if (mappedLogLevel == 7) {
            Trace.debug((Object)outMsg);
        }
    }

    private String getFlagsString(int flags) {
        StringBuilder bldr = new StringBuilder();
        if (flags == 0) {
            bldr.append("TMNOFLAGS");
        } else {
            if (flags == -1) {
                if (bldr.length() > 0) {
                    bldr.append(",");
                }
                bldr.append("ROLLBACK");
            }
            if ((flags & 0x800000) == 0x800000) {
                if (bldr.length() > 0) {
                    bldr.append(",");
                }
                bldr.append("TMENDRSCAN");
            }
            if ((flags & 0x20000000) == 0x20000000) {
                if (bldr.length() > 0) {
                    bldr.append(",");
                }
                bldr.append("TMFAIL");
            }
            if ((flags & 0x200000) == 0x200000) {
                if (bldr.length() > 0) {
                    bldr.append(",");
                }
                bldr.append("TMJOIN");
            }
            if ((flags & 0x40000000) == 0x40000000) {
                if (bldr.length() > 0) {
                    bldr.append(",");
                }
                bldr.append("TMONEPHASE");
            }
            if ((flags & 0x8000000) == 0x8000000) {
                if (bldr.length() > 0) {
                    bldr.append(",");
                }
                bldr.append("TMRESUME");
            }
            if ((flags & 0x1000000) == 0x1000000) {
                if (bldr.length() > 0) {
                    bldr.append(",");
                }
                bldr.append("TMSTARTRSCAN");
            }
            if ((flags & 0x4000000) == 0x4000000) {
                if (bldr.length() > 0) {
                    bldr.append(",");
                }
                bldr.append("TMSUCCESS");
            }
            if ((flags & 0x2000000) == 0x2000000) {
                if (bldr.length() > 0) {
                    bldr.append(",");
                }
                bldr.append("TMSUSPEND");
            }
        }
        if (bldr.length() == 0) {
            bldr.append(flags);
        }
        return bldr.toString();
    }

    private static class TimeoutHandler
    implements JCSMPTimeoutHandler {
        private XAResourceImpl _xaResource;
        private long _corrId;

        public TimeoutHandler(XAResourceImpl xaResource, long corrId) {
            this._xaResource = xaResource;
            this._corrId = corrId;
        }

        public void handleTimeout() {
            this._xaResource.handleTimeout(this._corrId);
        }
    }

    private static class TimeoutException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private long _corrId;

        public TimeoutException(long corrId) {
            this._corrId = corrId;
        }

        public long getCorrId() {
            return this._corrId;
        }
    }
}

