/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solacesystems.common.util.DestinationUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.AccessDeniedException;
import com.solacesystems.jcsmp.BrowserProperties;
import com.solacesystems.jcsmp.CapabilityType;
import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.ConsumerFlowProperties;
import com.solacesystems.jcsmp.DurableTopicEndpoint;
import com.solacesystems.jcsmp.Endpoint;
import com.solacesystems.jcsmp.EndpointProperties;
import com.solacesystems.jcsmp.FlowEventHandler;
import com.solacesystems.jcsmp.FlowReceiver;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPErrorResponseException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPLogLevel;
import com.solacesystems.jcsmp.JCSMPProducerEventHandler;
import com.solacesystems.jcsmp.JCSMPReconnectEventHandler;
import com.solacesystems.jcsmp.JCSMPSession;
import com.solacesystems.jcsmp.JCSMPSessionStats;
import com.solacesystems.jcsmp.JCSMPStreamingPublishEventHandler;
import com.solacesystems.jcsmp.OperationNotSupportedException;
import com.solacesystems.jcsmp.ProducerFlowProperties;
import com.solacesystems.jcsmp.PropertyMismatchException;
import com.solacesystems.jcsmp.Queue;
import com.solacesystems.jcsmp.Requestor;
import com.solacesystems.jcsmp.SubscriberEndpoint;
import com.solacesystems.jcsmp.Subscription;
import com.solacesystems.jcsmp.SubscriptionStateProvider;
import com.solacesystems.jcsmp.Topic;
import com.solacesystems.jcsmp.TopicEndpoint;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageListener;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.AbstractDestination;
import com.solacesystems.jcsmp.impl.BrowserImpl;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPErrorResponseSubcodeMapper;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageConsumer;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.SessionSubscriptionEvent;
import com.solacesystems.jcsmp.impl.SessionSubscriptionEventListener;
import com.solacesystems.jcsmp.impl.SubscriptionCache;
import com.solacesystems.jcsmp.impl.flow.FlowHandleImpl;
import com.solacesystems.jcsmp.impl.flow.SubFlowManagerImpl;
import com.solacesystems.jcsmp.impl.requestreply.RequestorImpl;
import com.solacesystems.jcsmp.protocol.CSMPControllerChannel;
import com.solacesystems.jcsmp.protocol.CSMPPublisherChannel;
import com.solacesystems.jcsmp.protocol.CSMPSubscriberChannel;
import com.solacesystems.jcsmp.protocol.WireMessage;
import com.solacesystems.jcsmp.protocol.impl.TcpClientChannel;
import com.solacesystems.jcsmp.protocol.nio.impl.ConsumerNotificationDispatcherFactory;
import com.solacesystems.jcsmp.protocol.smf.AbstractTLVParameter;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlEnums;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.WireMessageFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionModeSupport
implements JCSMPSession,
SessionSubscriptionEventListener {
    protected static final String ERROR_OPERATION_NOT_SUPPORTED = JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.operationNotSupportedBasedOnSessionConfig");
    protected static final String MSG_CLOSING_EXISTING_PROD = "Closing existing XMLMessageProducer, new instance requested.";
    protected static final String MSG_CLOSING_EXISTING_CONS = "Closing existing XMLMessageConsumer, new instance requested.";
    private static final Log Trace = LogFactory.getLog(SessionModeSupport.class);
    protected CSMPControllerChannel controlChannel;
    protected CSMPPublisherChannel publisherChannel;
    protected CSMPSubscriberChannel subscriberChannel;
    protected TcpClientChannel clientChannel;
    protected SubFlowManagerImpl flowMgr;
    protected JCSMPBasicSession session;
    protected JCSMPXMLMessageProducer producer;
    protected JCSMPXMLMessageConsumer consumer;
    protected static final List<String> modifiableProperties = new ArrayList<String>();

    protected SessionModeSupport(CSMPControllerChannel controlChannel, CSMPPublisherChannel publisherChannel, CSMPSubscriberChannel subscriberChannel, TcpClientChannel clientChannel, SubFlowManagerImpl flowMgr, JCSMPBasicSession session) {
        this.controlChannel = controlChannel;
        this.publisherChannel = publisherChannel;
        this.subscriberChannel = subscriberChannel;
        this.clientChannel = clientChannel;
        this.flowMgr = flowMgr;
        this.session = session;
    }

    public synchronized JCSMPXMLMessageProducer getProducer() {
        return this.producer;
    }

    public JCSMPXMLMessageConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void closeSession() {
        this.controlChannel = null;
        this.publisherChannel = null;
        this.subscriberChannel = null;
        this.producer = null;
        this.consumer = null;
    }

    @Override
    public abstract void addSubscription(Subscription var1) throws JCSMPException;

    @Override
    public abstract void addSubscription(Subscription var1, boolean var2) throws JCSMPException;

    public abstract void addSubscription(Subscription var1, boolean var2, boolean var3) throws JCSMPException;

    @Override
    public abstract Consumer addSubscription(Subscription var1, XMLMessageListener var2, ConsumerNotificationDispatcherFactory var3) throws JCSMPException;

    @Override
    public abstract void removeSubscription(Subscription var1) throws JCSMPException;

    @Override
    public abstract void removeSubscription(Subscription var1, boolean var2) throws JCSMPException;

    public abstract void closeControlChannel();

    protected abstract XMLMessageConsumer doGetConsumer(SubscriptionStateProvider var1, JCSMPReconnectEventHandler var2, XMLMessageListener var3) throws JCSMPException;

    @Override
    public FlowReceiver createFlow(Endpoint endpoint, Subscription newSubscription, XMLMessageListener listener) throws JCSMPException {
        ConsumerFlowProperties cfp = new ConsumerFlowProperties();
        cfp.setEndpoint(endpoint).setNewSubscription(newSubscription);
        return this.createFlow(listener, cfp);
    }

    @Override
    public FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties f_prop) throws JCSMPException {
        return this.createFlow(listener, f_prop, null, null, null);
    }

    @Override
    public FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties f_prop, EndpointProperties e_prop) throws JCSMPException {
        return this.createFlow(listener, f_prop, e_prop, null, null);
    }

    @Override
    public FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties f_prop, EndpointProperties e_prop, FlowEventHandler flowEventHandler) throws JCSMPException {
        return this.createFlow(listener, f_prop, e_prop, null, flowEventHandler);
    }

    public FlowReceiver createFlow(XMLMessageListener listener, ConsumerFlowProperties f_prop, EndpointProperties e_prop, JCSMPBasicSession.InternalBindProperties internalBindProp, FlowEventHandler flowEventHandler) throws JCSMPException {
        FlowHandleImpl fr = null;
        if (this.subscriberChannel == null && this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        if (!this.session.isCapable(CapabilityType.SUB_FLOW_GUARANTEED)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoSubFlow"));
        }
        Endpoint endpoint = f_prop.getEndpoint();
        if (!endpoint.isDurable() && !this.session.isCapable(CapabilityType.TEMP_ENDPOINT)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoTempEndpoint"));
        }
        if (e_prop != null && e_prop.isRespectsMsgTTL() != null && e_prop.isRespectsMsgTTL().booleanValue() && !this.session.isCapable(CapabilityType.ENDPOINT_MESSAGE_TTL)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoEndpointTTL"));
        }
        if (e_prop != null && e_prop.getDiscardBehavior() != null && !this.session.isCapable(CapabilityType.ENDPOINT_DISCARD_BEHAVIOR)) {
            throw new InvalidOperationException("Capability Mismatch: Appliance does not support configurable endpoint discard behaviour.");
        }
        if (!this.session.isCapable(CapabilityType.MESSAGE_REPLAY) && f_prop.getReplayStartLocation() != null) {
            throw new InvalidOperationException("Capability Mismatch: Router does not support message replay");
        }
        this.session.waitUntilSessionReconnectDone("createFlow");
        if (endpoint instanceof Queue) {
            if (f_prop.isActiveFlowIndication() && !this.session.isCapable(CapabilityType.ACTIVE_FLOW_INDICATION)) {
                throw new InvalidOperationException("Capability Mistmatch: Appliance does not support active flow indication.");
            }
            if (f_prop.isActiveFlowIndication() && flowEventHandler == null) {
                throw new InvalidPropertiesException("Flow event handler cannot be null if active flow indication is set to true.");
            }
            if (f_prop.getNewSubscription() != null) {
                throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.topicMayNotBeProvided"));
            }
            this.validateBindTopicOrQueue((Queue)endpoint);
            try {
                fr = this.flowMgr.createQueueReceiver(f_prop, e_prop, listener, internalBindProp, flowEventHandler);
            }
            catch (JCSMPErrorResponseException e) {
                if (e.getResponseCode() == 403 && e.getSubcodeEx() == 36) {
                    throw new AccessDeniedException(e.getResponsePhrase(), (Throwable)((Object)e));
                }
                throw e;
            }
        } else if (endpoint instanceof TopicEndpoint) {
            if (((TopicEndpoint)endpoint).isDurable()) {
                DestinationUtil.isValidDTEPhysicalName(endpoint.getName());
            }
            if (!(f_prop.getNewSubscription() instanceof Topic)) {
                throw new IllegalArgumentException("Must provide Topic subscription.");
            }
            this.validateBindTopicOrQueue((Topic)f_prop.getNewSubscription());
            try {
                fr = this.flowMgr.createDurTopicEndpointReceiver(f_prop, e_prop, listener, internalBindProp, flowEventHandler);
            }
            catch (JCSMPErrorResponseException e) {
                if (e.getResponseCode() == 403 && e.getSubcodeEx() == 36) {
                    throw new AccessDeniedException(e.getResponsePhrase(), (Throwable)((Object)e));
                }
                throw e;
            }
        } else if (endpoint instanceof SubscriberEndpoint) {
            this.validateSubscriberEndpointValidEndpoint();
            fr = this.flowMgr.createSubscriberEndpointFlow(f_prop, listener, internalBindProp);
        } else {
            throw new IllegalArgumentException(String.format("wrong input type %s, expected Queue, TopicEndpoint or SubscriberEndpoint", endpoint.getClass()));
        }
        if (f_prop.isStartState()) {
            fr.start();
        }
        return fr;
    }

    public FlowReceiver createFlow(BrowserProperties b_prop) throws JCSMPException {
        return this.createFlow(b_prop, null, null);
    }

    public FlowReceiver createFlow(BrowserProperties b_prop, FlowEventHandler flowEventHandler, BrowserImpl browser) throws JCSMPException {
        try {
            FlowHandleImpl fr = this.flowMgr.createBrowser(b_prop, flowEventHandler, browser);
            fr.start();
            return fr;
        }
        catch (JCSMPErrorResponseException e) {
            if (e.getResponseCode() == 403 && e.getSubcodeEx() == 36) {
                throw new AccessDeniedException(e.getResponsePhrase(), (Throwable)((Object)e));
            }
            throw e;
        }
    }

    public abstract void validateSubscriberEndpointValidEndpoint() throws JCSMPException;

    public abstract void validateBindTopicOrQueue(AbstractDestination var1) throws JCSMPException;

    @Override
    public XMLMessageConsumer getMessageConsumer(XMLMessageListener listener) throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public XMLMessageConsumer getMessageConsumer() throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public XMLMessageConsumer getMessageConsumer(JCSMPReconnectEventHandler reconnectHandler, XMLMessageListener listener) throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public XMLMessageConsumer getMessageConsumer(JCSMPReconnectEventHandler reconnectHandler) throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider, XMLMessageListener listener) throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider) throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider, JCSMPReconnectEventHandler reconnectHandler, XMLMessageListener listener) throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public XMLMessageConsumer getMessageConsumer(SubscriptionStateProvider subscriptionStateProvider, JCSMPReconnectEventHandler reconnectHandler) throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler callback) throws JCSMPException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public XMLMessageProducer createProducer(ProducerFlowProperties fprop, JCSMPStreamingPublishEventHandler callback, JCSMPProducerEventHandler eventCallback) throws JCSMPException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public XMLMessageProducer getMessageProducer() throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public String getSessionName() {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public JCSMPSessionStats getSessionStats() {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public void logSessionStats(JCSMPLogLevel level) {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public void logFlowInfo(JCSMPLogLevel level) {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public boolean isClosed() {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public void removeSubscriber() throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    protected void throwUnmodifiablePropertyError(String property) {
        throw new IllegalArgumentException(String.format("Property '%s' is not a modifiable property in this session configuration.", property));
    }

    @Override
    public void unsubscribeDurableTopicEndpoint(DurableTopicEndpoint endpoint) throws JCSMPException {
        if (this.subscriberChannel == null && this.clientChannel == null) {
            throw new OperationNotSupportedException(ERROR_OPERATION_NOT_SUPPORTED);
        }
        if (!this.session.isCapable(CapabilityType.SUB_FLOW_GUARANTEED)) {
            throw new InvalidOperationException(JCSMPRB.BUNDLE.getStringSafely("JCSMPBasicSession.capabilityNoSubFlow"));
        }
        DestinationUtil.isValidDTEPhysicalName(endpoint.getName());
        this.flowMgr.unsubscribeDTE(endpoint.getName());
    }

    @Override
    public Object getProperty(String property) {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public Requestor createRequestor() throws JCSMPException {
        return new RequestorImpl(this.session);
    }

    @Override
    public Object getCapability(CapabilityType type) {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public boolean isCapable(CapabilityType ctype) {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public void connect() throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public Queue createTemporaryQueue() throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public Queue createTemporaryQueue(String name) throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public Topic createTemporaryTopic() throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public TopicEndpoint createNonDurableTopicEndpoint(String name) throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public TopicEndpoint createNonDurableTopicEndpoint() throws JCSMPException {
        throw new AssertionError((Object)"Should not be called.");
    }

    @Override
    public void notifySubscriptionEvent(SessionSubscriptionEvent ev) {
        SubscriptionCache cache = this.session.subscriptionCache;
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("Process subscription user event: [%s]", ev));
        }
        switch (ev.type) {
            case ADD_EVENT: {
                if (ev.sub != null) {
                    cache.add(ev.endpoint, ev.sub);
                }
                if (ev.subCollection == null) break;
                cache.add(ev.endpoint, ev.subCollection);
                break;
            }
            case ADD_FAILED: {
                int resp_subcode;
                Exception failureEx = ev.getException();
                if (failureEx instanceof JCSMPErrorResponseException && ((resp_subcode = ((JCSMPErrorResponseException)((Object)failureEx)).getSubcodeEx()) == 13 || resp_subcode == 44)) break;
                if (ev.sub != null) {
                    cache.remove(ev.endpoint, ev.sub);
                }
                if (ev.subCollection == null) break;
                for (Subscription s : ev.subCollection) {
                    cache.remove(ev.endpoint, s);
                }
                break;
            }
            case APPLY_EVENT: {
                HashSet<Subscription> newset = new HashSet<Subscription>(ev.subCollection);
                cache.replace(newset);
                break;
            }
            case APPLY_FAILED: {
                if (ev.subCollection == null) break;
                cache.remove(ev.endpoint, ev.subCollection);
                break;
            }
            case REM_EVENT: 
            case REM_FAILED: {
                if (ev.sub != null) {
                    cache.remove(ev.endpoint, ev.sub);
                }
                if (ev.subCollection != null) {
                    cache.remove(ev.endpoint, ev.subCollection);
                }
                if (ev.endpoint == null || ev.sub != null || ev.subCollection != null) break;
                cache.remove(ev.endpoint);
            }
        }
    }

    public abstract void reestablishSubCache() throws JCSMPException;

    @Override
    public Set<Subscription> getSubscriptionCache() {
        throw new AssertionError((Object)"Should not be called.");
    }

    public abstract WireMessage performProvisionEndpointCommand(WireMessage var1) throws JCSMPException;

    public abstract WireMessage performDeleteEndpointCommad(WireMessage var1) throws JCSMPException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deprovision(Endpoint endpoint, long deprovisionFlags) throws JCSMPException {
        AssuredCtrlHeaderBean adctrl_hdr = this.session.getAssuredCtrlFactory().createDeleteEndpointRequest(endpoint);
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setSmfVersion(3);
        smfHeader.setProtocol(9);
        smfHeader.setTtl(1);
        WireMessage req_msg = WireMessageFactory.createWith(smfHeader, adctrl_hdr);
        req_msg.setFriendlyName("ADCTRL-Deprovision");
        WireMessage response = this.performDeleteEndpointCommad(req_msg);
        int resp_code = response.getSmfHeader().getPm_respcode();
        String resp_string = response.getSmfHeader().getPm_respstr();
        boolean notifySubCache = true;
        try {
            if (resp_code != 200) {
                JCSMPErrorResponseException ex = new JCSMPErrorResponseException(resp_code, resp_string, "", this.clientChannel != null ? this.clientChannel.getNetworkInfoString() : "", JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
                if (Trace.isInfoEnabled()) {
                    Trace.info((Object)((this.clientChannel != null ? this.clientChannel.getNetworkInfoString() : "") + "Error Response (" + resp_code + ") - " + resp_string));
                }
                if (resp_code == 503 && (ex.getSubcodeEx() == 21 || ex.getSubcodeEx() == 20)) {
                    if ((deprovisionFlags & 2L) == 2L) {
                        return;
                    }
                    throw ex;
                }
                if (resp_code == 403 && ex.getSubcodeEx() == 36) {
                    notifySubCache = false;
                    throw new AccessDeniedException(resp_string, (Throwable)((Object)ex));
                }
                notifySubCache = false;
                throw ex;
            }
        }
        finally {
            if (notifySubCache) {
                this.session.notifySubscriptionEvent(new SessionSubscriptionEvent(endpoint, (Subscription)null, SessionSubscriptionEvent.SubscriptionEventType.REM_EVENT, null));
            }
        }
    }

    @Override
    public void provision(Endpoint endpoint, EndpointProperties props, long provisionFlags) throws JCSMPException {
        AssuredCtrlEnums.QueueAccessType q_acc_type = null;
        boolean understandTtl = this.session.isCapable(CapabilityType.ENDPOINT_MESSAGE_TTL);
        boolean understandDiscardBehaviour = this.session.isCapable(CapabilityType.ENDPOINT_DISCARD_BEHAVIOR);
        Integer accessType = null;
        Integer maxMsgSize = null;
        Integer permission = null;
        Integer quota = null;
        Boolean respectTTL = null;
        Integer discardBehaviour = null;
        Integer maxMsgRedelivery = null;
        if (props != null) {
            accessType = props.getAccessType();
            maxMsgSize = props.getMaxMsgSize();
            permission = props.getPermission();
            quota = props.getQuota();
            respectTTL = understandTtl ? props.isRespectsMsgTTL() : null;
            discardBehaviour = props.getDiscardBehavior();
            maxMsgRedelivery = props.getMaxMsgRedelivery();
        }
        if (discardBehaviour != null && !understandDiscardBehaviour) {
            throw new InvalidOperationException("Capability Mismatch: Router does not support configurable endpoint discard behaviour.");
        }
        if (accessType != null) {
            switch (accessType) {
                case 1: {
                    q_acc_type = AssuredCtrlEnums.QueueAccessType.EXCLUSIVE;
                    break;
                }
                case 0: {
                    q_acc_type = AssuredCtrlEnums.QueueAccessType.NON_EXCLUSIVE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Illegal AccessType (%s)", accessType));
                }
            }
        }
        AssuredCtrlHeaderBean adctrl_hdr = this.session.getAssuredCtrlFactory().createCreateEndpointRequest(endpoint, q_acc_type, quota, maxMsgSize, permission, respectTTL, discardBehaviour, maxMsgRedelivery);
        SMFHeaderBean smfHeader = new SMFHeaderBean();
        smfHeader.setSmfVersion(3);
        smfHeader.setProtocol(9);
        smfHeader.setTtl(1);
        WireMessage req_msg = WireMessageFactory.createWith(smfHeader, adctrl_hdr);
        req_msg.setFriendlyName("ADCTRL-Provision");
        WireMessage response = this.performProvisionEndpointCommand(req_msg);
        int resp_code = response.getSmfHeader().getPm_respcode();
        String resp_string = response.getSmfHeader().getPm_respstr();
        if (resp_code != 200) {
            JCSMPErrorResponseException ex = new JCSMPErrorResponseException(resp_code, resp_string, "", this.clientChannel != null ? this.clientChannel.getNetworkInfoString() : "", JCSMPErrorResponseSubcodeMapper.ErrorContext.CONTROL);
            if (Trace.isInfoEnabled()) {
                Trace.info((Object)((this.clientChannel != null ? this.clientChannel.getNetworkInfoString() : "") + "Error Response (" + resp_code + ") - " + resp_string));
            }
            if (resp_code == 400 && ex.getSubcodeEx() == 33 && (provisionFlags & 1L) == 1L) {
                return;
            }
            if (resp_code == 400 && ex.getSubcodeEx() == 40 && (provisionFlags & 1L) == 1L) {
                AbstractTLVParameter param;
                AssuredCtrlHeaderBean adctrl_resp = (AssuredCtrlHeaderBean)response.getHeaderBean();
                if (accessType != null && (param = adctrl_resp.findFirstParameter(12)) != null) {
                    if (accessType == 1) {
                        if (param.value[0] != AssuredCtrlEnums.QueueAccessType.EXCLUSIVE.smfEnc()) {
                            throw new PropertyMismatchException("Access Type mismatch.", "ACCESS_TYPE", 0);
                        }
                    } else if (param.value[0] != AssuredCtrlEnums.QueueAccessType.NON_EXCLUSIVE.smfEnc()) {
                        throw new PropertyMismatchException("Access Type mismatch.", "ACCESS_TYPE", 1);
                    }
                }
                if (maxMsgSize != null && (param = adctrl_resp.findFirstParameter(20)) != null) {
                    long returnedMaxMsgSize = NetworkByteOrderNumberUtil.fourByteToUInt(param.value);
                    if ((long)maxMsgSize.intValue() != returnedMaxMsgSize) {
                        throw new PropertyMismatchException("Max Message Size mismatch.", "MAX_MSG_SIZE", (int)returnedMaxMsgSize);
                    }
                }
                if (permission != null && (param = adctrl_resp.findFirstParameter(17)) != null) {
                    long perm_smf_val = NetworkByteOrderNumberUtil.fourByteToUInt(param.value);
                    long perm_sdk_val = AssuredCtrlEnums.permBitfieldToSdkPermission(perm_smf_val);
                    if ((long)permission.intValue() != perm_sdk_val) {
                        throw new PropertyMismatchException("Permission mismatch.", "ALL_OTHERS_PERMISSIONS", (int)perm_sdk_val);
                    }
                }
                if (quota != null && (param = adctrl_resp.findFirstParameter(19)) != null) {
                    long returnedQuota = NetworkByteOrderNumberUtil.fourByteToUInt(param.value);
                    if ((long)quota.intValue() != returnedQuota) {
                        throw new PropertyMismatchException("Quota mismatch.", "QUOTA", (int)returnedQuota);
                    }
                }
                if (respectTTL != null && (param = adctrl_resp.findFirstParameter(22)) != null) {
                    boolean bReturnedRespectTtl;
                    long returnedRespectTtl = NetworkByteOrderNumberUtil.oneByteToUInt(param.value[0]);
                    boolean bl = bReturnedRespectTtl = returnedRespectTtl == 1L;
                    if (respectTTL != bReturnedRespectTtl) {
                        throw new PropertyMismatchException("Respect TTL mismatch.", "RESPECT_TTL", bReturnedRespectTtl);
                    }
                }
                if (maxMsgRedelivery != null && (param = adctrl_resp.findFirstParameter(42)) != null) {
                    long returnedMaxMsgRedelivery = NetworkByteOrderNumberUtil.oneByteToUInt(param.value[0]);
                    if ((long)maxMsgRedelivery.intValue() != returnedMaxMsgRedelivery) {
                        throw new PropertyMismatchException("Max Redelivery mismatch.", "MAXREDELIVERY", (int)returnedMaxMsgRedelivery);
                    }
                }
                return;
            }
            throw ex;
        }
    }

    public String getHostId() {
        throw new AssertionError((Object)"Should not be called.");
    }

    static {
        modifiableProperties.add("application_description");
        modifiableProperties.add("client_name");
    }
}

