/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol.smf.impl;

import com.solacesystems.common.util.BitTwiddleUtil;
import com.solacesystems.common.util.NetworkByteOrderNumberUtil;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.WireEncoder;
import com.solacesystems.jcsmp.protocol.smf.SmpHeaderBean;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SmpHeaderEncoder
implements WireEncoder {
    ByteBuffer buf = ByteBuffer.allocate(4096);
    byte[] len_buf4 = new byte[4];

    public void encodeHeader(OutputStream in, HeaderDescriptionBean headerBean) throws IOException {
        SmpHeaderBean smp = (SmpHeaderBean)headerBean;
        this.buf.clear();
        long byte1 = 0L;
        long msglen = 0L;
        long byte6 = 0L;
        byte1 = BitTwiddleUtil.setBits(byte1, 1L, 1, 7);
        byte1 = BitTwiddleUtil.setBits(byte1, smp.getSmpMsgType(), 7, 0);
        msglen = BitTwiddleUtil.setBits(msglen, smp.getSmfEncodedLength(), 32, 0);
        byte6 = BitTwiddleUtil.setBits(byte6, smp.getSmpFlags(), 8, 0);
        this.buf.put(NetworkByteOrderNumberUtil.intToOneByte((int)byte1));
        NetworkByteOrderNumberUtil.intToFourByte(msglen, this.len_buf4, 0);
        this.buf.put(this.len_buf4);
        this.buf.put(NetworkByteOrderNumberUtil.intToOneByte((int)byte6));
        if (smp.getEncodedQueueName() != null) {
            this.buf.put(NetworkByteOrderNumberUtil.intToOneByte(smp.getEncodedQueueName().length));
            this.buf.put(smp.getEncodedQueueName());
            this.buf.put(NetworkByteOrderNumberUtil.intToOneByte(smp.getEncodedUtf8Subscription().length));
            this.buf.put(smp.getEncodedUtf8Subscription());
        } else if (smp.getEncodedClientName() != null) {
            this.buf.put(NetworkByteOrderNumberUtil.intToOneByte(smp.getEncodedClientName().length));
            this.buf.put(smp.getEncodedClientName());
            this.buf.put(NetworkByteOrderNumberUtil.intToOneByte(smp.getEncodedUtf8Subscription().length));
            this.buf.put(smp.getEncodedUtf8Subscription());
        } else {
            this.buf.put(smp.getEncodedUtf8Subscription());
        }
        this.buf.flip();
        byte[] clientdata = new byte[this.buf.limit()];
        this.buf.get(clientdata);
        in.write(clientdata);
        in.flush();
    }
}

